/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.interfaces.FunctionDao;
import de.unibamberg.minf.dme.dao.interfaces.GrammarDao;
import de.unibamberg.minf.dme.dao.interfaces.RelatedConceptDao;
import de.unibamberg.minf.dme.model.MappingWithSchemasImpl;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.pojo.AuthWrappedPojo;
import de.unibamberg.minf.dme.service.base.BaseEntityServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.MappingService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MappingServiceImpl
extends BaseEntityServiceImpl
implements MappingService {
    @Autowired
    private RelatedConceptDao relatedConceptDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private GrammarDao grammarDao;

    public List<RightsContainer<Mapping>> findAllByAuth(AuthPojo auth) {
        return this.mappingDao.findAllByUserId(auth.getUserId());
    }

    public RightsContainer<Mapping> findByIdAndAuth(String id, AuthPojo auth) {
        return this.mappingDao.findByIdAndUserId(id, auth.getUserId());
    }

    public Mapping findMappingById(String id) {
        return (Mapping)this.mappingDao.findEnclosedById(id);
    }

    public void saveMapping(AuthWrappedPojo<Mapping> mapping, AuthPojo auth) {
        boolean isNew;
        RightsContainer container = null;
        boolean bl = isNew = mapping.getId() == null || mapping.getId().equals("") || mapping.getId().equals("undefined");
        if (!isNew) {
            container = (RightsContainer)this.mappingDao.findById(mapping.getId());
        }
        if (container == null) {
            isNew = true;
            container = this.createContainer(auth.getUserId());
        }
        container.setElement((TrackedEntity)((Mapping)mapping.getPojo()));
        container.setReadOnly(mapping.isReadOnly());
        container.setDraft(mapping.isDraft());
        this.mappingDao.save((TrackedEntity)container, auth.getUserId(), auth.getSessionId());
        if (isNew) {
            this.saveRootReference(new RootReference(mapping.getId()));
        }
    }

    public void deleteMappingById(String id, AuthPojo auth) {
        RightsContainer s = (RightsContainer)this.mappingDao.findById(id);
        if (s != null && this.getUserCanWriteEntity(s, auth.getUserId())) {
            this.mappingDao.delete((TrackedEntity)s, auth.getUserId(), auth.getSessionId());
        }
    }

    private RightsContainer<Mapping> createContainer(String userId) {
        RightsContainer container = new RightsContainer();
        container.setOwnerId(userId);
        container.setId(new ObjectId().toString());
        container.setDraft(true);
        return container;
    }

    public List<RightsContainer<Mapping>> findAllByAuth(AuthPojo auth, boolean view) {
        List mappings = this.findAllByAuth(auth);
        if (!view) {
            return mappings;
        }
        ArrayList<String> schemaIds = new ArrayList<String>();
        for (RightsContainer m : mappings) {
            if (!schemaIds.contains(((Mapping)m.getElement()).getSourceId())) {
                schemaIds.add(((Mapping)m.getElement()).getSourceId());
            }
            if (schemaIds.contains(((Mapping)m.getElement()).getTargetId())) continue;
            schemaIds.add(((Mapping)m.getElement()).getTargetId());
        }
        Query qSchema = new Query();
        qSchema.fields().include("id");
        qSchema.fields().include("element");
        qSchema.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(schemaIds));
        List requiredSchemas = this.schemaDao.find(qSchema);
        HashMap<String, String> schemaIdLabelMap = new HashMap<String, String>(requiredSchemas.size());
        for (RightsContainer s : requiredSchemas) {
            schemaIdLabelMap.put(s.getId(), ((Datamodel)s.getElement()).getName());
        }
        for (RightsContainer m : mappings) {
            MappingWithSchemasImpl mExt = new MappingWithSchemasImpl();
            mExt.setId(((Mapping)m.getElement()).getId());
            mExt.setDescription(((Mapping)m.getElement()).getDescription());
            mExt.setSourceId(((Mapping)m.getElement()).getSourceId());
            mExt.setSourceLabel((String)schemaIdLabelMap.get(mExt.getSourceId()));
            mExt.setTargetId(((Mapping)m.getElement()).getTargetId());
            mExt.setTargetLabel((String)schemaIdLabelMap.get(mExt.getTargetId()));
            m.setElement((TrackedEntity)mExt);
        }
        return mappings;
    }

    public List<RightsContainer<Mapping>> getMappings(String entityId) {
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"element.sourceId").is((Object)entityId), Criteria.where((String)"element.targetId").is((Object)entityId)}));
        return this.mappingDao.find(q);
    }

    public List<RightsContainer<Mapping>> findAllByAuthAndSourceId(AuthPojo auth, String sourceId) {
        return this.mappingDao.findByCriteriaAndUserId(Criteria.where((String)"element.sourceId").is((Object)sourceId), auth.getUserId());
    }

    public List<RightsContainer<Mapping>> findAllByAuthAndTargetId(AuthPojo auth, String targetId) {
        return this.mappingDao.findByCriteriaAndUserId(Criteria.where((String)"element.targetId").is((Object)targetId), auth.getUserId());
    }

    public RightsContainer<Mapping> findByAuthAndSourceAndTargetId(AuthPojo auth, String sourceId, String targetId) {
        Criteria c = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"element.sourceId").is((Object)sourceId), Criteria.where((String)"element.targetId").is((Object)targetId)});
        List mappings = this.mappingDao.findByCriteriaAndUserId(c, auth.getUserId());
        if (mappings == null || mappings.isEmpty()) {
            return null;
        }
        return (RightsContainer)mappings.get(0);
    }

    public void changeDatamodelId(String currentId, String newId) {
        this.mappingDao.updateSourceModel(currentId, newId);
        this.mappingDao.updateTargetModel(currentId, newId);
    }

    public boolean changeId(String currentId, String id) {
        RightsContainer m = (RightsContainer)this.mappingDao.findById(currentId);
        m.setId(id);
        this.mappingDao.save((Identifiable)m);
        RootReference rootR = (RootReference)this.referenceDao.findById(currentId);
        rootR.setId(id);
        this.referenceDao.save((Identifiable)rootR);
        this.relatedConceptDao.updateEntityId(currentId, id);
        this.functionDao.updateEntityId(currentId, id);
        this.grammarDao.updateEntityId(currentId, id);
        this.mappingDao.delete(currentId);
        return true;
    }
}

