/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.ElementDao;
import de.unibamberg.minf.dme.dao.interfaces.FunctionDao;
import de.unibamberg.minf.dme.dao.interfaces.GrammarDao;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.datamodel.LabelImpl;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.service.base.BaseServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.IdentifiableService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class IdentifiableServiceImpl
extends BaseServiceImpl
implements IdentifiableService {
    @Autowired
    private ElementDao elementDao;
    @Autowired
    private GrammarDao grammarDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private GrammarService grammarService;

    public List<Identifiable> findByEntityId(String entityId) {
        Class[] entityTypes;
        ArrayList<Identifiable> result = new ArrayList<Identifiable>();
        for (Class entityType : entityTypes = new Class[]{Nonterminal.class, Label.class, GrammarImpl.class, FunctionImpl.class}) {
            if (entityType.equals(Nonterminal.class)) {
                result.addAll(this.elementDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId))));
                continue;
            }
            if (entityType.equals(Label.class)) {
                result.addAll(this.elementDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId))));
                continue;
            }
            if (entityType.equals(GrammarImpl.class)) {
                result.addAll(this.grammarDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId))));
                continue;
            }
            if (!entityType.equals(FunctionImpl.class)) continue;
            result.addAll(this.functionDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId))));
        }
        return result;
    }

    public List<Identifiable> findByNameAndSchemaId(String query, String schemaId, Class<?>[] entityTypes, List<String> excludeIds) {
        ArrayList<Identifiable> result = new ArrayList<Identifiable>();
        Pattern searchPattern = Pattern.compile(query, 66);
        if (entityTypes == null) {
            entityTypes = new Class[]{Nonterminal.class, Label.class, GrammarImpl.class, FunctionImpl.class};
        }
        for (Class<?> entityType : entityTypes) {
            if (entityType.equals(Nonterminal.class)) {
                result.addAll(this.elementDao.find(Query.query((CriteriaDefinition)this.getQueryCriteria(schemaId, NonterminalImpl.class.getName(), searchPattern, excludeIds))));
                continue;
            }
            if (entityType.equals(Label.class)) {
                result.addAll(this.elementDao.find(Query.query((CriteriaDefinition)this.getQueryCriteria(schemaId, LabelImpl.class.getName(), searchPattern, excludeIds))));
                continue;
            }
            if (entityType.equals(GrammarImpl.class)) {
                result.addAll(this.elementDao.find(Query.query((CriteriaDefinition)this.getQueryCriteria(schemaId, GrammarImpl.class.getName(), searchPattern, excludeIds))));
                continue;
            }
            if (!entityType.equals(FunctionImpl.class)) continue;
            result.addAll(this.elementDao.find(Query.query((CriteriaDefinition)this.getQueryCriteria(schemaId, FunctionImpl.class.getName(), searchPattern, excludeIds))));
        }
        return result;
    }

    private Criteria getQueryCriteria(String entityId, String elementType, Pattern searchPattern, List<String> excludeIds) {
        ArrayList<Criteria> subCriteria = new ArrayList<Criteria>();
        subCriteria.add(Criteria.where((String)"entityId").is((Object)entityId));
        subCriteria.add(Criteria.where((String)"_class").is((Object)elementType));
        subCriteria.add(Criteria.where((String)"name").is((Object)searchPattern));
        if (excludeIds != null) {
            subCriteria.add(Criteria.where((String)"id").nin(excludeIds));
        }
        return new Criteria().andOperator(subCriteria.toArray(new Criteria[0]));
    }

    public Identifiable findById(String id) {
        TrackedEntity i = this.elementDao.findById(id);
        if (i == null) {
            i = this.grammarDao.findById(id);
        }
        if (i == null) {
            i = this.functionDao.findById(id);
        }
        return i;
    }

    public List<Class<? extends ModelElement>> getAllowedSubelementTypes(String elementId) {
        Identifiable i = this.findById(elementId);
        if (i != null) {
            if (Nonterminal.class.isAssignableFrom(i.getClass())) {
                ArrayList<Class<? extends ModelElement>> allowedSubelementTypes = new ArrayList<Class<? extends ModelElement>>();
                allowedSubelementTypes.addAll(IdentifiableServiceImpl.getGrammarClasses());
                allowedSubelementTypes.addAll(IdentifiableServiceImpl.getNonterminalClasses());
                return allowedSubelementTypes;
            }
            if (Label.class.isAssignableFrom(i.getClass())) {
                ArrayList<Class<? extends ModelElement>> allowedSubelementTypes = new ArrayList<Class<? extends ModelElement>>();
                allowedSubelementTypes.addAll(IdentifiableServiceImpl.getGrammarClasses());
                allowedSubelementTypes.addAll(IdentifiableServiceImpl.getLabelClasses());
                return allowedSubelementTypes;
            }
            if (Grammar.class.isAssignableFrom(i.getClass())) {
                return IdentifiableServiceImpl.getFunctionClasses();
            }
            if (Function.class.isAssignableFrom(i.getClass())) {
                ArrayList<Class<? extends ModelElement>> allowedSubelementTypes = new ArrayList<Class<? extends ModelElement>>();
                allowedSubelementTypes.addAll(IdentifiableServiceImpl.getNonterminalClasses());
                allowedSubelementTypes.addAll(IdentifiableServiceImpl.getLabelClasses());
                return allowedSubelementTypes;
            }
        }
        return new ArrayList<Class<? extends ModelElement>>();
    }

    public static List<Class<? extends ModelElement>> getNonterminalClasses() {
        ArrayList<Class<? extends ModelElement>> result = new ArrayList<Class<? extends ModelElement>>();
        result.add(NonterminalImpl.class);
        result.add(Nonterminal.class);
        return result;
    }

    public static List<Class<? extends ModelElement>> getLabelClasses() {
        ArrayList<Class<? extends ModelElement>> result = new ArrayList<Class<? extends ModelElement>>();
        result.add(LabelImpl.class);
        result.add(Label.class);
        return result;
    }

    public static List<Class<? extends ModelElement>> getGrammarClasses() {
        ArrayList<Class<? extends ModelElement>> result = new ArrayList<Class<? extends ModelElement>>();
        result.add(GrammarImpl.class);
        result.add(Grammar.class);
        return result;
    }

    public static List<Class<? extends ModelElement>> getFunctionClasses() {
        ArrayList<Class<? extends ModelElement>> result = new ArrayList<Class<? extends ModelElement>>();
        result.add(FunctionImpl.class);
        result.add(Function.class);
        return result;
    }

    public static List<ModelElement> extractAllByTypes(ModelElement i, List<Class<? extends ModelElement>> allowedSubtreeRoots) {
        ArrayList<ModelElement> result;
        block10: {
            Function t;
            block13: {
                block12: {
                    block11: {
                        result = new ArrayList<ModelElement>();
                        if (i == null) break block10;
                        if (allowedSubtreeRoots.contains(i.getClass())) {
                            result.add(i);
                        }
                        if (!Nonterminal.class.isAssignableFrom(i.getClass())) break block11;
                        Nonterminal n = (Nonterminal)i;
                        if (n.getChildNonterminals() != null) {
                            for (Nonterminal nChild : n.getChildNonterminals()) {
                                result.addAll(IdentifiableServiceImpl.extractAllByTypes((ModelElement)nChild, allowedSubtreeRoots));
                            }
                        }
                        if (n.getGrammars() == null) break block10;
                        for (Grammar g : n.getGrammars()) {
                            result.addAll(IdentifiableServiceImpl.extractAllByTypes((ModelElement)g, allowedSubtreeRoots));
                        }
                        break block10;
                    }
                    if (!Label.class.isAssignableFrom(i.getClass())) break block12;
                    Label l = (Label)i;
                    if (l.getSubLabels() != null) {
                        for (Label lChild : l.getSubLabels()) {
                            result.addAll(IdentifiableServiceImpl.extractAllByTypes((ModelElement)lChild, allowedSubtreeRoots));
                        }
                    }
                    if (l.getGrammars() == null) break block10;
                    for (Grammar g : l.getGrammars()) {
                        result.addAll(IdentifiableServiceImpl.extractAllByTypes((ModelElement)g, allowedSubtreeRoots));
                    }
                    break block10;
                }
                if (!Grammar.class.isAssignableFrom(i.getClass())) break block13;
                Grammar g = (Grammar)i;
                if (g.getFunctions() == null) break block10;
                for (Function t2 : g.getFunctions()) {
                    result.addAll(IdentifiableServiceImpl.extractAllByTypes((ModelElement)t2, allowedSubtreeRoots));
                }
                break block10;
            }
            if (Function.class.isAssignableFrom(i.getClass()) && (t = (Function)i).getOutputElements() != null) {
                for (Element e : t.getOutputElements()) {
                    result.addAll(IdentifiableServiceImpl.extractAllByTypes((ModelElement)e, allowedSubtreeRoots));
                }
            }
        }
        return result;
    }

    public static List<ModelElement> extractAllByType(ModelElement i, String rootElementType) {
        if (rootElementType.equals(Nonterminal.class.getName()) || rootElementType.equals(NonterminalImpl.class.getName())) {
            return IdentifiableServiceImpl.extractAllByTypes((ModelElement)i, (List)IdentifiableServiceImpl.getNonterminalClasses());
        }
        if (rootElementType.equals(Label.class.getName()) || rootElementType.equals(LabelImpl.class.getName())) {
            return IdentifiableServiceImpl.extractAllByTypes((ModelElement)i, (List)IdentifiableServiceImpl.getLabelClasses());
        }
        if (rootElementType.equals(Grammar.class.getName()) || rootElementType.equals(GrammarImpl.class.getName())) {
            return IdentifiableServiceImpl.extractAllByTypes((ModelElement)i, (List)IdentifiableServiceImpl.getGrammarClasses());
        }
        if (rootElementType.equals(Function.class.getName()) || rootElementType.equals(FunctionImpl.class.getName())) {
            return IdentifiableServiceImpl.extractAllByTypes((ModelElement)i, (List)IdentifiableServiceImpl.getFunctionClasses());
        }
        return new ArrayList<ModelElement>(0);
    }

    public Reference saveHierarchy(ModelElement me, AuthPojo auth) {
        return this.saveHierarchy(me, auth, false);
    }

    public List<Reference> saveHierarchies(List<ModelElement> elements, AuthPojo auth) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        ArrayList saveElements = new ArrayList();
        ArrayList saveGrammars = new ArrayList();
        ArrayList saveFunctions = new ArrayList();
        for (ModelElement me : elements) {
            references.add(this.saveElementsInHierarchy(me, saveElements, saveGrammars, saveFunctions, false));
        }
        if (!saveElements.isEmpty()) {
            this.elementDao.saveNew(saveElements, auth.getUserId(), auth.getSessionId());
        }
        if (!saveGrammars.isEmpty()) {
            for (Grammar g : saveGrammars) {
                this.grammarService.saveGrammar((GrammarImpl)g, auth);
            }
        }
        if (!saveFunctions.isEmpty()) {
            this.functionDao.saveNew(saveFunctions, auth.getUserId(), auth.getSessionId());
        }
        return references;
    }

    public Reference saveHierarchy(ModelElement me, AuthPojo auth, boolean skipIdExisting) {
        ArrayList saveElements = new ArrayList();
        ArrayList saveGrammars = new ArrayList();
        ArrayList saveFunctions = new ArrayList();
        Reference r = this.saveElementsInHierarchy(me, saveElements, saveGrammars, saveFunctions, skipIdExisting);
        if (!saveElements.isEmpty()) {
            this.elementDao.saveNew(saveElements, auth.getUserId(), auth.getSessionId());
        }
        if (!saveGrammars.isEmpty()) {
            for (Grammar g : saveGrammars) {
                this.grammarService.saveGrammar((GrammarImpl)g, auth);
            }
        }
        if (!saveFunctions.isEmpty()) {
            this.functionDao.saveNew(saveFunctions, auth.getUserId(), auth.getSessionId());
        }
        return r;
    }

    private Reference saveElementsInHierarchy(ModelElement me, List<Element> saveElements, List<Grammar> saveGrammars, List<Function> saveFunctions, boolean skipIdExisting) {
        Reference r = new Reference();
        HashMap<String, List> subElementsMap = new HashMap<String, List>();
        boolean skip = false;
        if (me.getId() == null) {
            me.setId(BaseDaoImpl.createNewObjectId());
        } else {
            skip = skipIdExisting;
        }
        r.setReferenceId(me.getId());
        if (Element.class.isAssignableFrom(me.getClass())) {
            Element e = (Element)me;
            if (e.getGrammars() != null) {
                subElementsMap.put(GrammarImpl.class.getName(), e.getGrammars());
                e.setGrammars(null);
            }
            if (Nonterminal.class.isAssignableFrom(me.getClass())) {
                Nonterminal n = (Nonterminal)me;
                if (n.getChildNonterminals() != null) {
                    subElementsMap.put(NonterminalImpl.class.getName(), n.getChildNonterminals());
                    n.setChildNonterminals(null);
                }
            } else {
                Label l = (Label)e;
                if (l.getSubLabels() != null) {
                    subElementsMap.put(LabelImpl.class.getName(), l.getSubLabels());
                    l.setSubLabels(null);
                }
            }
            if (saveElements.contains(e) || saveGrammars.contains(me) || saveFunctions.contains(me)) {
                r.setReuse(true);
            } else if (skip) {
                r.setReuse(true);
            } else {
                saveElements.add(e);
            }
        } else if (Grammar.class.isAssignableFrom(me.getClass())) {
            Grammar g = (Grammar)me;
            if (g.getFunctions() != null) {
                subElementsMap.put(FunctionImpl.class.getName(), g.getFunctions());
                g.setFunctions(null);
            }
            if (saveGrammars.contains(me)) {
                r.setReuse(true);
                this.logger.debug("Recursion at " + g.getId());
            } else {
                saveGrammars.add(g);
            }
        } else if (Function.class.isAssignableFrom(me.getClass())) {
            Function f = (Function)me;
            ArrayList<Label> outputLabels = null;
            ArrayList<Nonterminal> outputNonterminals = null;
            if (f.getOutputElements() != null) {
                for (Element eOut : f.getOutputElements()) {
                    if (Nonterminal.class.isAssignableFrom(eOut.getClass())) {
                        if (outputNonterminals == null) {
                            outputNonterminals = new ArrayList<Nonterminal>();
                        }
                        outputNonterminals.add((Nonterminal)eOut);
                        continue;
                    }
                    if (outputLabels == null) {
                        outputLabels = new ArrayList<Label>();
                    }
                    outputLabels.add((Label)eOut);
                }
                if (outputLabels != null) {
                    subElementsMap.put(LabelImpl.class.getName(), outputLabels);
                }
                if (outputNonterminals != null) {
                    subElementsMap.put(NonterminalImpl.class.getName(), outputNonterminals);
                }
                f.setOutputElements(null);
            }
            if (saveFunctions.contains(f)) {
                r.setReuse(true);
                this.logger.debug("Recursion at " + f.getId());
            } else {
                saveFunctions.add(f);
            }
        }
        if (!subElementsMap.isEmpty()) {
            r.setChildReferences(new HashMap());
            for (String subclass : subElementsMap.keySet()) {
                ArrayList<Reference> subreferences = new ArrayList<Reference>();
                for (ModelElement childMe : (List)subElementsMap.get(subclass)) {
                    subreferences.add(this.saveElementsInHierarchy(childMe, saveElements, saveGrammars, saveFunctions, skipIdExisting));
                }
                r.getChildReferences().put(subclass, subreferences);
            }
        }
        return r;
    }
}

