/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.confg.MainConfig;
import de.unibamberg.minf.dme.dao.interfaces.GrammarDao;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.grammar.AuxiliaryFile;
import de.unibamberg.minf.dme.model.grammar.GrammarContainer;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.ReferenceHelper;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.service.base.BaseReferenceServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.gtf.MainEngine;
import de.unibamberg.minf.gtf.compilation.GrammarCompilationResult;
import de.unibamberg.minf.gtf.compilation.GrammarCompiler;
import de.unibamberg.minf.gtf.exceptions.GrammarProcessingException;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GrammarServiceImpl
extends BaseReferenceServiceImpl
implements GrammarService {
    @Autowired
    private GrammarDao grammarDao;
    @Autowired
    private MainEngine engine;
    @Autowired
    private MainConfig mainConfig;

    public Grammar createAndAppendGrammar(String schemaId, String parentElementId, String label, AuthPojo auth) {
        RootReference rRoot = this.findReferenceById(schemaId);
        Reference rParent = ReferenceHelper.findSubreference((Reference)rRoot, (String)parentElementId);
        GrammarImpl grammar = new GrammarImpl(schemaId, GrammarServiceImpl.getNormalizedName((String)label));
        grammar.setPassthrough(true);
        this.grammarDao.save((TrackedEntity)grammar, auth.getUserId(), auth.getSessionId());
        GrammarServiceImpl.addChildReference((Reference)rParent, (Identifiable)grammar);
        this.saveRootReference(rRoot);
        return grammar;
    }

    private String getGrammarDirectory(String grammarId, boolean temporary) {
        return this.mainConfig.getPaths().getGrammars() + File.separator + grammarId + File.separator;
    }

    private String getGrammarFilePrefix(String grammarId, boolean temporary) {
        return this.getGrammarDirectory(grammarId, temporary) + grammarId;
    }

    public void clearGrammar(Grammar g) {
        this.logger.info("Clearing {} grammar {}", (Object)(g.isTemporary() ? "temporary" : "persistent"), (Object)g.getIdentifier());
        this.engine.getDescriptionEngine().unloadGrammar(g.getIdentifier());
        this.engine.getDescriptionEngine().deleteGrammar(g.getIdentifier());
    }

    public GrammarCompilationResult saveTemporaryGrammar(Grammar grammar, GrammarContainer grammarContainer) throws IOException {
        GrammarCompilationResult result = new GrammarCompilationResult();
        this.saveGrammarToFilesystem(grammar, grammarContainer, true);
        File dirPath = new File(this.getGrammarDirectory(grammar.getIdentifier(), true));
        result.setResultingFiles(this.collectFileNames(dirPath, ".g4"));
        result.getResultingFiles().addAll(this.collectFileNames(dirPath, ".java"));
        return result;
    }

    public GrammarCompilationResult parseTemporaryGrammar(Grammar grammar) {
        GrammarCompiler grammarCompiler = new GrammarCompiler();
        File dirPath = new File(this.getGrammarDirectory(grammar.getIdentifier(), true));
        try {
            grammarCompiler.init(dirPath, grammar.getIdentifier());
            grammarCompiler.generateGrammar();
        }
        catch (GrammarProcessingException grammarProcessingException) {
            // empty catch block
        }
        grammarCompiler.getResult().setResultingFiles(this.collectFileNames(dirPath, ".java"));
        return grammarCompiler.getResult();
    }

    public GrammarCompilationResult compileTemporaryGrammar(Grammar grammar) throws IOException {
        GrammarCompiler grammarCompiler = new GrammarCompiler();
        File dirPath = new File(this.getGrammarDirectory(grammar.getIdentifier(), true));
        try {
            grammarCompiler.init(dirPath, grammar.getIdentifier());
            grammarCompiler.compileGrammar();
        }
        catch (GrammarProcessingException grammarProcessingException) {
            // empty catch block
        }
        grammarCompiler.getResult().setResultingFiles(this.collectFileNames(dirPath, ".class"));
        return grammarCompiler.getResult();
    }

    public List<String> getParserRules(Grammar grammar) throws GrammarProcessingException {
        GrammarCompiler grammarCompiler = new GrammarCompiler();
        grammarCompiler.init(new File(this.getGrammarDirectory(grammar.getIdentifier(), true)), grammar.getIdentifier());
        return grammarCompiler.getParserRules();
    }

    public void copyTemporaryGrammar(String grammarId) throws GrammarProcessingException {
    }

    private Collection<String> collectFileNames(File dirPath, String suffix) {
        if (dirPath == null || suffix == null) {
            return null;
        }
        Collection files = FileUtils.listFiles((File)dirPath, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)suffix), null);
        ArrayList<String> names = new ArrayList<String>();
        for (File f : files) {
            names.add(f.getName());
        }
        return names;
    }

    public void deleteGrammarsBySchemaId(String schemaId, AuthPojo auth) {
    }

    public Grammar deleteGrammarById(String schemaId, String id, AuthPojo auth) {
        Grammar grammar = (Grammar)this.grammarDao.findById(id);
        if (grammar != null) {
            try {
                this.removeReference(schemaId, id, auth);
                return grammar;
            }
            catch (Exception e) {
                this.logger.warn("An error occurred while deleting an element or its references. The owning schema {} might be in an inconsistent state", (Object)schemaId, (Object)e);
            }
        }
        return null;
    }

    public Grammar findById(String grammarId) {
        return (Grammar)this.grammarDao.findById(grammarId);
    }

    public void saveGrammar(GrammarImpl grammar, AuthPojo auth) {
        List transformationFunctions = grammar.getFunctions();
        grammar.setFunctions(null);
        grammar.setLocked(true);
        grammar.setTemporary(false);
        grammar.setName(GrammarServiceImpl.getNormalizedName((String)grammar.getName()));
        if (grammar.getGrammarContainer() != null && grammar.getGrammarContainer().getAuxiliaryFiles() != null) {
            grammar.getGrammarContainer().setAuxiliaryFiles(grammar.getGrammarContainer().getAuxiliaryFiles().stream().filter(f -> f.getContent() != null && !f.getContent().isBlank()).map(f -> {
                f.setFileName(f.getFileType().getFileName());
                return f;
            }).collect(Collectors.toList()));
        }
        if (auth != null) {
            this.grammarDao.save((TrackedEntity)grammar, auth.getUserId(), auth.getSessionId());
        } else {
            this.grammarDao.save((Identifiable)grammar);
        }
        grammar.setFunctions(transformationFunctions);
        if (grammar.isPassthrough()) {
            grammar.setError(false);
        } else {
            try {
                if (grammar.getGrammarContainer() == null) {
                    grammar.setGrammarContainer(new GrammarContainer());
                }
                this.saveGrammarToFilesystem((Grammar)grammar, grammar.getGrammarContainer(), false);
                GrammarCompiler grammarCompiler = new GrammarCompiler();
                grammarCompiler.init(new File(this.getGrammarDirectory(grammar.getIdentifier(), false)), grammar.getIdentifier());
                grammarCompiler.generateGrammar();
                grammarCompiler.compileGrammar();
                if ((grammar.getBaseMethod() == null || grammar.getBaseMethod().trim().isEmpty()) && grammarCompiler.getParserRules() != null && !grammarCompiler.getParserRules().isEmpty()) {
                    grammar.setBaseMethod((String)grammarCompiler.getParserRules().get(0));
                }
                if (grammarCompiler.getParserRules() != null && !grammarCompiler.getParserRules().contains(grammar.getBaseMethod())) {
                    grammar.setError(true);
                } else {
                    grammar.setError(false);
                }
            }
            catch (GrammarProcessingException | IOException e) {
                grammar.setError(true);
                this.logger.error("Error while processing saved grammar", e);
            }
        }
        grammar.setLocked(false);
        if (auth != null) {
            this.grammarDao.save((TrackedEntity)grammar, auth.getUserId(), auth.getSessionId());
        } else {
            this.grammarDao.save((Identifiable)grammar);
        }
    }

    private void saveGrammarToFilesystem(Grammar grammar, GrammarContainer grammarContainer, boolean temporary) throws IOException {
        String dirPath = this.getGrammarDirectory(grammar.getIdentifier(), temporary);
        String filePathPrefix = this.getGrammarFilePrefix(grammar.getIdentifier(), temporary);
        if (Files.exists(Paths.get(dirPath, new String[0]), new LinkOption[0])) {
            FileUtils.deleteDirectory((File)new File(dirPath));
        }
        Files.createDirectories(Paths.get(dirPath, new String[0]), new FileAttribute[0]);
        Object lexerGrammar = grammarContainer.getLexerGrammar();
        Object parserGrammar = grammarContainer.getParserGrammar();
        EnumMap<AuxiliaryFile.FileTypes, String> fileTypeNameMap = new EnumMap<AuxiliaryFile.FileTypes, String>(AuxiliaryFile.FileTypes.class);
        if (grammarContainer.getAuxiliaryFiles() != null) {
            for (AuxiliaryFile f : grammarContainer.getAuxiliaryFiles()) {
                String content = f.getContent().replace("{LEXER}", grammar.getIdentifier() + "Lexer").replace("{PARSER}", grammar.getIdentifier() + "Parser");
                Files.write(Paths.get(dirPath + f.getFileType().getFileName(), new String[0]), content.getBytes(), new OpenOption[0]);
                fileTypeNameMap.put(f.getFileType(), f.getFileType().getFileName().substring(0, f.getFileType().getFileName().indexOf(46)));
            }
        }
        if (lexerGrammar != null && !((String)lexerGrammar).trim().isEmpty()) {
            if (fileTypeNameMap.containsKey(AuxiliaryFile.FileTypes.LEXER_SUPERCLASS)) {
                lexerGrammar = "options { superClass= " + (String)fileTypeNameMap.get(AuxiliaryFile.FileTypes.LEXER_SUPERCLASS) + "; }\n\n" + (String)lexerGrammar;
            }
            lexerGrammar = "lexer grammar " + grammar.getIdentifier() + "Lexer;\n\n" + (String)lexerGrammar;
            Files.write(Paths.get(filePathPrefix + "Lexer.g4", new String[0]), ((String)lexerGrammar).getBytes(), new OpenOption[0]);
            parserGrammar = "parser grammar " + grammar.getIdentifier() + "Parser; options { tokenVocab= " + grammar.getIdentifier() + "Lexer; }\n\n" + (String)parserGrammar;
            Files.write(Paths.get(filePathPrefix + "Parser.g4", new String[0]), ((String)parserGrammar).getBytes(), new OpenOption[0]);
        } else {
            parserGrammar = "grammar " + grammar.getIdentifier() + ";\n\n" + (String)parserGrammar;
            Files.write(Paths.get(filePathPrefix + ".g4", new String[0]), ((String)parserGrammar).getBytes(), new OpenOption[0]);
        }
    }

    public List<Grammar> findByEntityId(String entityId, boolean includeSources) {
        if (!includeSources) {
            return this.grammarDao.findByEntityId(entityId);
        }
        return this.grammarDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId)));
    }

    public List<Grammar> findByIds(List<Object> grammarIds) {
        return this.grammarDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(grammarIds)));
    }

    public Map<String, GrammarContainer> serializeGrammarSources(String entityId) {
        List grammars = this.findByEntityId(entityId, false);
        return this.serializeGrammarSources(grammars);
    }

    public Map<String, GrammarContainer> serializeGrammarSources(List<Grammar> grammars) {
        HashMap<String, GrammarContainer> containers = new HashMap<String, GrammarContainer>();
        if (grammars != null) {
            for (Grammar g : this.getNonPassthroughGrammars(grammars)) {
                if (!GrammarImpl.class.isAssignableFrom(g.getClass())) continue;
                containers.put(g.getId(), ((GrammarImpl)g).getGrammarContainer());
            }
        }
        return containers;
    }

    public List<Grammar> getNonPassthroughGrammars(String entityId) {
        List grammars = this.findByEntityId(entityId, false);
        return this.getNonPassthroughGrammars(grammars);
    }

    public List<Grammar> getNonPassthroughGrammars(List<Grammar> grammars) {
        ArrayList<Grammar> result = new ArrayList<Grammar>();
        for (Grammar g : grammars) {
            if (g.isPassthrough() || g.isError() || g.isTemporary() || !GrammarImpl.class.isAssignableFrom(g.getClass())) continue;
            g = this.findById(g.getId());
            result.add(g);
        }
        return result;
    }
}

