/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.interfaces.FunctionDao;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.ReferenceHelper;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.service.base.BaseReferenceServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FunctionServiceImpl
extends BaseReferenceServiceImpl
implements FunctionService {
    @Autowired
    private FunctionDao functionDao;

    public Function createAndAppendFunction(String schemaId, String grammarId, String label, AuthPojo auth) {
        RootReference rRoot = this.findReferenceById(schemaId);
        Reference rParent = ReferenceHelper.findSubreference((Reference)rRoot, (String)grammarId);
        FunctionImpl grammar = new FunctionImpl(schemaId, FunctionServiceImpl.getNormalizedName((String)label));
        this.functionDao.save((TrackedEntity)grammar, auth.getUserId(), auth.getSessionId());
        FunctionServiceImpl.addChildReference((Reference)rParent, (Identifiable)grammar);
        this.saveRootReference(rRoot);
        return grammar;
    }

    public void deleteFunctionsBySchemaId(String schemaId) {
    }

    public Function deleteFunctionById(String schemaId, String id, AuthPojo auth) {
        Function function = (Function)this.functionDao.findById(id);
        if (function != null) {
            try {
                this.removeReference(schemaId, id, auth);
                return function;
            }
            catch (Exception e) {
                this.logger.warn("An error occurred while deleting an element or its references. The owning schema {} might be in an inconsistent state", (Object)schemaId, (Object)e);
            }
        }
        return null;
    }

    public Function findById(String functionId) {
        return (Function)this.functionDao.findById(functionId);
    }

    public void saveFunction(FunctionImpl function, AuthPojo auth) {
        List extElements = function.getExternalInputElements();
        function.setExternalInputElements(null);
        List outputElements = function.getOutputElements();
        function.setOutputElements(null);
        function.setName(FunctionServiceImpl.getNormalizedName((String)function.getName()));
        this.functionDao.save((TrackedEntity)function, auth.getUserId(), auth.getSessionId());
        function.setExternalInputElements(extElements);
        function.setOutputElements(outputElements);
    }

    public List<Function> findByEntityId(String entityId) {
        return this.functionDao.findByEntityId(entityId);
    }
}

