/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.interfaces.ElementDao;
import de.unibamberg.minf.dme.dao.interfaces.FunctionDao;
import de.unibamberg.minf.dme.dao.interfaces.GrammarDao;
import de.unibamberg.minf.dme.dao.interfaces.RelatedConceptDao;
import de.unibamberg.minf.dme.dao.interfaces.SchemaDao;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.BaseElement;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.base.Terminal;
import de.unibamberg.minf.dme.model.datamodel.LabelImpl;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import de.unibamberg.minf.dme.model.mapping.MappedConceptImpl;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.ReferenceHelper;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.service.base.BaseReferenceServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.IdentifiableService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ElementServiceImpl
extends BaseReferenceServiceImpl
implements ElementService {
    @Autowired
    private ElementDao elementDao;
    @Autowired
    private SchemaDao schemaDao;
    @Autowired
    private GrammarDao grammarDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private RelatedConceptDao relatedConceptDao;
    @Autowired
    private IdentifiableService identifiableService;

    public static Element findProcessingRoot(Element n) {
        return ElementServiceImpl.findProcessingRoot((Element)n, new ArrayList());
    }

    public Element findRootBySchemaId(String schemaId) {
        return this.findRootBySchemaId(schemaId, false);
    }

    public List<Element> findByIds(List<String> elementIds) {
        return this.elementDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(elementIds)));
    }

    public List<Element> findBySchemaId(String schemaId) {
        return this.elementDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)schemaId)));
    }

    public Reference assignChildTreeToParent(String entityId, String elementId, String childId) {
        RootReference rootRef = this.findReferenceById(entityId);
        if (rootRef.getChildReferences() == null) {
            return null;
        }
        Reference parent = null;
        Reference child = null;
        for (String className : rootRef.getChildReferences().keySet()) {
            List references = (List)rootRef.getChildReferences().get(className);
            if (references == null) continue;
            for (Reference ref : references) {
                if (parent == null) {
                    parent = ReferenceHelper.findSubreference((Reference)ref, (String)elementId);
                }
                if (child == null) {
                    child = ReferenceHelper.findSubreference((Reference)ref, (String)childId);
                }
                if (child == null || parent == null) continue;
                this.addChildReference(parent, child);
                this.moveMainReferencesToProcessedRoot((Reference)rootRef);
                this.saveRootReference(rootRef);
                return parent;
            }
        }
        return null;
    }

    public Reference replaceWithLink(String entityId, String elementId, String linkId) {
        RootReference rootRef = this.findReferenceById(entityId);
        if (rootRef.getChildReferences() == null) {
            return null;
        }
        Reference ref = ReferenceHelper.findSubreference((Reference)rootRef, (String)elementId);
        if (ref != null) {
            ArrayList<String> deleteElements = new ArrayList<String>();
            deleteElements.add(elementId);
            ReferenceHelper.getAllSubordinateIds((Reference)ref, deleteElements);
            ref.setReferenceId(linkId);
            ref.setReuse(true);
            this.saveRootReference(rootRef);
            this.elementDao.delete(deleteElements);
            return ref;
        }
        return null;
    }

    public Element findRootBySchemaId(String schemaId, boolean eagerLoadHierarchy) {
        RootReference reference = this.findReferenceById(schemaId);
        Reference rootElementReference = null;
        if (reference.getChildReferences() != null) {
            if (reference.getChildReferences().containsKey(NonterminalImpl.class.getName()) && ((List)reference.getChildReferences().get(NonterminalImpl.class.getName())).size() > 0) {
                if (((List)reference.getChildReferences().get(NonterminalImpl.class.getName())).size() == 1) {
                    rootElementReference = (Reference)((List)reference.getChildReferences().get(NonterminalImpl.class.getName())).get(0);
                } else {
                    for (int i = 0; i < ((List)reference.getChildReferences().get(NonterminalImpl.class.getName())).size(); ++i) {
                        if (!((Reference)((List)reference.getChildReferences().get(NonterminalImpl.class.getName())).get(i)).isRoot()) continue;
                        rootElementReference = (Reference)((List)reference.getChildReferences().get(NonterminalImpl.class.getName())).get(i);
                        break;
                    }
                }
            } else if (reference.getChildReferences().containsKey(MappedConceptImpl.class.getName()) && ((List)reference.getChildReferences().get(MappedConceptImpl.class.getName())).size() > 0) {
                rootElementReference = (Reference)((List)reference.getChildReferences().get(MappedConceptImpl.class.getName())).get(0);
            }
        }
        if (rootElementReference == null) {
            return null;
        }
        Element root = this.findById(rootElementReference.getReferenceId());
        if (!eagerLoadHierarchy) {
            return root;
        }
        List elements = this.getAllElements(schemaId);
        HashMap<String, Identifiable> elementMap = new HashMap<String, Identifiable>(elements.size());
        for (Identifiable e : elements) {
            elementMap.put(e.getId(), e);
        }
        return (Element)ReferenceHelper.fillElement(rootElementReference, elementMap);
    }

    public void saveOrReplaceRoot(String schemaId, Nonterminal element, AuthPojo auth) {
        this.clearElementTree(schemaId, auth);
        element.setId(null);
        element.setProcessingRoot(true);
        Reference r = this.identifiableService.saveHierarchy((ModelElement)element, auth);
        r.setRoot(true);
        RootReference root = this.findReferenceById(schemaId);
        ArrayList<Reference> childArray = new ArrayList<Reference>();
        childArray.add(r);
        root.setChildReferences(new HashMap());
        root.getChildReferences().put(element.getClass().getName(), childArray);
        this.saveRootReference(root);
    }

    public Element findById(String elementId) {
        return (Element)this.elementDao.findById(elementId);
    }

    public Identifiable getElementSubtree(String schemaId, String elementId) {
        Element root = this.findRootBySchemaId(schemaId, true);
        return this.getElementSubtree(root, new ArrayList(), elementId);
    }

    public List<Identifiable> getElementTrees(String schemaId, List<String> elementIds) {
        Element root = this.findRootBySchemaId(schemaId, true);
        ArrayList<Identifiable> result = new ArrayList<Identifiable>(elementIds.size());
        for (String elementId : elementIds) {
            result.add(this.getElementSubtree(root, new ArrayList(), elementId));
        }
        return result;
    }

    public <T extends Identifiable> List<Label> convertToLabels(List<T> elements) {
        ArrayList<Label> result = new ArrayList<Label>(elements.size());
        for (Identifiable i : elements) {
            if (!(i instanceof BaseElement)) continue;
            BaseElement e = (BaseElement)i;
            LabelImpl convert = new LabelImpl(e.getEntityId(), e.getName());
            convert.setId(e.getId());
            List subelements = e.getAllChildElements();
            if (subelements != null && subelements.size() > 0) {
                convert.setSubLabels(this.convertToLabels(subelements));
            }
            result.add((Label)convert);
        }
        return result;
    }

    public static List<Nonterminal> extractAllNonterminals(Element element) {
        if (!Nonterminal.class.isAssignableFrom(element.getClass())) {
            return new ArrayList<Nonterminal>();
        }
        Nonterminal root = (Nonterminal)element;
        ArrayList<Nonterminal> result = new ArrayList<Nonterminal>();
        if (root != null) {
            if (!result.contains(root)) {
                result.add(root);
            }
            if (root.getChildNonterminals() != null) {
                for (Nonterminal childN : root.getChildNonterminals()) {
                    result.addAll(ElementServiceImpl.extractAllNonterminals((Element)childN));
                }
            }
        }
        return result;
    }

    private Identifiable getElementSubtree(Element searchElement, List<String> searchedParentIds, String matchElementId) {
        if (searchElement.getId().equals(matchElementId)) {
            return searchElement;
        }
        if (searchedParentIds.contains(searchElement.getId())) {
            return null;
        }
        searchedParentIds.add(searchElement.getId());
        if (searchElement.getAllChildElements() != null) {
            for (Element subElem : searchElement.getAllChildElements()) {
                Identifiable result = this.getElementSubtree(subElem, searchedParentIds, matchElementId);
                if (result == null) continue;
                return result;
            }
        }
        if (searchElement.getGrammars() != null) {
            for (Grammar g : searchElement.getGrammars()) {
                if (g.getId().equals(matchElementId)) {
                    return g;
                }
                if (!g.hasFunctions()) continue;
                for (Function f : g.getFunctions()) {
                    if (!f.getId().equals(matchElementId)) continue;
                    return f;
                }
            }
        }
        return null;
    }

    public Element saveElement(Element e, AuthPojo auth) {
        if (e instanceof NonterminalImpl) {
            NonterminalImpl n = (NonterminalImpl)e;
            n.setName(ElementServiceImpl.getNormalizedName((String)n.getName()));
            List subelements = n.getChildNonterminals();
            n.setChildNonterminals(null);
            this.elementDao.save((TrackedEntity)e, auth.getUserId(), auth.getSessionId());
            n.setChildNonterminals(subelements);
        } else {
            LabelImpl l = (LabelImpl)e;
            l.setName(ElementServiceImpl.getNormalizedName((String)l.getName()));
            List subelements = l.getSubLabels();
            l.setSubLabels(null);
            this.elementDao.save((TrackedEntity)e, auth.getUserId(), auth.getSessionId());
            l.setSubLabels(subelements);
        }
        return e;
    }

    public Element createAndAppendElement(String schemaId, String parentElementId, String label, AuthPojo auth, Class<? extends Element> elementType) throws GenericScheregException {
        RootReference rRoot = this.findReferenceById(schemaId);
        Reference rParent = ReferenceHelper.findSubreference((Reference)rRoot, (String)parentElementId);
        NonterminalImpl element = null;
        if (rParent != null) {
            if (elementType.isAssignableFrom(Nonterminal.class)) {
                element = new NonterminalImpl(schemaId, ElementServiceImpl.getNormalizedName((String)label));
            } else if (elementType.isAssignableFrom(Label.class)) {
                element = new LabelImpl(schemaId, ElementServiceImpl.getNormalizedName((String)label));
            } else {
                throw new GenericScheregException("Unsupported type specified for element creation");
            }
            this.elementDao.save((TrackedEntity)element, auth.getUserId(), auth.getSessionId());
            ElementServiceImpl.addChildReference((Reference)rParent, (Identifiable)element);
            this.saveRootReference(rRoot);
        }
        return element;
    }

    public void removeElement(String schemaId, String elementId, AuthPojo auth) {
        Element eRemove = (Element)this.elementDao.findById(elementId);
        if (eRemove != null) {
            try {
                this.removeReference(schemaId, elementId, auth);
            }
            catch (Exception e) {
                this.logger.warn("An error occurred while deleting an element or its references. The owning schema {} might be in an inconsistent state", (Object)schemaId, (Object)e);
            }
        }
    }

    public void clearElementTree(String schemaId, AuthPojo auth) {
        Datamodel s = (Datamodel)this.schemaDao.findEnclosedById(schemaId);
        if (s != null) {
            try {
                this.clearReferenceTree(schemaId, auth);
                this.deleteAllElements(schemaId);
                try {
                    this.schemaDao.updateContained((TrackedEntity)s, auth.getUserId(), auth.getSessionId());
                }
                catch (GenericScheregException e) {
                    this.logger.error("Failed to save schema", (Throwable)e);
                }
            }
            catch (ClassNotFoundException | IllegalArgumentException e) {
                this.logger.error("Failed to remove tree by schemaID", (Throwable)e);
            }
        }
    }

    private long deleteAllElements(String entityId) {
        long result = this.elementDao.deleteAll(entityId);
        result += this.grammarDao.deleteAll(entityId);
        this.logger.info("Deleted all {} elements of model {}", (Object)(result += this.functionDao.deleteAll(entityId)), (Object)entityId);
        return result;
    }

    public Terminal removeTerminal(String schemaId, String terminalId, AuthPojo auth) {
        Datamodel s = (Datamodel)this.schemaDao.findEnclosedById(schemaId);
        Terminal tRemove = null;
        List terminals = ((XmlDatamodelNature)s.getNature(XmlDatamodelNature.class)).getTerminals();
        if (terminals != null) {
            for (Terminal t : terminals) {
                if (!t.getId().equals(terminalId)) continue;
                tRemove = t;
                break;
            }
        }
        if (tRemove != null) {
            terminals.remove(tRemove);
            try {
                this.schemaDao.updateContained((TrackedEntity)s, auth.getUserId(), auth.getSessionId());
            }
            catch (GenericScheregException e) {
                this.logger.error("Failed to save schema", (Throwable)e);
            }
            List elements = this.elementDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"schemaId").is((Object)schemaId).and("terminalId").is((Object)terminalId)));
            if (elements != null) {
                for (Element e : elements) {
                    ((XmlDatamodelNature)s.getNature(XmlDatamodelNature.class)).removeTerminalFromMap(tRemove.getId());
                    this.elementDao.save((TrackedEntity)e, auth.getUserId(), auth.getSessionId());
                }
            }
            return tRemove;
        }
        return null;
    }

    private List<Identifiable> getAllElements(String schemaId) {
        ArrayList<Identifiable> elements = new ArrayList<Identifiable>();
        elements.addAll(this.elementDao.findByEntityId(schemaId));
        elements.addAll(this.grammarDao.findByEntityId(schemaId));
        elements.addAll(this.functionDao.findByEntityId(schemaId));
        elements.addAll(this.relatedConceptDao.findByEntityId(schemaId));
        return elements;
    }

    public void unsetSchemaProcessingRoot(String schemaId) {
        Update update = new Update();
        update.set("processingRoot", (Object)false);
        update.set("includeHeader", (Object)false);
        update.set("hierarchicalRoot", (Object)false);
        this.elementDao.updateByQuery(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)schemaId).and("_class").is((Object)NonterminalImpl.class.getName())), update);
    }

    private Reference findCloneReference(Reference root, String elementId, boolean returnParent) {
        List parents = this.referenceDao.findParentsByChildId(root, elementId, null);
        for (Reference parent : parents) {
            for (String type : parent.getChildReferences().keySet()) {
                for (Reference child : (List)parent.getChildReferences().get(type)) {
                    if (!child.getReferenceId().equals(elementId) || child.isReuse()) continue;
                    return returnParent ? parent : child;
                }
            }
        }
        return null;
    }

    public void cloneElement(String elementId, String[] path, AuthPojo auth) {
        Element e = (Element)this.elementDao.findById(elementId);
        RightsContainer m = (RightsContainer)this.schemaDao.findById(e.getEntityId());
        RootReference rRoot = (RootReference)this.referenceDao.findById(e.getEntityId());
        Reference rCloneRefParent = this.findCloneReference((Reference)rRoot, elementId, true);
        Reference rCloneRef = this.findCloneReference(rCloneRefParent, elementId, false);
        HashMap referenceUsageMap = new HashMap();
        this.countReferenceUsage((Reference)rRoot, referenceUsageMap);
        List elements = this.getAllElements(e.getEntityId());
        HashMap<String, Identifiable> elementMap = new HashMap<String, Identifiable>(elements.size());
        for (Identifiable idE : elements) {
            elementMap.put(idE.getId(), idE);
        }
        Element eCloneRef = (Element)ReferenceHelper.fillElement((Reference)rCloneRef, elementMap);
        HashMap originalIdClonedNonterminalMap = new HashMap();
        ModelElement clonedE = this.cloneElementHierarchy((ModelElement)eCloneRef, referenceUsageMap, originalIdClonedNonterminalMap);
        Reference clonedR = this.identifiableService.saveHierarchy(clonedE, auth, true);
        this.assignTerminalIdsToClones((Datamodel)m.getElement(), originalIdClonedNonterminalMap);
        RootReference rParent = rRoot;
        for (int i = 0; i < path.length - 1; ++i) {
            rParent = this.navigateChild((Reference)rParent, path[i]);
        }
        Reference rComp = this.navigateChild((Reference)rParent, elementId);
        if (!rComp.equals(rCloneRef)) {
            this.replaceClonedChild((Reference)rParent, elementId, clonedR);
        } else {
            ArrayList<Reference> references = new ArrayList<Reference>();
            for (Reference refParent : this.referenceDao.findParentsByChildId(rCloneRef, elementId, null)) {
                if (refParent.equals(rCloneRefParent)) continue;
                references.add(refParent);
            }
            references.addAll(this.referenceDao.findParentsByChildId(clonedR, elementId, null));
            int i = 0;
            for (Reference rReplace : references) {
                if (i == 0) {
                    this.replaceClonedChild(rReplace, elementId, clonedR);
                } else {
                    Reference rReuse = new Reference();
                    rReuse.setReferenceId(clonedR.getReferenceId());
                    rReuse.setReuse(true);
                    this.replaceClonedChild(rReplace, elementId, rReuse);
                }
                ++i;
            }
        }
        this.referenceDao.save((Identifiable)rRoot);
        this.schemaDao.save((Identifiable)m);
    }

    public void moveMainReferencesToProcessedRoot(Reference entityReference) {
        if (entityReference.getChildReferences() == null) {
            return;
        }
        Reference rootRef = null;
        ArrayList<Reference> altRoots = new ArrayList<Reference>();
        for (String type : entityReference.getChildReferences().keySet()) {
            for (Reference rChild : (List)entityReference.getChildReferences().get(type)) {
                if (rootRef == null || rChild.isRoot()) {
                    rootRef = rChild;
                    continue;
                }
                altRoots.add(rChild);
            }
        }
        if (rootRef == null || altRoots.size() == 0) {
            return;
        }
        for (String type : rootRef.getChildReferences().keySet()) {
            for (Reference r : (List)rootRef.getChildReferences().get(type)) {
                this.detectAndMoveMissingReference(r, rootRef, rootRef, altRoots);
            }
        }
    }

    private void detectAndMoveMissingReference(Reference r, Reference parent, Reference root, List<Reference> altRoots) {
        Reference rCloneRef;
        if (r.isReuse() && (rCloneRef = this.findReusedReferenceParent(root, r.getReferenceId())) == null) {
            for (Reference altRoot : altRoots) {
                rCloneRef = this.findReusedReferenceParent(altRoot, r.getReferenceId());
                if (rCloneRef == null) continue;
                Reference rSwitch = this.navigateChild(rCloneRef, r.getReferenceId());
                this.replaceClonedChild(rCloneRef, r.getReferenceId(), r);
                this.replaceClonedChild(parent, r.getReferenceId(), rSwitch);
                this.logger.debug("Switched hidden reused nonterminal reference to visible position");
            }
        }
        if (r.getChildReferences() != null && r.getChildReferences().size() > 0) {
            for (String type : r.getChildReferences().keySet()) {
                for (Reference rChild : (List)r.getChildReferences().get(type)) {
                    this.detectAndMoveMissingReference(rChild, r, root, altRoots);
                }
            }
        }
    }

    private Reference findReusedReferenceParent(Reference searchRoot, String elementId) {
        if (searchRoot.getChildReferences() != null) {
            for (String type : searchRoot.getChildReferences().keySet()) {
                for (Reference rChild : (List)searchRoot.getChildReferences().get(type)) {
                    if (rChild.getReferenceId().equals(elementId) && !rChild.isReuse()) {
                        return searchRoot;
                    }
                    Reference r = this.findReusedReferenceParent(rChild, elementId);
                    if (r == null) continue;
                    return r;
                }
            }
        }
        return null;
    }

    private void assignTerminalIdsToClones(Datamodel m, Map<String, Nonterminal> originalIdClonedNonterminalMap) {
        for (String originalId : originalIdClonedNonterminalMap.keySet()) {
            for (DatamodelNature sn : m.getNatures()) {
                String terminalId = sn.getTerminalId(originalId);
                if (terminalId != null) {
                    try {
                        sn.mapNonterminal(originalIdClonedNonterminalMap.get(originalId).getId(), terminalId);
                    }
                    catch (MetamodelConsistencyException e1) {
                        this.logger.warn("Failed to reassign terminal to cloned nonterminal");
                    }
                    continue;
                }
                this.logger.warn("No terminal id detected for existing nonterminal [{}]", (Object)originalId);
            }
        }
    }

    private ModelElement cloneElementHierarchy(ModelElement me, Map<String, Integer> referenceUsageMap, Map<String, Nonterminal> originalIdClonedNonterminalMap) {
        Grammar g;
        if (me == null) {
            return null;
        }
        if (Grammar.class.isAssignableFrom(me.getClass()) && !(g = (Grammar)me).isPassthrough() && g.getGrammarContainer() == null) {
            g.setGrammarContainer(((Grammar)this.grammarDao.findById(me.getId())).getGrammarContainer());
        }
        ModelElement clone = me.cloneElement();
        if (Element.class.isAssignableFrom(me.getClass())) {
            ((Element)clone).setGrammars(this.cloneElementList(((Element)me).getGrammars(), referenceUsageMap, originalIdClonedNonterminalMap));
            if (Nonterminal.class.isAssignableFrom(me.getClass())) {
                originalIdClonedNonterminalMap.put(me.getId(), (Nonterminal)clone);
                ((Nonterminal)clone).setChildNonterminals(this.cloneElementList(((Nonterminal)me).getChildNonterminals(), referenceUsageMap, originalIdClonedNonterminalMap));
            } else {
                ((Label)clone).setSubLabels(this.cloneElementList(((Label)me).getSubLabels(), referenceUsageMap, originalIdClonedNonterminalMap));
            }
        } else if (Grammar.class.isAssignableFrom(me.getClass())) {
            ((Grammar)clone).setFunctions(this.cloneElementList(((Grammar)me).getFunctions(), referenceUsageMap, originalIdClonedNonterminalMap));
        } else if (Function.class.isAssignableFrom(me.getClass())) {
            ((Function)clone).setOutputElements(this.cloneElementList(((Function)me).getOutputElements(), referenceUsageMap, originalIdClonedNonterminalMap));
        }
        return clone;
    }

    private <T extends ModelElement> List<T> cloneElementList(List<T> labels, Map<String, Integer> referenceUsageMap, Map<String, Nonterminal> originalIdClonedNonterminalMap) {
        ArrayList<ModelElement> clones = null;
        if (labels != null) {
            clones = new ArrayList<ModelElement>(labels.size());
            for (ModelElement childL : labels) {
                if (referenceUsageMap.containsKey(childL.getId()) && referenceUsageMap.get(childL.getId()) > 1) {
                    clones.add(childL);
                    continue;
                }
                clones.add(this.cloneElementHierarchy(childL, referenceUsageMap, originalIdClonedNonterminalMap));
            }
        }
        return clones;
    }

    private void countReferenceUsage(Reference parent, Map<String, Integer> referenceUsageMap) {
        if (!referenceUsageMap.containsKey(parent.getReferenceId())) {
            referenceUsageMap.put(parent.getReferenceId(), 1);
        } else {
            referenceUsageMap.put(parent.getReferenceId(), referenceUsageMap.get(parent.getReferenceId()) + 1);
        }
        if (parent.getChildReferences() != null) {
            for (String type : parent.getChildReferences().keySet()) {
                for (Reference rChild : (List)parent.getChildReferences().get(type)) {
                    this.countReferenceUsage(rChild, referenceUsageMap);
                }
            }
        }
    }

    private Reference navigateChild(Reference parent, String childId) {
        for (String type : parent.getChildReferences().keySet()) {
            for (Reference r : (List)parent.getChildReferences().get(type)) {
                if (!r.getReferenceId().equals(childId)) continue;
                return r;
            }
        }
        return null;
    }

    private void replaceClonedChild(Reference parent, String originalChildId, Reference clonedChild) {
        for (String type : parent.getChildReferences().keySet()) {
            List refs = (List)parent.getChildReferences().get(type);
            for (int i = 0; i < refs.size(); ++i) {
                if (!((Reference)refs.get(i)).getReferenceId().equals(originalChildId)) continue;
                refs.set(i, clonedChild);
                return;
            }
        }
    }

    private static Element findProcessingRoot(Element e, List<String> visitedElementIds) {
        if (e == null) {
            return null;
        }
        if (e.isProcessingRoot()) {
            return e;
        }
        if (visitedElementIds.contains(e.getId())) {
            return null;
        }
        visitedElementIds.add(e.getId());
        for (Element c : e.getAllChildElements()) {
            Element eSub = ElementServiceImpl.findProcessingRoot((Element)c, visitedElementIds);
            if (eSub == null) continue;
            return eSub;
        }
        return null;
    }
}

