/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.profiles;

import de.unibamberg.minf.dme.service.UserServiceImpl;
import eu.dariah.de.dariahsp.ProfileActionHandler;
import eu.dariah.de.dariahsp.model.ExtendedUserProfile;
import eu.dariah.de.dariahsp.model.User;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserProfileActionHandler
implements ProfileActionHandler {
    private static final Logger log = LoggerFactory.getLogger(UserProfileActionHandler.class);
    @Autowired
    private UserServiceImpl userService;

    public void handleLogin(ExtendedUserProfile profile) {
        User u = this.userService.loadUserByUsername(profile.getIssuerId(), profile.getUsername());
        if (u == null) {
            u = profile.toUser();
        }
        u.setLastLogin(LocalDateTime.now());
        this.userService.saveUser(u);
        profile.setId(u.getId());
        log.debug("User has logged in: {}=>{}", (Object)profile.getId(), (Object)u.getId());
    }

    public void handleLogout(ExtendedUserProfile profile) {
        log.debug("User has logged out: {}", (Object)profile.getId());
    }
}

