/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.pojo.converter;

import de.unibamberg.minf.dme.dao.interfaces.UserDao;
import de.unibamberg.minf.dme.model.tracking.Change;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.model.tracking.ChangeType;
import de.unibamberg.minf.dme.pojo.ChangeSetPojo;
import eu.dariah.de.dariahsp.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangeSetPojoConverter {
    @Autowired
    private UserDao userDetailsDao;

    public Collection<ChangeSetPojo> convert(List<ChangeSet> changeSets, Locale locale) {
        HashMap<String, ChangeSetPojo> bySessionMap = new HashMap<String, ChangeSetPojo>();
        if (changeSets != null) {
            for (ChangeSet c : changeSets) {
                ChangeSetPojo cPojo;
                if (bySessionMap.containsKey(c.getSessionId())) {
                    cPojo = (ChangeSetPojo)bySessionMap.get(c.getSessionId());
                    if (c.getTimestamp() != null && (cPojo.getTimestamp() == null || c.getTimestamp().isAfter((ReadableInstant)cPojo.getTimestamp()))) {
                        cPojo.setTimestamp(c.getTimestamp());
                    }
                } else {
                    User ud;
                    cPojo = new ChangeSetPojo();
                    if (c.getUserId() != null && (ud = (User)this.userDetailsDao.findById(c.getUserId())) != null) {
                        cPojo.setUser(ud.getUsername());
                    }
                    if (cPojo.getUser() == null) {
                        cPojo.setUser(c.getUserId());
                    }
                    cPojo.setTimestamp(c.getTimestamp());
                }
                if (cPojo.getChanges() == null) {
                    cPojo.setChanges(new HashMap());
                }
                if (cPojo.getTimestamp() != null) {
                    cPojo.setTimestampString(cPojo.getTimestamp().toString(DateTimeFormat.patternForStyle((String)"M-", (Locale)locale)));
                }
                ArrayList<Change> elementChanges = new ArrayList<Change>();
                if (cPojo.getChanges().containsKey(c.getElementId())) {
                    elementChanges.addAll((Collection)cPojo.getChanges().get(c.getElementId()));
                }
                for (Change newC : c.getChanges()) {
                    elementChanges.add(newC);
                    if (newC.getChangeType() == ChangeType.EDIT_VALUE) {
                        cPojo.setEdits(cPojo.getEdits() + 1);
                        continue;
                    }
                    if (newC.getChangeType() == ChangeType.NEW_OBJECT) {
                        cPojo.setNews(cPojo.getNews() + 1);
                        continue;
                    }
                    if (newC.getChangeType() != ChangeType.DELETE_OBJECT) continue;
                    cPojo.setDeletes(cPojo.getDeletes() + 1);
                }
                cPojo.getChanges().put(c.getElementId(), c.getChanges());
                bySessionMap.put(c.getSessionId(), cPojo);
            }
        }
        return bySessionMap.values();
    }
}

