/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.pojo.converter;

import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.pojo.AuthWrappedPojo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AuthWrappedPojoConverter {
    public <T extends TrackedEntity> AuthWrappedPojo<T> convert(RightsContainer<T> element, String userId) {
        if (element == null || element.getElement() == null) {
            return null;
        }
        AuthWrappedPojo result = new AuthWrappedPojo();
        result.setPojo((Identifiable)element.getElement());
        result.setDraft(element.isDraft());
        result.setReadOnly(element.isReadOnly());
        if (userId != null) {
            result.setOwn(element.getOwnerId().equals(userId));
            result.setWrite(element.getWriteIds() == null || element.getWriteIds() != null && element.getWriteIds().contains(userId));
            result.setShare(element.getShareIds() == null || element.getShareIds() != null && element.getShareIds().contains(userId));
        }
        return result;
    }

    public <T extends TrackedEntity> List<AuthWrappedPojo<T>> convert(List<RightsContainer<T>> elements, String userId) {
        if (elements == null) {
            return null;
        }
        ArrayList<AuthWrappedPojo<T>> result = new ArrayList<AuthWrappedPojo<T>>(elements.size());
        for (RightsContainer<T> element : elements) {
            AuthWrappedPojo pojo = this.convert(element, userId);
            if (pojo == null) continue;
            result.add(pojo);
        }
        return result;
    }
}

