/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.model;

import com.fasterxml.jackson.databind.JsonNode;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.springframework.util.Assert;

public class SessionExecutionContext
implements ExecutionContext {
    public static final String SESSION_EXECUTION_DATA_FOLDERNAME = "session_execution_data";
    private final String pathPrefix;
    private final String sessionId;
    private final String workingDir;
    private final JsonNode sessionData;

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public JsonNode getSessionData() {
        return this.sessionData;
    }

    public SessionExecutionContext(String pathPrefix, String sessionId, JsonNode sessionData) throws IOException {
        Assert.notNull((Object)pathPrefix);
        Assert.notNull((Object)sessionId);
        this.pathPrefix = pathPrefix;
        this.sessionId = sessionId;
        this.workingDir = pathPrefix + File.separator + this.sessionId + File.separator + SESSION_EXECUTION_DATA_FOLDERNAME + File.separator;
        this.sessionData = sessionData;
        File workingDir = new File(this.workingDir);
        if (!workingDir.exists()) {
            FileUtils.forceMkdir((File)new File(this.workingDir));
        }
    }
}

