/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.model;

import de.unibamberg.minf.dme.model.tracking.Change;
import de.unibamberg.minf.dme.model.tracking.ChangeType;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import java.util.List;

public class RightsContainer<T extends TrackedEntity>
implements TrackedEntity {
    private static final long serialVersionUID = -1272567909444423065L;
    private String id;
    private T element;
    private boolean draft;
    private boolean readOnly;
    private String ownerId;
    private List<String> readIds;
    private List<String> writeIds;
    private List<String> shareIds;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        if (this.element != null) {
            this.element.setId(id);
        }
    }

    public T getElement() {
        return (T)this.element;
    }

    public void setElement(T element) {
        this.element = element;
        if (this.id != null && element != null) {
            this.element.setId(this.id);
        }
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.addChange(ChangeType.EDIT_VALUE, "draft", (Object)this.draft, (Object)draft);
        this.draft = draft;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.addChange(ChangeType.EDIT_VALUE, "readOnly", (Object)this.readOnly, (Object)readOnly);
        this.readOnly = readOnly;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public List<String> getReadIds() {
        return this.readIds;
    }

    public void setReadIds(List<String> readIds) {
        this.readIds = readIds;
    }

    public List<String> getWriteIds() {
        return this.writeIds;
    }

    public void setWriteIds(List<String> writeIds) {
        this.writeIds = writeIds;
    }

    public List<String> getShareIds() {
        return this.shareIds;
    }

    public void setShareIds(List<String> shareIds) {
        this.shareIds = shareIds;
    }

    public List<Change> flush() {
        if (this.element != null) {
            return this.element.flush();
        }
        return null;
    }

    public void addChanges(List<Change> changes) {
        if (this.element != null) {
            this.element.addChanges(changes);
        }
    }

    public void addChange(Change change) {
        if (this.element != null) {
            this.element.addChange(change);
        }
    }

    public <TVal> void addChange(ChangeType type, String key, TVal oldValue, TVal newValue) {
        if (this.element != null) {
            this.element.addChange(type, key, oldValue, newValue);
        }
    }

    public boolean isChanged() {
        return this.element == null ? false : this.element.isChanged();
    }
}

