/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unibamberg.minf.dme.model.LogEntry;
import de.unibamberg.minf.dme.model.SessionSampleFile;
import de.unibamberg.minf.dme.model.base.BaseIdentifiable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.data.annotation.Transient;

public class PersistedSession
extends BaseIdentifiable
implements Comparable<PersistedSession> {
    private static final long serialVersionUID = 6949914982830008951L;
    private String httpSessionId;
    private String entityId;
    private String userId;
    private String label;
    private DateTime lastAccessed;
    private DateTime created;
    private boolean notExpiring;
    private SessionSampleFile sampleFile;
    private int selectedOutputIndex;
    private int sampleMappedCount;
    private List<LogEntry> sessionLog;

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public DateTime getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(DateTime lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public boolean isNotExpiring() {
        return this.notExpiring;
    }

    public void setNotExpiring(boolean notExpiring) {
        this.notExpiring = notExpiring;
    }

    public int getSelectedOutputIndex() {
        return this.selectedOutputIndex;
    }

    public void setSelectedOutputIndex(int selectedOutputIndex) {
        this.selectedOutputIndex = selectedOutputIndex;
    }

    public List<LogEntry> getSessionLog() {
        return this.sessionLog;
    }

    public void setSessionLog(List<LogEntry> sessionLog) {
        this.sessionLog = sessionLog;
    }

    public SessionSampleFile getSampleFile() {
        return this.sampleFile;
    }

    public void setSampleFile(SessionSampleFile sampleFile) {
        this.sampleFile = sampleFile;
    }

    public int getSampleMappedCount() {
        return this.sampleMappedCount;
    }

    public void setSampleMappedCount(int sampleMappedCount) {
        this.sampleMappedCount = sampleMappedCount;
    }

    @Transient
    @JsonIgnore
    public boolean hasData() {
        return this.sampleFile != null && this.sampleFile.getPath() != null && new File(this.sampleFile.getPath()).exists();
    }

    public void addLogEntry(LogEntry entry) {
        if (this.getSessionLog() == null) {
            this.setSessionLog(new ArrayList());
        }
        this.getSessionLog().add(0, entry);
    }

    @Override
    public int compareTo(PersistedSession arg0) {
        return this.lastAccessed.compareTo((ReadableInstant)arg0.getLastAccessed());
    }
}

