/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.dme.confg.MainConfig;
import de.unibamberg.minf.dme.dao.interfaces.VersionInfoDao;
import de.unibamberg.minf.dme.migration.MigrationAction;
import de.unibamberg.minf.dme.migration.MigrationService;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.mapping.base.MappedConcept;
import de.unibamberg.minf.dme.model.version.VersionInfo;
import de.unibamberg.minf.dme.model.version.VersionInfoImpl;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MigrationServiceImpl
implements MigrationService {
    private static final Logger log = LoggerFactory.getLogger(MigrationServiceImpl.class);
    private static final String VERSION_HASH_PREFIX = "DME";
    @Autowired
    private MainConfig appConfig;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private VersionInfoDao versionDao;
    private final MessageDigest md = MessageDigest.getInstance("MD5");

    public void afterPropertiesSet() throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        List versionInfos = this.versionDao.findAll();
        for (VersionInfo vi : versionInfos) {
            if (!vi.getVersionHash().equals(new String(this.md.digest(new String(VERSION_HASH_PREFIX + vi.getVersion()).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8))) {
                log.error("Cancelling migration checks: failed to compare version hashes. Is the correct database configured?");
                return;
            }
            versions.add(vi.getVersion());
        }
        this.performMigrations(versions);
    }

    private void performMigrations(List<String> existingVersions) throws Exception {
        boolean backedUp;
        log.info("Backup performed: {}", (Object)(backedUp |= this.migrate(existingVersions, !(backedUp |= this.migrate(existingVersions, !(backedUp = false), "4.4", () -> this.migrateToReferenceId())), "4.5", () -> this.migrateToRelatedConcepts())));
    }

    private boolean migrate(List<String> existingVersions, boolean backup, String version, MigrationAction migration) throws Exception {
        if (version.equals("1.0") && existingVersions.isEmpty() || !version.equals("1.0") && !existingVersions.contains(version)) {
            log.info("Migrating to version [{}]", (Object)version);
            if (backup) {
                this.backupDb();
            }
            boolean success = migration.migrate();
            this.saveVersionInfo(version, success);
            log.info("Migration to version [{}] performed {}", (Object)version, (Object)(success ? "sucessfully" : "WITH ERRORS"));
            return true;
        }
        return false;
    }

    private boolean migrateToReferenceId() {
        for (String rawReference : this.getObjectsAsString("reference")) {
            try {
                ObjectNode objectNode = (ObjectNode)this.objectMapper.readTree(rawReference);
                this.migrateReferenceNode(objectNode, true);
                this.mongoTemplate.save((Object)objectNode.toString(), "reference");
            }
            catch (Exception e) {
                log.error("Failed to update database", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void migrateReferenceNode(ObjectNode referenceNode, boolean preserveOid) {
        if (referenceNode.get("_id") != null && !referenceNode.get("_id").isMissingNode() && referenceNode.get("_id").get("$oid") != null && !referenceNode.get("_id").get("$oid").isMissingNode()) {
            String referenceId = referenceNode.get("_id").get("$oid").asText();
            referenceNode.set("referenceId", (JsonNode)TextNode.valueOf((String)referenceId));
            if (!preserveOid) {
                referenceNode.remove("_id");
            }
        }
        if (referenceNode.get("childReferences") != null && !referenceNode.get("childReferences").isMissingNode()) {
            Iterator fieldIterator = referenceNode.get("childReferences").fields();
            while (fieldIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldIterator.next();
                if (!((JsonNode)field.getValue()).isArray()) continue;
                for (JsonNode childReferenceNode : (JsonNode)field.getValue()) {
                    if (!childReferenceNode.isObject()) continue;
                    this.migrateReferenceNode((ObjectNode)ObjectNode.class.cast(childReferenceNode), false);
                }
            }
        }
    }

    private boolean migrateToRelatedConcepts() {
        String sourceCollection = "mappedConcept";
        String targetCollection = "relatedConcept";
        if (!this.mongoTemplate.collectionExists("mappedConcept")) {
            return true;
        }
        try {
            List mappedConcepts = this.mongoTemplate.findAll(MappedConcept.class, "mappedConcept");
            for (MappedConcept mappedConcept : mappedConcepts) {
                this.mongoTemplate.save((Object)mappedConcept, "relatedConcept");
            }
            this.mongoTemplate.dropCollection("mappedConcept");
            return true;
        }
        catch (Exception e) {
            log.error("Failed to migrate mapped concepts to new relatedConcepts collection", (Throwable)e);
            return false;
        }
    }

    private boolean migrateChildReferenceKeys() {
        for (String rawReference : this.getObjectsAsString("reference")) {
            try {
                ObjectNode objectNode = (ObjectNode)this.objectMapper.readTree(rawReference);
                this.migrateChildReferenceKeys(objectNode, "de~unibamberg~minf~dme~model~mapping~MappedConceptImpl", "de~unibamberg~minf~dme~model~mapping~base~BaseRelatedConcept");
                this.mongoTemplate.save((Object)objectNode.toString(), "reference");
            }
            catch (Exception e) {
                log.error("Failed to update database", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void migrateChildReferenceKeys(ObjectNode referenceNode, String formerKey, String replaceKey) {
        if (referenceNode.get("childReferences") != null && !referenceNode.get("childReferences").isMissingNode()) {
            ObjectNode childReferencesNode = (ObjectNode)referenceNode.get("childReferences");
            JsonNode childReference = null;
            Iterator fieldIterator = referenceNode.get("childReferences").fields();
            while (fieldIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldIterator.next();
                if (((JsonNode)field.getValue()).isArray()) {
                    for (JsonNode childReferenceNode : (JsonNode)field.getValue()) {
                        if (!childReferenceNode.isObject()) continue;
                        this.migrateChildReferenceKeys((ObjectNode)ObjectNode.class.cast(childReferenceNode), formerKey, replaceKey);
                    }
                }
                if (!((String)field.getKey()).equals(formerKey)) continue;
                childReference = (JsonNode)field.getValue();
            }
            if (childReference != null) {
                childReferencesNode.set(replaceKey, childReference);
                childReferencesNode.remove(formerKey);
            }
        }
    }

    private void backupDb() throws Exception {
        String backupPath = this.appConfig.getPaths().getBackup() + File.separator + DateTime.now().toString(DateTimeFormat.forPattern((String)"yyyyMMdd_HHmmss"));
        Files.createDirectories(Paths.get(new File(backupPath).toURI()), new FileAttribute[0]);
        try {
            Runtime.getRuntime().exec(String.format("mongodump --out %s --db %s", backupPath, this.mongoTemplate.getDb().getName()));
            log.info("Backed up database {} to [{}]", (Object)this.mongoTemplate.getDb().getName(), (Object)backupPath);
        }
        catch (Exception e) {
            log.error("Failed to create mongodb backup", (Throwable)e);
        }
    }

    private void saveVersionInfo(String version, boolean success) {
        VersionInfoImpl vi = new VersionInfoImpl();
        vi.setUpdateWithErrors(!success);
        vi.setVersion(version);
        vi.setVersionHash(new String(this.md.digest(new String(VERSION_HASH_PREFIX + vi.getVersion()).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        this.versionDao.save((Identifiable)vi);
    }

    private List<String> getObjectsAsString(String queryObject) {
        return (List)this.mongoTemplate.execute(queryObject, (CollectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

