/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer.mapping.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.unibamberg.minf.dme.importer.mapping.json.BaseJsonMappingImporter;
import de.unibamberg.minf.dme.model.serialization.MappingContainer;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class JsonMappingImporter
extends BaseJsonMappingImporter {
    @Autowired
    protected ObjectMapper objectMapper;

    public boolean isKeepImportedIdsSupported() {
        return true;
    }

    public String getImporterSubtype() {
        return "Mapping";
    }

    public boolean getIsSupported() {
        if (super.getIsSupported()) {
            try {
                this.objectMapper.readValue(new File(this.importFilePath), MappingContainer.class);
                return true;
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
        }
        return false;
    }

    protected void importJson() {
        try {
            MappingContainer mc = (MappingContainer)this.objectMapper.readValue(new File(this.importFilePath), MappingContainer.class);
            this.importMapping(mc);
        }
        catch (Exception e) {
            this.logger.error("Failed to deserialize JSON mapping specification", (Throwable)e);
        }
    }
}

