/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer.mapping;

import de.unibamberg.minf.core.util.Stopwatch;
import de.unibamberg.minf.dme.exception.MappingImportException;
import de.unibamberg.minf.dme.importer.BaseImporter;
import de.unibamberg.minf.dme.importer.mapping.MappingImportListener;
import de.unibamberg.minf.dme.importer.mapping.MappingImporter;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.mapping.ExportedConceptImpl;
import de.unibamberg.minf.dme.model.mapping.MappedConceptImpl;
import de.unibamberg.minf.dme.model.mapping.base.ExportedConcept;
import de.unibamberg.minf.dme.model.mapping.base.MappedConcept;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.model.mapping.base.RelatedConcept;
import de.unibamberg.minf.dme.model.serialization.MappingContainer;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseMappingImporter
extends BaseImporter
implements MappingImporter {
    @Autowired
    private ElementService elementService;
    private Mapping mapping;
    private MappingImportListener importListener;
    private List<Element> sourceElements;
    private List<Element> targetElements;
    private Element sourceRootElement;
    private Element targetRootElement;
    private List<RelatedConcept> importedConcepts;
    private Map<String, String> importedFunctions;
    private Map<String, Grammar> importedGrammars;

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public MappingImportListener getImportListener() {
        return this.importListener;
    }

    public void setImportListener(MappingImportListener importListener) {
        this.importListener = importListener;
    }

    public void run() {
        block3: {
            Stopwatch sw = new Stopwatch().start();
            this.logger.debug("Started importing mapping {}", (Object)this.getMapping().getId());
            try {
                this.setupDatamodels();
                this.importJson();
                if (this.getImportListener() != null) {
                    this.logger.info("Finished importing mapping {} in {}ms", (Object)this.getMapping().getId(), (Object)sw.getElapsedTime());
                    this.getImportListener().registerImportFinished(this.getMapping(), this.importedConcepts, this.importedFunctions, this.importedGrammars, this.auth);
                }
            }
            catch (Exception e) {
                this.logger.error("Error while importing JSON Mapping", (Throwable)e);
                if (this.getImportListener() == null) break block3;
                this.getImportListener().registerImportFailed(this.getMapping());
            }
        }
    }

    protected void importMapping(MappingContainer mappingContainer) {
        this.importedConcepts = new ArrayList();
        this.importedFunctions = new HashMap();
        this.importedGrammars = new HashMap();
        if (mappingContainer.getMapping().getConcepts() != null) {
            for (RelatedConcept rc : mappingContainer.getMapping().getConcepts()) {
                String setId;
                MappedConceptImpl importedRc;
                if (rc.getTargetElementIds() == null) continue;
                HashMap targetElementIdMap = new HashMap();
                this.matchElementIds(targetElementIdMap, (Collection)rc.getTargetElementIds(), this.targetElements);
                this.matchElementPaths(targetElementIdMap, (Collection)rc.getTargetElementIds(), this.targetRootElement, mappingContainer.getElementPaths());
                HashMap sourceElementIdMap = new HashMap();
                this.matchElementIds(sourceElementIdMap, rc.getElementGrammarIdsMap().keySet(), this.sourceElements);
                this.matchElementPaths(sourceElementIdMap, rc.getElementGrammarIdsMap().keySet(), this.sourceRootElement, mappingContainer.getElementPaths());
                if (targetElementIdMap.isEmpty() || sourceElementIdMap.isEmpty()) continue;
                if (MappedConcept.class.isAssignableFrom(rc.getClass())) {
                    importedRc = new MappedConceptImpl();
                    MappedConcept mc = (MappedConcept)MappedConcept.class.cast(rc);
                    if (mc.getFunctionId() != null && mappingContainer.getFunctions().containsKey(mc.getFunctionId())) {
                        setId = this.getOrCreateId(mc.getFunctionId());
                        ((MappedConcept)MappedConcept.class.cast(importedRc)).setFunctionId(setId);
                        if (mappingContainer.getFunctions().get(mc.getFunctionId()) != null) {
                            this.importedFunctions.put(setId, (String)mappingContainer.getFunctions().get(mc.getFunctionId()));
                        }
                    }
                } else {
                    importedRc = new ExportedConceptImpl();
                    ((ExportedConcept)ExportedConcept.class.cast(importedRc)).setFormat(((ExportedConcept)ExportedConcept.class.cast(rc)).getFormat());
                }
                importedRc.setId(this.getOrCreateId(rc.getId()));
                importedRc.setEntityId(this.mapping.getId());
                importedRc.setTargetElementIds(new ArrayList(targetElementIdMap.values()));
                importedRc.setElementGrammarIdsMap(new HashMap());
                for (Map.Entry sourceElementEntry : sourceElementIdMap.entrySet()) {
                    String grammarId = (String)rc.getElementGrammarIdsMap().get(sourceElementEntry.getKey());
                    if (grammarId != null && mappingContainer.getGrammars() != null && mappingContainer.getGrammars().containsKey(grammarId)) {
                        setId = this.getOrCreateId(grammarId);
                        importedRc.getElementGrammarIdsMap().put((String)sourceElementEntry.getValue(), setId);
                        this.importedGrammars.put(setId, (Grammar)mappingContainer.getGrammars().get(grammarId));
                        break;
                    }
                    importedRc.getElementGrammarIdsMap().put((String)sourceElementEntry.getValue(), null);
                }
                this.importedConcepts.add(importedRc);
            }
        }
    }

    private void matchElementIds(Map<String, String> elementIdMap, Collection<String> elementIds, List<Element> matchElements) {
        for (String elementId : elementIds) {
            if (this.findElementById(elementId, matchElements) == null || elementIdMap.containsKey(elementId)) continue;
            elementIdMap.put(elementId, elementId);
        }
    }

    private void matchElementPaths(Map<String, String> elementIdMap, Collection<String> elementIds, Element rootElement, Map<String, String> elementPaths) {
        for (String elementId : elementIds) {
            Element e;
            if (elementIdMap.containsKey(elementId) || !elementPaths.containsKey(elementId) || (e = this.findElementByPath(elementPaths.get(elementId), rootElement)) == null) continue;
            elementIdMap.put(elementId, e.getId());
        }
    }

    private Element findElementByPath(String path, Element element) {
        if (!path.contains(".")) {
            return element.getName().equals(path) ? element : null;
        }
        String currentName = path.substring(0, path.indexOf(46));
        if (!element.getName().equals(currentName)) {
            return null;
        }
        String childPath = path.substring(path.indexOf(46) + 1);
        Element matchedChild = null;
        for (Element child : element.getAllChildElements()) {
            matchedChild = this.findElementByPath(childPath, child);
            if (matchedChild == null) continue;
            return matchedChild;
        }
        return null;
    }

    private Element findElementById(String id, List<Element> elements) {
        if (elements == null) {
            return null;
        }
        for (Element e : elements) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    private void setupDatamodels() throws MappingImportException {
        if (this.getMapping() == null) {
            throw new MappingImportException("No import target mapping specified");
        }
        this.sourceElements = this.elementService.findBySchemaId(this.getMapping().getSourceId());
        this.targetElements = this.elementService.findBySchemaId(this.getMapping().getTargetId());
        this.sourceRootElement = this.elementService.findRootBySchemaId(this.getMapping().getSourceId(), true);
        this.targetRootElement = this.elementService.findRootBySchemaId(this.getMapping().getTargetId(), true);
    }

    protected abstract void importJson();
}

