/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer.datamodel.xml;

import de.unibamberg.minf.core.util.Stopwatch;
import de.unibamberg.minf.dme.importer.datamodel.BaseDatamodelImporter;
import de.unibamberg.minf.dme.importer.datamodel.DatamodelImporter;
import de.unibamberg.minf.dme.importer.model.ImportAwareNonterminal;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.base.Terminal;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlNamespace;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlTerminal;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import de.unibamberg.minf.dme.model.tracking.ChangeType;
import de.unibamberg.minf.dme.service.IdentifiableServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.bson.types.ObjectId;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.w3c.dom.ls.LSInput;

@Component
@Scope(value="prototype")
public class XmlSchemaImporter
extends BaseDatamodelImporter
implements DatamodelImporter {
    private Map<String, XmlTerminal> existingTerminalQNs = new HashMap();
    private XSModel model;
    private String[] namespaces;
    private Map<String, List<ImportAwareNonterminal>> extensionIdNonterminalMap;
    private Map<String, ImportAwareNonterminal> terminalIdNonterminalMap;
    private XmlDatamodelNature xmlNature;

    public boolean isKeepImportedIdsSupported() {
        return false;
    }

    public String getMainImporterType() {
        return "XML";
    }

    public String getImporterSubtype() {
        return "XML Schema";
    }

    public String[] getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String[] namespaces) {
        this.namespaces = namespaces;
    }

    public void run() {
        block4: {
            try {
                Stopwatch sw = new Stopwatch().start();
                this.logger.debug(String.format("Started importing schema %s", this.getDatamodel().getId()));
                this.prepareXmlNature();
                this.extensionIdNonterminalMap = new HashMap();
                this.terminalIdNonterminalMap = new HashMap();
                this.importXmlSchema();
                if (this.getListener() != null) {
                    this.xmlNature.setNamespaces(new ArrayList());
                    for (String ns : this.namespaces) {
                        XmlNamespace namespace = new XmlNamespace("", ns);
                        namespace.setId(new ObjectId().toString());
                        namespace.addChange(ChangeType.NEW_OBJECT, "namespace", null, (Object)namespace.getId());
                        this.xmlNature.getNamespaces().add(namespace);
                    }
                    this.xmlNature.setTerminals(new ArrayList(this.existingTerminalQNs.values()));
                    this.logger.info(String.format("Finished importing schema %s in %sms", this.xmlNature.getId(), sw.getElapsedTime()));
                    this.getListener().registerImportFinished(this.getDatamodel(), this.getElementId(), this.getRootElements(), this.getAdditionalRootElements(), this.auth);
                }
            }
            catch (Exception e) {
                this.logger.error("Error while importing XML Schema", (Throwable)e);
                if (this.getListener() == null) break block4;
                this.getListener().registerImportFailed(this.getDatamodel());
            }
        }
    }

    public List<? extends ModelElement> getElementsByTypes(List<Class<? extends ModelElement>> allowedSubtreeRoots) {
        this.run();
        return IdentifiableServiceImpl.extractAllByTypes((ModelElement)((ModelElement)this.getRootElements().get(0)), allowedSubtreeRoots);
    }

    public boolean getIsSupported() {
        try {
            this.loadModel();
            if (this.model != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public List<XmlTerminal> getPossibleRootElements() {
        try {
            Stopwatch sw = new Stopwatch().start();
            this.loadModel();
            XSNamedMap elements = this.model.getComponents((short)2);
            ArrayList<XmlTerminal> rootTerminals = new ArrayList<XmlTerminal>(elements.getLength());
            for (int j = 0; j < elements.getLength(); ++j) {
                XSElementDecl elem = (XSElementDecl)elements.item(j);
                XmlTerminal root = new XmlTerminal();
                root.setName(elem.getName());
                root.setNamespace(elem.getNamespace());
                rootTerminals.add(root);
            }
            this.logger.debug("Detection of possible root nonterminals took {}ms", (Object)sw.getElapsedTime());
            return rootTerminals;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void prepareXmlNature() {
        if (this.getDatamodel().getNature(XmlDatamodelNature.class) != null) {
            this.xmlNature = (XmlDatamodelNature)this.getDatamodel().getNature(XmlDatamodelNature.class);
        } else {
            this.xmlNature = new XmlDatamodelNature();
            this.xmlNature.setId(this.getDatamodel().getId());
            this.getDatamodel().addOrReplaceNature((DatamodelNature)this.xmlNature);
        }
        XmlTerminal rootTerminal = null;
        for (Terminal possibleRoot : this.getPossibleRootElements()) {
            String compQN = this.createTerminalQN(((XmlTerminal)possibleRoot).getNamespace(), possibleRoot.getName(), ((XmlTerminal)possibleRoot).isAttribute());
            if (!compQN.equals(this.getRootElementName())) continue;
            rootTerminal = (XmlTerminal)possibleRoot;
            break;
        }
        this.xmlNature.setRootElementNamespace(rootTerminal.getNamespace());
        this.xmlNature.setRootElementName(rootTerminal.getName());
    }

    private void loadModel() {
        XSImplementation impl = (XSImplementation)new DOMXSImplementationSourceImpl().getDOMImplementation("XS-Loader");
        XSLoader schemaLoader = impl.createXSLoader(null);
        try {
            String s = FileUtils.readFileToString((File)new File(this.importFilePath), (Charset)StandardCharsets.UTF_8);
            if (!s.startsWith("<?xml")) {
                s = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>%s", s);
            }
            DOMInputImpl ls = new DOMInputImpl();
            ls.setByteStream(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
            this.model = schemaLoader.load((LSInput)ls);
        }
        catch (IOException e) {
            this.logger.error("Failed to load file", (Throwable)e);
            this.model = null;
        }
    }

    protected void importXmlSchema() throws MetamodelConsistencyException {
        Stopwatch sw = new Stopwatch().start();
        this.loadModel();
        XSNamespaceItemList nsList = this.model.getNamespaceItems();
        if (nsList != null && nsList.getLength() > 0) {
            this.namespaces = new String[nsList.getLength()];
            for (int i = 0; i < nsList.getLength(); ++i) {
                this.namespaces[i] = nsList.item(i).getSchemaNamespace();
            }
        }
        Nonterminal rootN = this.getRoot(this.xmlNature.getRootElementNamespace(), this.xmlNature.getRootElementName());
        rootN.setProcessingRoot(true);
        this.getRootElements().add(rootN);
        XSNamedMap elements = this.model.getComponents((short)2);
        HashMap<CallSite, XmlTerminal> rootTerminals = new HashMap<CallSite, XmlTerminal>();
        for (int j = 0; j < elements.getLength(); ++j) {
            XSElementDecl elem = (XSElementDecl)elements.item(j);
            XmlTerminal root = new XmlTerminal();
            root.setName(elem.getName());
            root.setNamespace(elem.getNamespace());
            String terminalQN = this.createTerminalQN(elem.getNamespace(), elem.getName(), false);
            if (this.existingTerminalQNs.containsKey(terminalQN)) continue;
            rootTerminals.put((CallSite)((Object)(root.getName() + ":" + root.getNamespace())), root);
        }
        HashMap serializedNonterminals = new HashMap();
        ArrayList processedN = new ArrayList();
        if (rootTerminals.size() == 0) {
            this.combineExtensionNonterminals();
            this.resolveExtensionHierarchy((ImportAwareNonterminal)this.getRootElements().get(0), processedN);
            rootN = this.convertToSerializableNonterminals((ImportAwareNonterminal)this.getRootElements().get(0), serializedNonterminals);
            rootN.setProcessingRoot(true);
            this.getRootElements().set(0, rootN);
            this.logger.debug("Schema import took {}ms", (Object)sw.getElapsedTime());
            return;
        }
        ArrayList<Nonterminal> potentialRootElements = new ArrayList<Nonterminal>(rootTerminals.keySet().size());
        for (String qn : rootTerminals.keySet()) {
            XmlTerminal additionalRootTerminal = (XmlTerminal)rootTerminals.get(qn);
            Nonterminal additionalRootNonterminal = this.getRoot(additionalRootTerminal.getNamespace(), additionalRootTerminal.getName());
            if (additionalRootNonterminal == null) continue;
            potentialRootElements.add(additionalRootNonterminal);
        }
        ArrayList compareN = new ArrayList(potentialRootElements);
        ArrayList checkedReuseN = new ArrayList();
        block3: for (Nonterminal addRoot : potentialRootElements) {
            for (ModelElement compareRoot : compareN) {
                if (addRoot.equals(compareRoot) || !this.getChildrenContainTerminalId((Identifiable)compareRoot, this.xmlNature.getTerminalId(addRoot.getId()), checkedReuseN)) continue;
                compareN.remove(addRoot);
                continue block3;
            }
        }
        this.setAdditionalRootElements(compareN);
        this.combineExtensionNonterminals();
        this.resolveExtensionHierarchy((ImportAwareNonterminal)this.getRootElements().get(0), processedN);
        rootN = this.convertToSerializableNonterminals((ImportAwareNonterminal)this.getRootElements().get(0), serializedNonterminals);
        rootN.setProcessingRoot(true);
        this.getRootElements().set(0, rootN);
        for (int i = 0; i < this.getAdditionalRootElements().size(); ++i) {
            this.resolveExtensionHierarchy((ImportAwareNonterminal)this.getAdditionalRootElements().get(i), processedN);
            this.getAdditionalRootElements().set(i, this.convertToSerializableNonterminals((ImportAwareNonterminal)this.getAdditionalRootElements().get(i), serializedNonterminals));
        }
        this.logger.debug("Schema import took {}ms", (Object)sw.getElapsedTime());
    }

    private Nonterminal convertToSerializableNonterminals(ImportAwareNonterminal n, Map<String, NonterminalImpl> serializedNonterminals) {
        if (n == null) {
            return null;
        }
        if (serializedNonterminals.containsKey(n.getId())) {
            return (Nonterminal)serializedNonterminals.get(n.getId());
        }
        NonterminalImpl nResult = new NonterminalImpl(n.getEntityId(), n.getId(), n.getName());
        serializedNonterminals.put(nResult.getId(), nResult);
        if (n.getChildNonterminals() != null) {
            nResult.setChildNonterminals(new ArrayList());
            for (Nonterminal nChild : n.getChildNonterminals()) {
                nResult.getChildNonterminals().add(this.convertToSerializableNonterminals((ImportAwareNonterminal)nChild, serializedNonterminals));
            }
        }
        return nResult;
    }

    private void resolveExtensionHierarchy(ImportAwareNonterminal n, List<ImportAwareNonterminal> processedN) {
        if (processedN.contains(n)) {
            return;
        }
        processedN.add(n);
        if (n.getChildNonterminals() != null) {
            ArrayList<ImportAwareNonterminal> extensionChildren = new ArrayList<ImportAwareNonterminal>();
            ArrayList<ImportAwareNonterminal> abstractChildren = new ArrayList<ImportAwareNonterminal>();
            for (int i = 0; i < n.getChildNonterminals().size(); ++i) {
                ImportAwareNonterminal childN = (ImportAwareNonterminal)n.getChildNonterminals().get(i);
                if (childN.isAbstract()) {
                    childN.setParentCount(childN.getParentCount() - 1);
                    abstractChildren.add(childN);
                }
                this.resolveExtensionHierarchy(childN, processedN);
                if (!this.extensionIdNonterminalMap.containsKey(childN.getTerminalQN())) continue;
                for (ImportAwareNonterminal extN : (List)this.extensionIdNonterminalMap.get(childN.getTerminalQN())) {
                    if (n.getChildNonterminals().contains(extN) || extensionChildren.contains(extN)) continue;
                    extensionChildren.add(extN);
                }
            }
            for (ImportAwareNonterminal extChild : extensionChildren) {
                extChild.setParentCount(extChild.getParentCount() + 1);
                n.getChildNonterminals().add(extChild);
            }
            n.getChildNonterminals().removeAll(abstractChildren);
        }
    }

    private void combineExtensionNonterminals() {
        for (Collection extensibleNonterminals : this.extensionIdNonterminalMap.values()) {
            for (String terminalQN : this.extensionIdNonterminalMap.keySet()) {
                for (ImportAwareNonterminal extN : extensibleNonterminals) {
                    if (!extN.getTerminalQN().equals(terminalQN)) continue;
                    for (ImportAwareNonterminal furtherExtN : (List)this.extensionIdNonterminalMap.get(terminalQN)) {
                        if (extN.getExtensions() == null) {
                            extN.setExtensions(new ArrayList());
                        }
                        extN.getExtensions().add(furtherExtN);
                    }
                }
            }
        }
    }

    private boolean getChildrenContainTerminalId(Identifiable parent, String terminalId, List<Nonterminal> checkedReuseN) {
        Nonterminal parentN;
        if (this.xmlNature.getTerminalId(parent.getId()).equals(terminalId)) {
            return true;
        }
        if (Nonterminal.class.isAssignableFrom(parent.getClass()) && (parentN = (Nonterminal)parent).getChildNonterminals() != null && !parentN.getChildNonterminals().isEmpty()) {
            for (Nonterminal child : parentN.getChildNonterminals()) {
                if (checkedReuseN.contains(child)) continue;
                checkedReuseN.add(child);
                if (!this.getChildrenContainTerminalId((Identifiable)child, terminalId, checkedReuseN)) continue;
                return true;
            }
        }
        return false;
    }

    protected Nonterminal getRoot(String rootElementNs, String rootElementName) throws MetamodelConsistencyException {
        XSNamedMap elements = this.model.getComponents((short)2);
        for (int j = 0; j < elements.getLength(); ++j) {
            boolean nsMatch;
            XSElementDecl elem = (XSElementDecl)elements.item(j);
            boolean bl = nsMatch = elem.getNamespace() == null && rootElementNs == null || elem.getNamespace() != null && rootElementNs != null && elem.getNamespace().equals(rootElementNs);
            if (!nsMatch || !elem.getName().equals(rootElementName)) continue;
            return this.processElement(null, elem, new ArrayList());
        }
        this.logger.warn("Unknown element declaration [{}]{}", (Object)rootElementNs, (Object)rootElementName);
        return null;
    }

    protected ImportAwareNonterminal processElement(ImportAwareNonterminal parentNonterminal, XSElementDecl element, List<String> processedTerminalQNs) throws MetamodelConsistencyException {
        String terminalQN = this.createTerminalQN(element.getNamespace(), element.getName(), false);
        if (this.terminalIdNonterminalMap.containsKey(terminalQN)) {
            this.logger.debug("Reusing existing nonterminal for qn: " + terminalQN);
            ImportAwareNonterminal n = (ImportAwareNonterminal)this.terminalIdNonterminalMap.get(terminalQN);
            this.addChildNonterminal(parentNonterminal, n);
            return n;
        }
        ImportAwareNonterminal n = this.createNonterminal(element.getNamespace(), element.getName(), false, element.getAbstract());
        XSElementDeclaration substDec = element.getSubstitutionGroupAffiliation();
        if (substDec != null) {
            String extTerminalQN = this.createTerminalQN(substDec.getNamespace(), substDec.getName(), false);
            ArrayList<ImportAwareNonterminal> extensionNonterminals = (ArrayList<ImportAwareNonterminal>)this.extensionIdNonterminalMap.get(extTerminalQN);
            if (extensionNonterminals == null) {
                extensionNonterminals = new ArrayList<ImportAwareNonterminal>();
            }
            extensionNonterminals.add(n);
            this.extensionIdNonterminalMap.put(extTerminalQN, extensionNonterminals);
        }
        if (processedTerminalQNs.contains(terminalQN)) {
            this.logger.warn("Recursion detected [{}]...element processing is cut", (Object)terminalQN);
            return n;
        }
        processedTerminalQNs.add(terminalQN);
        XSTypeDefinition typeDef = element.getTypeDefinition();
        if (typeDef.getTypeCategory() == 15) {
            this.processComplexElement(n, element, (XSComplexTypeDefinition)typeDef, new ArrayList<String>(processedTerminalQNs));
        }
        this.addChildNonterminal(parentNonterminal, n);
        return n;
    }

    protected void processComplexElement(ImportAwareNonterminal nonterminal, XSElementDecl element, XSComplexTypeDefinition typeDef, List<String> processedTerminalQNs) throws MetamodelConsistencyException {
        XSObjectList attrList = typeDef.getAttributeUses();
        for (int i = 0; i < attrList.getLength(); ++i) {
            XSAttributeDeclaration attrDecl = ((XSAttributeUse)attrList.item(i)).getAttrDeclaration();
            ImportAwareNonterminal attr = attrDecl.getNamespace() != null ? this.createNonterminal(attrDecl.getNamespace(), attrDecl.getName(), true, false) : this.createNonterminal(typeDef.getNamespace(), attrDecl.getName(), true, false);
            this.addChildNonterminal(nonterminal, attr);
        }
        if (typeDef.getContentType() == 2 || typeDef.getContentType() == 3) {
            this.processContentModel(nonterminal, typeDef.getParticle(), processedTerminalQNs);
        }
    }

    protected void processContentModel(ImportAwareNonterminal parentNonterminal, XSParticle particle, List<String> processedTerminalQNs) throws MetamodelConsistencyException {
        XSTerm contentModel = particle.getTerm();
        if (contentModel.getType() == 2) {
            this.processElement(parentNonterminal, (XSElementDecl)contentModel, new ArrayList<String>(processedTerminalQNs));
        } else if (contentModel.getType() == 7) {
            XSModelGroup modelGroup = (XSModelGroup)contentModel;
            XSObjectList groupElements = modelGroup.getParticles();
            for (int i = 0; i < groupElements.getLength(); ++i) {
                this.processContentModel(parentNonterminal, (XSParticle)groupElements.item(i), new ArrayList<String>(processedTerminalQNs));
            }
        }
    }

    protected void addChildNonterminal(ImportAwareNonterminal parent, ImportAwareNonterminal child) {
        if (parent != null) {
            if (parent.getChildNonterminals() == null) {
                parent.setChildNonterminals(new ArrayList());
            }
            child.setParentCount(child.getParentCount() + 1);
            parent.getChildNonterminals().add(child);
        }
    }

    protected ImportAwareNonterminal createNonterminal(String terminalNamespace, String terminalName, boolean isAttribute, boolean isAbstract) throws MetamodelConsistencyException {
        String terminalQN = this.createTerminalQN(terminalNamespace, terminalName, isAttribute);
        String terminalId = null;
        if (this.existingTerminalQNs.containsKey(terminalQN)) {
            terminalId = ((XmlTerminal)this.existingTerminalQNs.get(terminalQN)).getId();
        } else {
            XmlTerminal t = new XmlTerminal();
            t.setNamespace(terminalNamespace);
            t.setId(new ObjectId().toString());
            t.setName(terminalName);
            t.setAttribute(isAttribute);
            terminalId = t.getId();
            this.existingTerminalQNs.put(terminalQN, t);
        }
        ImportAwareNonterminal n = new ImportAwareNonterminal();
        n.setId(new ObjectId().toString());
        n.setName(this.createNonterminalName(terminalName));
        n.setAbstract(isAbstract);
        n.setTerminalQN(this.createTerminalQN(terminalNamespace, terminalName, isAttribute));
        this.xmlNature.mapNonterminal(n.getId(), terminalId);
        n.setEntityId(this.getDatamodel().getId());
        this.terminalIdNonterminalMap.put(terminalQN, n);
        return n;
    }

    protected String createTerminalQN(String terminalNamespace, String terminalName, boolean isAttribute) {
        return String.format("{%s}:%s%s", terminalNamespace, isAttribute ? "#" : "", terminalName);
    }
}

