/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer.datamodel.json;

import de.unibamberg.minf.dme.importer.datamodel.json.BaseJsonDatamodelImporter;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.datamodel.DatamodelImpl;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.ReferenceHelper;
import de.unibamberg.minf.dme.model.serialization.DatamodelReferenceContainer;
import de.unibamberg.minf.dme.service.interfaces.ReferenceService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class JsonDatamodelReferenceImporter
extends BaseJsonDatamodelImporter {
    @Autowired
    private ReferenceService referenceService;

    public String getImporterSubtype() {
        return "Datamodel v1.1";
    }

    public boolean getIsSupported() {
        if (super.getIsSupported()) {
            try {
                this.objectMapper.readValue(new File(this.importFilePath), DatamodelReferenceContainer.class);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public List<? extends Identifiable> getPossibleRootElements() {
        try {
            ArrayList<Class<NonterminalImpl>> allowedRootTypes = new ArrayList<Class<NonterminalImpl>>();
            allowedRootTypes.add(NonterminalImpl.class);
            return this.getElementsByTypes(allowedRootTypes);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve possible root elements for schema", (Throwable)e);
            return new ArrayList(0);
        }
    }

    public List<? extends ModelElement> getElementsByTypes(List<Class<? extends ModelElement>> allowedSubtreeRoots) {
        try {
            DatamodelReferenceContainer s = (DatamodelReferenceContainer)this.objectMapper.readValue(new File(this.importFilePath), DatamodelReferenceContainer.class);
            ArrayList<ModelElement> result = new ArrayList<ModelElement>();
            if (s.getElements() != null) {
                for (ModelElement me : s.getElements().values()) {
                    if (!allowedSubtreeRoots.contains(me.getClass())) continue;
                    result.add(me);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to extract model elements from serialized datamodel", (Throwable)e);
            return new ArrayList(0);
        }
    }

    protected void importJson() throws IOException, MetamodelConsistencyException {
        DatamodelReferenceContainer s = (DatamodelReferenceContainer)this.objectMapper.readValue(new File(this.importFilePath), DatamodelReferenceContainer.class);
        DatamodelImpl m = s.getModel();
        m.setId(this.getDatamodel().getId());
        Reference importRoot = this.referenceService.findReferenceById((Reference)s.getRoot(), this.getRootElementName());
        ModelElement e = (ModelElement)ReferenceHelper.fillElement((Reference)importRoot, (Map)s.getElements());
        HashMap oldToNewIdMap = new HashMap();
        this.reworkElementHierarchy(m.getId(), e, oldToNewIdMap, new HashMap(), null);
        if (!this.isKeepImportedIds() && m.getNatures() != null) {
            for (DatamodelNature nature : m.getNatures()) {
                this.regenerateTerminalIds(nature, oldToNewIdMap);
            }
        }
        if (this.getRootElementType() == null || this.getRootElementType().isEmpty()) {
            this.setRootElementType(e.getClass().getName());
        }
        this.setRootElements(new ArrayList());
        this.getRootElements().add(e);
        this.setDatamodel((Datamodel)m);
    }
}

