/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer.datamodel.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.unibamberg.minf.dme.importer.datamodel.json.BaseJsonDatamodelImporter;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import de.unibamberg.minf.dme.model.serialization.DatamodelContainer;
import de.unibamberg.minf.dme.service.ElementServiceImpl;
import de.unibamberg.minf.dme.service.IdentifiableServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class JsonDatamodelImporter
extends BaseJsonDatamodelImporter {
    public String getImporterSubtype() {
        return "Datamodel v1.0";
    }

    public boolean getIsSupported() {
        if (super.getIsSupported()) {
            try {
                this.objectMapper.readValue(new File(this.importFilePath), DatamodelContainer.class);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public List<? extends ModelElement> getElementsByTypes(List<Class<? extends ModelElement>> allowedSubtreeRoots) {
        try {
            DatamodelContainer s = (DatamodelContainer)this.objectMapper.readValue(new File(this.importFilePath), DatamodelContainer.class);
            return IdentifiableServiceImpl.extractAllByTypes((ModelElement)s.getRoot(), allowedSubtreeRoots);
        }
        catch (Exception e) {
            this.logger.error("Attempting legacy schema deserialization", (Throwable)e);
            return null;
        }
    }

    public List<Element> getPossibleRootElements() {
        try {
            DatamodelContainer s = (DatamodelContainer)this.objectMapper.readValue(new File(this.importFilePath), DatamodelContainer.class);
            this.getRootElements().addAll(ElementServiceImpl.extractAllNonterminals((Element)((Nonterminal)s.getRoot())));
            ArrayList<Element> result = new ArrayList<Element>();
            for (ModelElement me : this.getRootElements()) {
                result.add((Element)me);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve possible root elements for schema", (Throwable)e);
            return null;
        }
    }

    protected void importJson() throws JsonParseException, JsonMappingException, IOException, MetamodelConsistencyException {
        DatamodelContainer s = (DatamodelContainer)this.objectMapper.readValue(new File(this.importFilePath), DatamodelContainer.class);
        s.getModel().setId(this.getDatamodel().getId());
        HashMap elementReferences = new HashMap();
        this.collectElementReferences((ModelElement)s.getRoot(), elementReferences);
        this.resolveReoccurringElements((ModelElement)s.getRoot(), elementReferences, new ArrayList());
        this.importModel((Datamodel)s.getModel(), s.getRoot(), s.getGrammars());
    }

    private void resolveReoccurringElements(ModelElement e, Map<String, ModelElement> elements, List<String> processedIds) {
        block13: {
            Function f;
            block15: {
                block14: {
                    int i;
                    block12: {
                        int i2;
                        if (!processedIds.contains(e.getId())) {
                            processedIds.add(e.getId());
                        }
                        if (!Nonterminal.class.isAssignableFrom(e.getClass())) break block12;
                        Nonterminal n = (Nonterminal)e;
                        if ((n.getChildNonterminals() == null || n.getChildNonterminals().isEmpty()) && (n.getGrammars() == null || n.getGrammars().isEmpty())) break block13;
                        elements.put(n.getId(), (ModelElement)n);
                        if (n.getChildNonterminals() != null && !n.getChildNonterminals().isEmpty()) {
                            for (i2 = 0; i2 < n.getChildNonterminals().size(); ++i2) {
                                n.getChildNonterminals().set(i2, (Nonterminal)elements.get(((Nonterminal)n.getChildNonterminals().get(i2)).getId()));
                                if (processedIds.contains(((Nonterminal)n.getChildNonterminals().get(i2)).getId())) continue;
                                this.resolveReoccurringElements((ModelElement)n.getChildNonterminals().get(i2), elements, processedIds);
                            }
                        }
                        if (n.getGrammars() != null && !n.getGrammars().isEmpty()) {
                            for (i2 = 0; i2 < n.getGrammars().size(); ++i2) {
                                n.getGrammars().set(i2, (Grammar)elements.get(((Grammar)n.getGrammars().get(i2)).getId()));
                                if (processedIds.contains(((Grammar)n.getGrammars().get(i2)).getId())) continue;
                                this.resolveReoccurringElements((ModelElement)n.getGrammars().get(i2), elements, processedIds);
                            }
                        }
                        break block13;
                    }
                    if (!Label.class.isAssignableFrom(e.getClass())) break block14;
                    Label l = (Label)e;
                    if ((l.getSubLabels() == null || l.getSubLabels().isEmpty()) && (l.getGrammars() == null || l.getGrammars().isEmpty())) break block13;
                    elements.put(l.getId(), (ModelElement)l);
                    if (l.getSubLabels() != null && !l.getSubLabels().isEmpty()) {
                        for (i = 0; i < l.getSubLabels().size(); ++i) {
                            l.getSubLabels().set(i, (Label)elements.get(((Label)l.getSubLabels().get(i)).getId()));
                            if (processedIds.contains(((Label)l.getSubLabels().get(i)).getId())) continue;
                            this.resolveReoccurringElements((ModelElement)l.getSubLabels().get(i), elements, processedIds);
                        }
                    }
                    if (l.getGrammars() != null && !l.getGrammars().isEmpty()) {
                        for (i = 0; i < l.getGrammars().size(); ++i) {
                            l.getGrammars().set(i, (Grammar)elements.get(((Grammar)l.getGrammars().get(i)).getId()));
                            if (processedIds.contains(((Grammar)l.getGrammars().get(i)).getId())) continue;
                            this.resolveReoccurringElements((ModelElement)l.getGrammars().get(i), elements, processedIds);
                        }
                    }
                    break block13;
                }
                if (!Grammar.class.isAssignableFrom(e.getClass())) break block15;
                Grammar g = (Grammar)e;
                if (g.getFunctions() == null || g.getFunctions().isEmpty()) break block13;
                elements.put(g.getId(), (ModelElement)g);
                for (int i = 0; i < g.getFunctions().size(); ++i) {
                    g.getFunctions().set(i, (Function)elements.get(((Function)g.getFunctions().get(i)).getId()));
                    if (processedIds.contains(((Function)g.getFunctions().get(i)).getId())) continue;
                    this.resolveReoccurringElements((ModelElement)g.getFunctions().get(i), elements, processedIds);
                }
                break block13;
            }
            if (Function.class.isAssignableFrom(e.getClass()) && (f = (Function)e).getOutputElements() != null && !f.getOutputElements().isEmpty()) {
                elements.put(f.getId(), (ModelElement)f);
                for (int i = 0; i < f.getOutputElements().size(); ++i) {
                    f.getOutputElements().set(i, (Label)elements.get(((Element)f.getOutputElements().get(i)).getId()));
                    if (processedIds.contains(((Element)f.getOutputElements().get(i)).getId())) continue;
                    this.resolveReoccurringElements((ModelElement)f.getOutputElements().get(i), elements, processedIds);
                }
            }
        }
    }

    private void collectElementReferences(ModelElement e, Map<String, ModelElement> elements) {
        Function f;
        if (!elements.containsKey(e.getId())) {
            elements.put(e.getId(), e);
        }
        if (Nonterminal.class.isAssignableFrom(e.getClass())) {
            Nonterminal n = (Nonterminal)e;
            if (n.getChildNonterminals() != null && !n.getChildNonterminals().isEmpty() || n.getGrammars() != null && !n.getGrammars().isEmpty()) {
                elements.put(n.getId(), (ModelElement)n);
                if (n.getChildNonterminals() != null && !n.getChildNonterminals().isEmpty()) {
                    for (Nonterminal nChild : n.getChildNonterminals()) {
                        this.collectElementReferences((ModelElement)nChild, elements);
                    }
                }
                if (n.getGrammars() != null && !n.getGrammars().isEmpty()) {
                    for (Grammar gChild : n.getGrammars()) {
                        this.collectElementReferences((ModelElement)gChild, elements);
                    }
                }
                elements.put(n.getId(), (ModelElement)n);
            }
        } else if (Label.class.isAssignableFrom(e.getClass())) {
            Label l = (Label)e;
            if (l.getSubLabels() != null && !l.getSubLabels().isEmpty() || l.getGrammars() != null && !l.getGrammars().isEmpty()) {
                elements.put(l.getId(), (ModelElement)l);
                if (l.getSubLabels() != null && !l.getSubLabels().isEmpty()) {
                    for (Label lChild : l.getSubLabels()) {
                        this.collectElementReferences((ModelElement)lChild, elements);
                    }
                }
                if (l.getGrammars() != null && !l.getGrammars().isEmpty()) {
                    for (Grammar gChild : l.getGrammars()) {
                        this.collectElementReferences((ModelElement)gChild, elements);
                    }
                }
                elements.put(l.getId(), (ModelElement)l);
            }
        } else if (Grammar.class.isAssignableFrom(e.getClass())) {
            Grammar g = (Grammar)e;
            if (g.getFunctions() != null && !g.getFunctions().isEmpty()) {
                elements.put(g.getId(), (ModelElement)g);
                for (Function fChild : g.getFunctions()) {
                    this.collectElementReferences((ModelElement)fChild, elements);
                }
                elements.put(g.getId(), (ModelElement)g);
            }
        } else if (Function.class.isAssignableFrom(e.getClass()) && (f = (Function)e).getOutputElements() != null && !f.getOutputElements().isEmpty()) {
            elements.put(f.getId(), (ModelElement)f);
            for (Element lChild : f.getOutputElements()) {
                this.collectElementReferences((ModelElement)lChild, elements);
            }
            elements.put(f.getId(), (ModelElement)f);
        }
    }
}

