/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.exception.MappingImportException;
import de.unibamberg.minf.dme.importer.BaseImportWorker;
import de.unibamberg.minf.dme.importer.Importer;
import de.unibamberg.minf.dme.importer.mapping.MappingImportListener;
import de.unibamberg.minf.dme.importer.mapping.MappingImporter;
import de.unibamberg.minf.dme.model.LogEntry;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.mapping.base.MappedConcept;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.model.mapping.base.RelatedConcept;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.MappingService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MappingImportWorker
extends BaseImportWorker<MappingImporter>
implements MappingImportListener {
    @Autowired
    private MappingService mappingService;
    @Autowired
    private RelatedConceptService relatedConceptService;
    @Autowired
    private ElementService elementService;
    @Autowired
    private GrammarService grammarService;
    @Autowired
    private FunctionService functionService;

    protected Class<MappingImporter> getBaseImporterType() {
        return MappingImporter.class;
    }

    public List<LogEntry> importMapping(String filePath, String entityId, boolean keepImportedIds, AuthPojo auth) throws MappingImportException {
        ArrayList<LogEntry> importLog = new ArrayList<LogEntry>();
        if (entityId == null || entityId.trim().isEmpty()) {
            this.logMessage(LogEntry.LogType.ERROR, importLog, BaseImportWorker.GenericImporterMessages.NoEntityId.getMessageCode(), null);
            return importLog;
        }
        if (this.processingEntityIds.contains(entityId)) {
            this.logMessage(LogEntry.LogType.WARNING, importLog, BaseImportWorker.GenericImporterMessages.EntityIdAlreadyInProcess.getMessageCode(), null);
            return importLog;
        }
        if (filePath == null || !new File(filePath).exists()) {
            this.logMessage(LogEntry.LogType.ERROR, importLog, BaseImportWorker.GenericImporterMessages.FileNotFoundOrNotAccessible.getMessageCode(), new Object[]{filePath});
            return importLog;
        }
        RightsContainer rcM = this.mappingService.findByIdAndAuth(entityId, auth);
        if (rcM == null) {
            this.logMessage(LogEntry.LogType.ERROR, importLog, BaseImportWorker.GenericImporterMessages.EntityIdNotAuthorized.getMessageCode(), null);
            return importLog;
        }
        MappingImporter importer = (MappingImporter)this.getSupportingImporter(filePath);
        if (importer == null) {
            this.logMessage(LogEntry.LogType.ERROR, importLog, BaseImportWorker.GenericImporterMessages.NoSupportingImporter.getMessageCode(), null);
            return importLog;
        }
        importer.setAuth(auth);
        importer.setImportFilePath(filePath);
        importer.setImportListener((MappingImportListener)this);
        importer.setKeepImportedIds(keepImportedIds);
        importer.setMapping((Mapping)rcM.getElement());
        this.logMessage(LogEntry.LogType.INFO, importLog, BaseImportWorker.GenericImporterMessages.ImportStarted.getMessageCode(), null);
        this.execute(entityId, (Importer)importer);
        return importLog;
    }

    public void registerImportFailed(Mapping mapping) {
        this.logger.error(BaseImportWorker.GenericImporterMessages.ImportFailed.getMessageCode());
        this.processingEntityIds.remove(mapping.getId());
    }

    public void registerImportFinished(Mapping mapping, List<RelatedConcept> importedConcepts, Map<String, String> importedFunctions, Map<String, Grammar> importedGrammars, AuthPojo auth) {
        this.logger.info(BaseImportWorker.GenericImporterMessages.ImportFinished.getMessageCode());
        for (RelatedConcept relatedConcept : importedConcepts) {
            if (relatedConcept.getId() == null) {
                relatedConcept.setId(BaseDaoImpl.createNewObjectId());
            }
            for (String sourceId : relatedConcept.getElementGrammarIdsMap().keySet()) {
                Element eSource = this.elementService.findById(sourceId);
                GrammarImpl gSource = new GrammarImpl();
                gSource.setEntityId(mapping.getId());
                gSource.setId((String)relatedConcept.getElementGrammarIdsMap().get(sourceId));
                gSource.setName(eSource.getName());
                if (gSource.getId() != null && importedGrammars.containsKey(gSource.getId()) && importedGrammars.get(gSource.getId()) != null) {
                    gSource.setGrammarContainer(importedGrammars.get(gSource.getId()).getGrammarContainer());
                    gSource.setBaseMethod(gSource.getBaseMethod());
                } else {
                    gSource.setPassthrough(true);
                }
                this.grammarService.saveGrammar(gSource, auth);
                relatedConcept.getElementGrammarIdsMap().put(sourceId, gSource.getId());
            }
            if (MappedConcept.class.isAssignableFrom(relatedConcept.getClass())) {
                MappedConcept mc = (MappedConcept)MappedConcept.class.cast(relatedConcept);
                FunctionImpl fConcept = new FunctionImpl();
                fConcept.setEntityId(mapping.getId());
                if (mc.getFunctionId() != null) {
                    fConcept.setId(mc.getFunctionId());
                    fConcept.setName("fMapping");
                    if (importedFunctions.containsKey(mc.getFunctionId()) && importedFunctions.get(mc.getFunctionId()) != null) {
                        fConcept.setFunction(importedFunctions.get(mc.getFunctionId()));
                    }
                }
                this.functionService.saveFunction(fConcept, auth);
                mc.setFunctionId(fConcept.getId());
            }
            this.relatedConceptService.saveRelatedConcept(relatedConcept, mapping.getId(), auth);
        }
        this.processingEntityIds.remove(mapping.getId());
    }
}

