/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.importer;

import de.unibamberg.minf.dme.importer.Importer;
import de.unibamberg.minf.dme.model.LogEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public abstract class BaseImportWorker<T extends Importer>
implements ApplicationContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private ApplicationContext appContext;
    protected List<String> processingEntityIds = new ArrayList();
    @Autowired
    private MessageSource messageSource;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    public boolean isBeingProcessed(String entityId) {
        return entityId != null && this.processingEntityIds.contains(entityId);
    }

    public T getSupportingImporter(String filePath) {
        Map importers = this.appContext.getBeansOfType(this.getBaseImporterType());
        for (Importer importer : importers.values()) {
            importer.setImportFilePath(filePath);
            if (!importer.getIsSupported()) continue;
            return (T)importer;
        }
        return null;
    }

    protected void execute(String entityId, Importer importer) {
        if (!this.processingEntityIds.contains(entityId)) {
            this.processingEntityIds.add(entityId);
            this.executor.execute((Runnable)importer);
        }
    }

    protected void logMessage(LogEntry.LogType type, List<LogEntry> log, String messageCode, Object[] args) {
        this.logger.debug("{}: {}", (Object)type.toString(), (Object)this.messageSource.getMessage(messageCode, args, Locale.getDefault()));
        log.add(LogEntry.createEntry((LogEntry.LogType)type, (String)messageCode, (Object[])args));
    }

    protected abstract Class<T> getBaseImporterType();
}

