/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.exporter;

import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.datamodel.DatamodelImpl;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.serialization.DatamodelReferenceContainer;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.ReferenceService;
import de.unibamberg.minf.dme.service.interfaces.SchemaService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatamodelExporter {
    @Autowired
    private SchemaService datamodelService;
    @Autowired
    private ReferenceService referenceService;
    @Autowired
    private ElementService elementService;
    @Autowired
    protected GrammarService grammarService;
    @Autowired
    private FunctionService functionService;

    public List<DatamodelReferenceContainer> exportDatamodels(AuthPojo auth) throws InstantiationException, IllegalAccessException {
        return this.exportDatamodels(auth, false);
    }

    public List<DatamodelReferenceContainer> exportDatamodels(AuthPojo auth, boolean includeDrafts) throws InstantiationException, IllegalAccessException {
        List models = this.datamodelService.findAllByAuth(auth);
        if (models == null || models.isEmpty()) {
            return null;
        }
        ArrayList<DatamodelReferenceContainer> result = new ArrayList<DatamodelReferenceContainer>();
        for (RightsContainer m : models) {
            DatamodelImpl exportModel = new DatamodelImpl();
            exportModel.setId(((Datamodel)m.getElement()).getId());
            exportModel.setName(((Datamodel)m.getElement()).getName());
            ChangeSet ch = this.datamodelService.getLatestChangeSetForEntity(((Datamodel)m.getElement()).getId());
            if (ch != null) {
                exportModel.setVersionId(ch.getId());
            }
            if (((Datamodel)m.getElement()).getNatures() != null) {
                exportModel.setNatures(new ArrayList());
                for (DatamodelNature n : ((Datamodel)m.getElement()).getNatures()) {
                    exportModel.getNatures().add((DatamodelNature)n.getClass().newInstance());
                }
            }
            result.add(new DatamodelReferenceContainer(exportModel));
        }
        return result;
    }

    public DatamodelReferenceContainer exportDatamodelSubtree(String entityId, String exportElementId, AuthPojo auth) {
        Element expE;
        RightsContainer s = this.datamodelService.findByIdAndAuth(entityId, auth);
        if (s == null || s.getElement() == null) {
            return null;
        }
        DatamodelReferenceContainer sp = new DatamodelReferenceContainer();
        ChangeSet ch = this.datamodelService.getLatestChangeSetForEntity(s.getId());
        if (ch != null) {
            ((Datamodel)s.getElement()).setVersionId(ch.getId());
        }
        s.flush();
        Identifiable rootE = this.elementService.getElementSubtree(entityId, exportElementId);
        if (Element.class.isAssignableFrom(rootE.getClass())) {
            expE = (Element)rootE;
        } else {
            GrammarImpl expG;
            expE = new NonterminalImpl(s.getId(), "EXPORT_CONTAINER");
            expE.setGrammars(new ArrayList());
            if (GrammarImpl.class.isAssignableFrom(rootE.getClass())) {
                expG = (GrammarImpl)rootE;
            } else {
                expG = new GrammarImpl(entityId, "EXPORT_CONTAINER");
                expG.setFunctions(new ArrayList());
                if (!FunctionImpl.class.isAssignableFrom(rootE.getClass())) {
                    return null;
                }
                FunctionImpl expF = (FunctionImpl)rootE;
                expG.getFunctions().add(expF);
            }
            expE.getGrammars().add(expG);
        }
        sp.setModel(this.datamodelService.cloneSchemaForSubtree((Datamodel)s.getElement(), expE));
        RootReference rootR = new RootReference(entityId);
        Reference parentReference = this.referenceService.findReferenceBySchemaAndChildId(entityId, exportElementId);
        for (String className : parentReference.getChildReferences().keySet()) {
            boolean found = false;
            for (Reference rChild : (List)parentReference.getChildReferences().get(className)) {
                if (!rChild.getReferenceId().equals(exportElementId)) continue;
                rootR.setChildReferences(new HashMap());
                ArrayList<Reference> childReferences = new ArrayList<Reference>();
                childReferences.add(rChild);
                rootR.getChildReferences().put(className, childReferences);
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        sp.setRoot(rootR);
        HashMap elements = new HashMap();
        this.flattenElements(elements, (ModelElement)expE);
        sp.setElements(elements);
        return sp;
    }

    private void flattenElements(Map<String, ModelElement> flattenedMap, ModelElement e) {
        flattenedMap.put(e.getId(), e);
        if (Nonterminal.class.isAssignableFrom(e.getClass())) {
            this.flattenElements(flattenedMap, ((Nonterminal)e).getChildNonterminals());
            this.flattenElements(flattenedMap, ((Nonterminal)e).getGrammars());
        } else if (Label.class.isAssignableFrom(e.getClass())) {
            this.flattenElements(flattenedMap, ((Label)e).getSubLabels());
            this.flattenElements(flattenedMap, ((Label)e).getGrammars());
        } else if (Grammar.class.isAssignableFrom(e.getClass())) {
            this.flattenElements(flattenedMap, ((Grammar)e).getFunctions());
        } else if (Function.class.isAssignableFrom(e.getClass())) {
            this.flattenElements(flattenedMap, ((Function)e).getOutputElements());
        }
    }

    private void flattenElements(Map<String, ModelElement> flattenedMap, List<? extends ModelElement> elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        for (ModelElement modelElement : elements) {
            this.flattenElements(flattenedMap, modelElement);
        }
    }

    public DatamodelReferenceContainer exportDatamodel(String entityId, AuthPojo auth) {
        RightsContainer s = this.datamodelService.findByIdAndAuth(entityId, auth);
        if (s == null || s.getElement() == null) {
            return null;
        }
        DatamodelReferenceContainer sp = new DatamodelReferenceContainer();
        sp.setModel((DatamodelImpl)s.getElement());
        ChangeSet ch = this.datamodelService.getLatestChangeSetForEntity(s.getId());
        if (ch != null) {
            ((Datamodel)s.getElement()).setVersionId(ch.getId());
        }
        s.flush();
        sp.setRoot(this.referenceService.findReferenceBySchemaId(entityId));
        sp.setElements(new HashMap());
        for (Element e : this.elementService.findBySchemaId(entityId)) {
            e.flush();
            sp.getElements().put(e.getId(), e);
        }
        for (Grammar g : this.grammarService.findByEntityId(entityId, true)) {
            g.flush();
            sp.getElements().put(g.getId(), g);
        }
        for (Function f : this.functionService.findByEntityId(entityId)) {
            f.flush();
            sp.getElements().put(f.getId(), f);
        }
        return sp;
    }
}

