/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao.base;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.base.TrackedEntityDao;
import de.unibamberg.minf.dme.dao.interfaces.ChangeSetDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.ModelElement;
import de.unibamberg.minf.dme.model.tracking.Change;
import de.unibamberg.minf.dme.model.tracking.ChangeImpl;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.model.tracking.ChangeType;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class TrackedEntityDaoImpl<T extends TrackedEntity>
extends BaseDaoImpl<T>
implements TrackedEntityDao<T> {
    @Autowired
    protected ChangeSetDao changeSetDao;

    protected TrackedEntityDaoImpl(Class<T> clazz) {
        super(clazz);
    }

    protected TrackedEntityDaoImpl(Class<T> clazz, String collectionName) {
        super(clazz, collectionName);
    }

    public void saveNew(List<T> saveElements, String userId, String sessionId) {
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        for (TrackedEntity e : saveElements) {
            ArrayList<ChangeImpl> changes = e.flush();
            if (changes != null) continue;
            changes = new ArrayList<ChangeImpl>();
            changes.add(new ChangeImpl(ChangeType.NEW_OBJECT, this.getCollectionName(), null, (Object)e.getId(), DateTime.now()));
            if (changes.isEmpty()) continue;
            ChangeSet c = new ChangeSet();
            c.setUserId(userId);
            c.setSessionId(sessionId);
            String entityId = null;
            if (ModelElement.class.isAssignableFrom(e.getClass())) {
                entityId = ((ModelElement)e).getEntityId();
            }
            c.setEntityId(entityId);
            c.setElementId(e.getId());
            c.setChanges(changes);
            changeSets.add(c);
        }
        this.mongoTemplate.insert(saveElements, this.getCollectionName());
        this.mongoTemplate.insert(changeSets, this.changeSetDao.getCollectionName());
    }

    public List<T> find(Query q) {
        List result = this.mongoTemplate.find(q, this.clazz, this.getCollectionName());
        for (TrackedEntity e : result) {
            e.flush();
        }
        return result;
    }

    public List<T> findAll() {
        List result = this.mongoTemplate.findAll(this.clazz, this.getCollectionName());
        for (TrackedEntity e : result) {
            e.flush();
        }
        return result;
    }

    public List<T> findAll(Sort sort) {
        Query query = new Query();
        query.with(sort);
        List result = this.mongoTemplate.find(query, this.clazz, this.getCollectionName());
        for (TrackedEntity e : result) {
            e.flush();
        }
        return result;
    }

    public T findOne(Query q, Sort sort) {
        q.with(sort);
        TrackedEntity result = (TrackedEntity)this.mongoTemplate.findOne(q, this.clazz, this.getCollectionName());
        if (result != null) {
            result.flush();
        }
        return (T)result;
    }

    public T findById(String id) {
        TrackedEntity result = (TrackedEntity)this.mongoTemplate.findById((Object)id, this.clazz, this.getCollectionName());
        if (result != null) {
            result.flush();
        }
        return (T)result;
    }

    public T findOne(Query q) {
        TrackedEntity result = (TrackedEntity)this.mongoTemplate.findOne(q, this.clazz, this.getCollectionName());
        if (result != null) {
            result.flush();
        }
        return (T)result;
    }

    public long delete(Collection<String> id, String userId, String sessionId) {
        return this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(id)), this.getCollectionName()).getDeletedCount();
    }

    public void delete(T element, String userId, String sessionId) {
        if (element.getId() == null || element.getId().isEmpty() || !this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)element.getId())), this.getCollectionName())) {
            return;
        }
        element.addChange(ChangeType.DELETE_OBJECT, this.getCollectionName(), (Object)element.getId(), null);
        List changes = element.flush();
        String elementId = element.getId();
        String entityId = null;
        if (ModelElement.class.isAssignableFrom(element.getClass())) {
            entityId = ((ModelElement)element).getEntityId();
        }
        String parentEntityId = entityId;
        this.mongoTemplate.remove(element, this.getCollectionName());
        this.createAndSaveChangeSet(changes, elementId, parentEntityId, userId, sessionId);
    }

    public <S extends T> S save(S element, String userId, String sessionId) {
        boolean isNew = false;
        if (element.getId() != null && element.getId().isEmpty()) {
            element.setId(null);
            isNew = true;
        } else if (!this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)element.getId())), this.getCollectionName())) {
            isNew = true;
        }
        ArrayList<ChangeImpl> changes = element.flush();
        this.mongoTemplate.save(element, this.getCollectionName());
        if (isNew) {
            if (changes == null) {
                changes = new ArrayList<ChangeImpl>();
            }
            changes.add(new ChangeImpl(ChangeType.NEW_OBJECT, this.getCollectionName(), null, (Object)element.getId(), DateTime.now()));
        }
        String entityId = null;
        if (ModelElement.class.isAssignableFrom(element.getClass())) {
            entityId = ((ModelElement)element).getEntityId();
        }
        this.createAndSaveChangeSet(changes, element.getId(), entityId, userId, sessionId);
        return element;
    }

    protected void createAndSaveChangeSet(List<Change> changes, String elementId, String parentEntityId, String userId, String sessionId) {
        if (changes != null && !changes.isEmpty()) {
            ChangeSet c = new ChangeSet();
            c.setUserId(userId);
            c.setSessionId(sessionId);
            c.setEntityId(parentEntityId);
            c.setElementId(elementId);
            c.setChanges(changes);
            this.changeSetDao.save((Identifiable)c);
        }
    }
}

