/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao.base;

import de.unibamberg.minf.dme.dao.base.RightsAssignedObjectDao;
import de.unibamberg.minf.dme.dao.base.TrackedEntityDaoImpl;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class RightsAssignedObjectDaoImpl<T extends TrackedEntity>
extends TrackedEntityDaoImpl<RightsContainer<T>>
implements RightsAssignedObjectDao<T> {
    public RightsAssignedObjectDaoImpl(Class<RightsContainer<T>> clazz) {
        super(clazz);
    }

    public RightsAssignedObjectDaoImpl(Class<RightsContainer<T>> clazz, String collectionName) {
        super(clazz, collectionName);
    }

    public List<RightsContainer<T>> findAll() {
        Query q = new Query();
        q.fields().exclude("element.namespaces");
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"draft").is((Object)false));
        return this.find(q);
    }

    public List<T> findAllEnclosed() {
        List wrapped = this.findAll();
        ArrayList<TrackedEntity> result = new ArrayList<TrackedEntity>(wrapped.size());
        for (RightsContainer w : wrapped) {
            result.add(w.getElement());
        }
        return result;
    }

    public T findEnclosedById(String id) {
        RightsContainer e = (RightsContainer)this.findById(id);
        if (e != null) {
            return (T)e.getElement();
        }
        return null;
    }

    public List<RightsContainer<T>> findAllByUserId(String userId) {
        Query q = new Query();
        Criteria cNoDraft = Criteria.where((String)"draft").is((Object)false);
        if (userId == null) {
            q.addCriteria((CriteriaDefinition)cNoDraft);
        } else {
            Criteria cOwner = Criteria.where((String)"ownerId").is((Object)userId);
            Criteria sharedDraft = Criteria.where((String)"readIds").is((Object)userId);
            q.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{cOwner, cNoDraft, sharedDraft}));
        }
        return this.find(q);
    }

    public RightsContainer<T> findByIdAndUserId(String id, String userId) {
        return this.findByIdAndUserId(id, userId, false);
    }

    public RightsContainer<T> findByIdAndUserId(String id, String userId, boolean excludeContained) {
        Query q = new Query();
        if (excludeContained) {
            q.fields().exclude("element");
        }
        Criteria cId = Criteria.where((String)"_id").is((Object)id);
        Criteria cNoDraft = Criteria.where((String)"draft").is((Object)false);
        if (userId == null) {
            q.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{cId, cNoDraft}));
        } else {
            Criteria cOwner = Criteria.where((String)"ownerId").is((Object)userId);
            Criteria sharedDraft = Criteria.where((String)"readIds").is((Object)userId);
            q.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{cId, new Criteria().orOperator(new Criteria[]{cOwner, cNoDraft, sharedDraft})}));
        }
        return (RightsContainer)this.findOne(q);
    }

    public List<RightsContainer<T>> findByCriteriaAndUserId(Criteria c, String userId) {
        Query q = new Query();
        Criteria cNoDraft = Criteria.where((String)"draft").is((Object)false);
        if (userId == null) {
            q.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{c, cNoDraft}));
        } else {
            Criteria cOwner = Criteria.where((String)"ownerId").is((Object)userId);
            Criteria sharedDraft = Criteria.where((String)"readIds").is((Object)userId);
            q.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{c, new Criteria().orOperator(new Criteria[]{cOwner, cNoDraft, sharedDraft})}));
        }
        return this.find(q);
    }

    public void updateContained(T e, String userId, String sessionId) throws GenericScheregException {
        if (e.getId() == null) {
            throw new GenericScheregException("Contained update only allowed for existing element (no ID provided)");
        }
        RightsContainer saveE = (RightsContainer)this.findById(e.getId());
        if (saveE == null) {
            throw new GenericScheregException("Contained update only allowed for existing elements (unknown ID provided)");
        }
        saveE.setElement(e);
        this.save((TrackedEntity)saveE, userId, sessionId);
    }
}

