/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao.base;

import de.unibamberg.minf.dme.dao.base.BaseDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class BaseDaoImpl<T extends Identifiable>
implements BaseDao<T> {
    protected static final String ID_FIELD = "_id";
    public static final String ENTITY_ID_FIELD = "entityId";
    protected final String collectionName;
    protected final Class<T> clazz;
    @Autowired
    public MongoTemplate mongoTemplate;

    protected BaseDaoImpl(Class<T> clazz) {
        this.clazz = clazz;
        this.collectionName = clazz.getSimpleName().toLowerCase();
    }

    protected BaseDaoImpl(Class<T> clazz, String collectionName) {
        this.clazz = clazz;
        this.collectionName = collectionName;
    }

    public long count(Query q) {
        return this.mongoTemplate.count(q, this.clazz, this.collectionName);
    }

    public List<T> find(Query q) {
        return this.mongoTemplate.find(q, this.clazz, this.getCollectionName());
    }

    public List<T> findAll() {
        return this.mongoTemplate.findAll(this.clazz, this.collectionName);
    }

    public List<T> findByPropertyValue(String property, Object value) {
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)property).is(value));
        return this.mongoTemplate.find(q, this.clazz, this.collectionName);
    }

    public T findOne(Query q) {
        return (T)((Identifiable)this.mongoTemplate.findOne(q, this.clazz, this.collectionName));
    }

    public T findOne(Query q, Sort sort) {
        q.with(sort);
        return (T)((Identifiable)this.mongoTemplate.findOne(q, this.clazz, this.getCollectionName()));
    }

    public List<T> findByQuery(Query q) {
        return this.mongoTemplate.find(q, this.clazz, this.collectionName);
    }

    public T findById(String id) {
        return (T)((Identifiable)this.mongoTemplate.findById((Object)id, this.clazz, this.collectionName));
    }

    public T findByPropertyValueDistinct(String property, Object value) {
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)property).is(value));
        return (T)((Identifiable)this.mongoTemplate.findOne(q, this.clazz, this.collectionName));
    }

    public <S extends T> S save(S entity) {
        if (entity.getId() != null && entity.getId().isEmpty()) {
            entity.setId(null);
        }
        this.mongoTemplate.save(entity, this.collectionName);
        return entity;
    }

    public int delete(Iterable<? extends T> entities) {
        int count = 0;
        for (Identifiable e : entities) {
            count += this.mongoTemplate.remove((Object)e).wasAcknowledged() ? 1 : 0;
        }
        return count;
    }

    public int delete(List<String> ids) {
        return this.mongoTemplate.findAllAndRemove(new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).in(ids)), this.clazz, this.collectionName).size();
    }

    public void delete(T entity) {
        this.mongoTemplate.remove(entity, this.collectionName);
    }

    public void delete(String id) {
        this.mongoTemplate.findAllAndRemove(new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)id)), this.clazz, this.collectionName);
    }

    public long delete(Collection<String> ids) {
        return this.mongoTemplate.findAllAndRemove(new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).in(ids)), this.clazz, this.getCollectionName()).size();
    }

    public static boolean isNewId(String id) {
        return id == null || id.equals("") || id.equals("undefined");
    }

    public static boolean isValidObjectId(String id) {
        return id != null && ObjectId.isValid((String)id);
    }

    public static String createNewObjectId() {
        return new ObjectId().toString();
    }

    public List<T> combineQueryResults(Criteria[] criteria, int limit) {
        ArrayList<Identifiable> result = new ArrayList<Identifiable>();
        for (Criteria cr : criteria) {
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)cr);
            q.limit(result.size() + limit);
            ArrayList<Identifiable> innerResult = this.findByQuery(q);
            if (innerResult == null || innerResult.size() <= 0) continue;
            for (Identifiable t : innerResult) {
                boolean contains = false;
                for (Identifiable tX : result) {
                    if (!t.getId().equals(tX.getId())) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                result.add(t);
            }
            if (result.size() < limit) continue;
            innerResult = result;
            result = new ArrayList(limit);
            for (int i = 0; i < limit; ++i) {
                result.add((Identifiable)innerResult.get(i));
            }
            return result;
        }
        return result;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }
}

