/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao;

import de.unibamberg.minf.dme.dao.base.RightsAssignedObjectDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.SchemaDao;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlNamespace;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlTerminal;
import java.util.List;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class SchemaDaoImpl
extends RightsAssignedObjectDaoImpl<Datamodel>
implements SchemaDao {
    public SchemaDaoImpl() {
        super(new RightsContainer().getClass(), "schema");
    }

    public XmlNamespace findNamespaceByPrefix(String string) {
        Criteria findParentSchema = Criteria.where((String)"element.namespaces.prefix").is((Object)string);
        Criteria filterContainedNamespace = Criteria.where((String)"element.namespaces").elemMatch(Criteria.where((String)"prefix").is((Object)string));
        BasicQuery query = new BasicQuery(findParentSchema.getCriteriaObject(), filterContainedNamespace.getCriteriaObject());
        XmlDatamodelNature result = (XmlDatamodelNature)((RightsContainer)this.findOne((Query)query)).getElement();
        if (result.getNamespaces() != null && result.getNamespaces().size() > 0) {
            return (XmlNamespace)result.getNamespaces().get(0);
        }
        return null;
    }

    public <S extends RightsContainer<Datamodel>> S save(S element, String userId, String sessionId) {
        if (element.getElement() instanceof XmlDatamodelNature) {
            List changes;
            XmlDatamodelNature s = (XmlDatamodelNature)element.getElement();
            if (s.getTerminals() != null) {
                for (XmlTerminal xmlT : s.getTerminals()) {
                    changes = xmlT.flush();
                    if (changes == null) continue;
                    this.createAndSaveChangeSet(changes, xmlT.getId(), s.getId(), userId, sessionId);
                }
            }
            if (s.getNamespaces() != null) {
                for (XmlNamespace xmlNs : s.getNamespaces()) {
                    changes = xmlNs.flush();
                    if (changes == null) continue;
                    this.createAndSaveChangeSet(changes, xmlNs.getId(), s.getId(), userId, sessionId);
                }
            }
        }
        return (S)((RightsContainer)super.save(element, userId, sessionId));
    }
}

