/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao;

import de.unibamberg.minf.dme.dao.base.BaseDao;
import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.base.TrackedEntityDao;
import de.unibamberg.minf.dme.dao.interfaces.ReferenceDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.RootReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class ReferenceDaoImpl
extends BaseDaoImpl<RootReference>
implements ReferenceDao,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ReferenceDaoImpl.class);
    private ApplicationContext appContext;

    public ReferenceDaoImpl() {
        super(RootReference.class, Reference.class.getSimpleName().toLowerCase());
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    public Reference findParentByChildId(String rootId, String childId) {
        return this.findParentByChildId((Reference)this.findById(rootId), childId, null);
    }

    public Reference findParentByChildId(Reference reference, String childId) {
        return this.findParentByChildId(reference, childId, null);
    }

    public Reference findParentByChildId(String rootId, String childId, List<String> parentClassNames) {
        return this.findParentByChildId((Reference)this.findById(rootId), childId, parentClassNames);
    }

    public Reference findParentByChildId(Reference reference, String childId, List<String> parentClassNames) {
        if (reference.getChildReferences() != null) {
            for (String type : reference.getChildReferences().keySet()) {
                if (reference.getChildReferences().get(type) == null) continue;
                for (Reference r : (List)reference.getChildReferences().get(type)) {
                    if (r.getReferenceId().equals(childId)) {
                        return reference;
                    }
                    Reference subR = this.findParentByChildId(r, childId, parentClassNames);
                    if (subR == null) continue;
                    if (parentClassNames == null || parentClassNames.size() == 0) {
                        return subR;
                    }
                    if (subR.equals(r)) {
                        if (parentClassNames.contains(type)) {
                            return subR;
                        }
                        return reference;
                    }
                    return subR;
                }
            }
        }
        return null;
    }

    public void removeById(Reference parentReference, String matchId) {
        if (parentReference.getChildReferences() != null) {
            ArrayList<String> removeTypes = null;
            for (String type : parentReference.getChildReferences().keySet()) {
                if (parentReference.getChildReferences().get(type) == null) continue;
                List references = (List)parentReference.getChildReferences().get(type);
                ArrayList<Reference> removeReferences = null;
                for (Reference r : references) {
                    if (r.getReferenceId().equals(matchId)) {
                        if (removeReferences == null) {
                            removeReferences = new ArrayList<Reference>();
                        }
                        removeReferences.add(r);
                        continue;
                    }
                    this.removeById(r, matchId);
                }
                if (removeReferences == null) continue;
                if (references.size() == removeReferences.size()) {
                    if (removeTypes == null) {
                        removeTypes = new ArrayList<String>();
                    }
                    removeTypes.add(type);
                    continue;
                }
                ArrayList<Reference> newRefs = new ArrayList<Reference>(references.size() - removeReferences.size());
                boolean j = false;
                for (int i = 0; i < references.size(); ++i) {
                    if (removeReferences.contains(references.get(i))) continue;
                    newRefs.add((Reference)references.get(i));
                }
                parentReference.getChildReferences().put(type, newRefs);
            }
            if (removeTypes != null) {
                for (String removeType : removeTypes) {
                    parentReference.getChildReferences().remove(removeType);
                }
            }
        }
    }

    public Reference findById(Reference reference, String referenceId) {
        if (reference.getReferenceId().equals(referenceId)) {
            return reference;
        }
        Reference result = null;
        if (reference.getChildReferences() != null) {
            for (String type : reference.getChildReferences().keySet()) {
                if (reference.getChildReferences().get(type) == null) continue;
                for (Reference r : (List)reference.getChildReferences().get(type)) {
                    result = this.findById(r, referenceId);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    public void deleteAll(Map<String, Reference[]> idMap, String userId, String sessionId) throws IllegalArgumentException, ClassNotFoundException {
        if (idMap == null) {
            return;
        }
        for (String type : idMap.keySet()) {
            Reference[] deleteReferences = idMap.get(type);
            if (deleteReferences == null || deleteReferences.length <= 0) continue;
            Class<?> clazz = Class.forName(type);
            ArrayList<String> deleteIds = new ArrayList<String>(deleteReferences.length);
            for (int i = 0; i < deleteReferences.length; ++i) {
                Assert.isTrue((boolean)BaseDaoImpl.isValidObjectId((String)deleteReferences[i].getReferenceId()));
                deleteIds.add(deleteReferences[i].getReferenceId());
            }
            BaseDao matchingDao = this.getMatchingDao(clazz);
            Assert.notNull((Object)matchingDao);
            long result = 0L;
            result = matchingDao instanceof TrackedEntityDao ? ((TrackedEntityDao)matchingDao).delete(deleteIds, userId, sessionId) : (long)matchingDao.delete(deleteIds);
            log.info("Removed {} {} entities in consequence of a delete cascade", (Object)result, (Object)clazz.getSimpleName());
        }
    }

    public Identifiable findIdentifiableById(String id) {
        Map daos = this.appContext.getBeansOfType(BaseDao.class);
        Identifiable result = null;
        for (String key : daos.keySet()) {
            BaseDao dao = (BaseDao)daos.get(key);
            if (!(dao instanceof BaseDao) || (result = dao.findById(id)) == null) continue;
            return result;
        }
        return null;
    }

    private BaseDao getMatchingDao(Class<?> entityType) {
        Map daos = this.appContext.getBeansOfType(BaseDao.class);
        for (String key : daos.keySet()) {
            BaseDao dao = (BaseDao)daos.get(key);
            if (!dao.getClazz().isAssignableFrom(entityType)) continue;
            return dao;
        }
        return null;
    }

    public List<Reference> findParentsByChildId(String rootId, String childId) {
        return this.findParentsByChildId((Reference)this.findById(rootId), childId, null);
    }

    public List<Reference> findParentsByChildId(Reference reference, String childId, List<String> parentClassNames) {
        if (reference.getChildReferences() != null) {
            ArrayList<Reference> result = new ArrayList<Reference>();
            for (String type : reference.getChildReferences().keySet()) {
                if (reference.getChildReferences().get(type) == null) continue;
                for (Reference r : (List)reference.getChildReferences().get(type)) {
                    if (r.getReferenceId().equals(childId)) {
                        result.add(reference);
                        continue;
                    }
                    List subRs = this.findParentsByChildId(r, childId, parentClassNames);
                    if (subRs == null) continue;
                    for (Reference subR : subRs) {
                        if (parentClassNames == null || parentClassNames.size() == 0) {
                            result.add(subR);
                            continue;
                        }
                        if (subR.equals(r)) {
                            if (!parentClassNames.contains(type)) continue;
                            result.add(subR);
                            continue;
                        }
                        result.add(subR);
                    }
                }
            }
            return result;
        }
        return null;
    }
}

