/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.unibamberg.minf.dme.confg.MainConfig;
import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.PersistedSessionDao;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.SessionSampleFile;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.processing.model.SerializableResource;
import de.unibamberg.minf.processing.model.SerializableRootResource;
import de.unibamberg.minf.processing.model.base.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.FileUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class PersistedSessionDaoImpl
extends BaseDaoImpl<PersistedSession>
implements PersistedSessionDao {
    private static final Logger log = LoggerFactory.getLogger(PersistedSessionDaoImpl.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MainConfig mainConfig;
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^(?:(?:[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}_)|(?:([a-fA-F0-9]{24})))?(?:(.+)\\.(.+))|(.+)$");
    private static final String SAMPLE_OUTPUT = "output.json";
    private static final String SAMPLE_MAPPED = "mapped.json";
    private static final String SAMPLE_SELECTED_VALUE_MAP = "valueMap.json";
    private static final String SAMPLE_SELECTED_RESOURCE_MAP = "resourceMap.json";
    private static final String SAMPLE_SESSION_DATA = "sessionData.json";
    private static final TypeReference<HashMap<String, String>> mapRef = new /* Unavailable Anonymous Inner Class!! */;
    private static final TypeReference<ArrayList<SerializableRootResource>> resourceListRef = new /* Unavailable Anonymous Inner Class!! */;
    private static final TypeReference<ArrayList<SerializableResource>> resListRef = new /* Unavailable Anonymous Inner Class!! */;

    public PersistedSessionDaoImpl() {
        super(PersistedSession.class, "persistedSession");
    }

    public PersistedSession findById(String id) {
        return (PersistedSession)super.findById(id);
    }

    public PersistedSession findOne(Query q) {
        return (PersistedSession)super.findOne(q);
    }

    public PersistedSession findOne(Query q, Sort sort) {
        return (PersistedSession)super.findOne(q, sort);
    }

    public <S extends PersistedSession> S save(S entity) {
        if (entity.getId() == null) {
            entity.setId(new ObjectId().toString());
        }
        super.save(entity);
        return entity;
    }

    public void delete(String id) {
        this.deleteData(id);
        super.delete(id);
    }

    public void delete(PersistedSession entity) {
        if (entity.getId() != null) {
            this.deleteData(entity.getId());
        }
        super.delete((Identifiable)entity);
    }

    public int delete(Iterable<? extends PersistedSession> entities) {
        for (PersistedSession persistedSession : entities) {
            if (persistedSession.getId() == null) continue;
            this.deleteData(persistedSession.getId());
        }
        return super.delete(entities);
    }

    public long delete(Collection<String> ids) {
        for (String id : ids) {
            this.deleteData(id);
        }
        return super.delete(ids);
    }

    public ArrayList<SerializableRootResource> loadSampleOutput(String sessionId) {
        return (ArrayList)this.readDataFile(sessionId, SAMPLE_OUTPUT, resourceListRef);
    }

    public ArrayList<SerializableRootResource> loadSampleMapped(String sessionId) {
        return (ArrayList)this.readDataFile(sessionId, SAMPLE_MAPPED, resourceListRef);
    }

    public Map<String, String> loadSelectedValueMap(String sessionId) {
        return (Map)this.readDataFile(sessionId, SAMPLE_SELECTED_VALUE_MAP, mapRef);
    }

    public List<SerializableResource> loadSelectedResourceMap(String sessionId) {
        return (List)this.readDataFile(sessionId, SAMPLE_SELECTED_RESOURCE_MAP, resListRef);
    }

    public String loadSessionData(String sessionId) {
        return this.readDataFile(sessionId, SAMPLE_SESSION_DATA);
    }

    public void saveSampleOutput(String sessionId, List<Resource> sampleOutput) {
        this.saveDataFile(sessionId, sampleOutput, SAMPLE_OUTPUT);
    }

    public void saveSampleMapped(String sessionId, List<Resource> sampleMapped) {
        this.saveDataFile(sessionId, sampleMapped, SAMPLE_MAPPED);
    }

    public void saveSelectedValueMap(String sessionId, Map<String, String> selectedValueMap) {
        this.saveDataFile(sessionId, selectedValueMap, SAMPLE_SELECTED_VALUE_MAP);
    }

    public void saveSelectedResourceMap(String sessionId, List<Resource> selectedResourceMap) {
        this.saveDataFile(sessionId, selectedResourceMap, SAMPLE_SELECTED_RESOURCE_MAP);
    }

    public void saveSessionData(String sessionId, JsonNode json) {
        this.saveDataFile(sessionId, (Object)json, SAMPLE_SESSION_DATA, true);
    }

    public void removeSessionData(String sessionId) {
        this.removeDataFile(sessionId, SAMPLE_SESSION_DATA);
    }

    private File getSessionFile(String sessionId, String file) {
        StringBuilder sessionDataPathBuilder = new StringBuilder();
        sessionDataPathBuilder.append(this.mainConfig.getPaths().getSessionData()).append(File.separator).append(sessionId);
        if (file != null) {
            sessionDataPathBuilder.append(File.separator).append(file);
        }
        return new File(sessionDataPathBuilder.toString());
    }

    private void removeDataFile(String sessionId, String file) {
        File f = this.getSessionFile(sessionId, file);
        if (f.exists()) {
            FileUtils.deleteQuietly((File)f);
        }
    }

    private void saveDataFile(String sessionId, Object o, String file) {
        this.saveDataFile(sessionId, o, file, false);
    }

    private void saveDataFile(String sessionId, Object o, String file, boolean pretty) {
        File f = this.getSessionFile(sessionId, file);
        if (o == null) {
            if (f.exists()) {
                FileUtils.deleteQuietly((File)f);
            }
            return;
        }
        try {
            if (!Files.exists(f.getParentFile().toPath(), new LinkOption[0])) {
                Files.createDirectories(f.getParentFile().toPath(), new FileAttribute[0]);
            }
            String outJson = pretty ? this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(o) : this.objectMapper.writeValueAsString(o);
            FileUtils.writeStringToFile((File)f, (String)outJson, (Charset)StandardCharsets.UTF_8, (boolean)false);
        }
        catch (IOException e) {
            log.error(String.format("Failed to save data file [%s]", f.getAbsolutePath()), (Throwable)e);
        }
    }

    private <T> T readDataFile(String sessionId, String file, TypeReference<T> typeRef) {
        try {
            String inJson = this.readDataFile(sessionId, file);
            if (inJson != null) {
                return (T)this.objectMapper.readValue(inJson, typeRef);
            }
        }
        catch (Exception e) {
            log.error("Failed to parse JSON data", (Throwable)e);
        }
        return null;
    }

    private String readDataFile(String sessionId, String file) {
        File inFile = this.getSessionFile(sessionId, file);
        try {
            if (inFile.exists()) {
                return FileUtils.readFileToString((File)inFile, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            log.error(String.format("Failed to load data file [%s]", inFile.getAbsolutePath()), (Throwable)e);
        }
        return null;
    }

    public SessionSampleFile saveAsSessionInputFile(File file, SessionSampleFile.FileTypes type, String sessionId) {
        return this.innerSaveSessionInputFile(null, file, type, sessionId);
    }

    public SessionSampleFile saveAsSessionInputFile(String string, SessionSampleFile.FileTypes type, String sessionId) {
        return this.innerSaveSessionInputFile(string, null, type, sessionId);
    }

    public PersistedSession updateSessionFileType(String sessionId, SessionSampleFile.FileTypes fileType) {
        PersistedSession session = this.findById(sessionId);
        SessionSampleFile file = session.getSampleFile();
        if (file != null) {
            try {
                String newPath = file.getPath().substring(0, file.getPath().lastIndexOf(46)) + "." + fileType.toString().toLowerCase();
                File targetFile = new File(newPath);
                if (targetFile.exists()) {
                    FileUtils.forceDelete((File)targetFile);
                }
                FileUtils.moveFile((File)new File(file.getPath()), (File)targetFile);
                file.setType(fileType);
                file.setPath(newPath);
                this.save(session);
            }
            catch (Exception e) {
                log.error("Failed to update session file type", (Throwable)e);
            }
        }
        return session;
    }

    private SessionSampleFile innerSaveSessionInputFile(String input, File inputFile, SessionSampleFile.FileTypes type, String sessionId) {
        try {
            File targetFile;
            Assert.isTrue((boolean)(input != null ^ inputFile != null));
            Path sessionDirectoryPath = this.getSessionFile(sessionId, null).toPath();
            if (!Files.exists(sessionDirectoryPath, new LinkOption[0])) {
                FileUtils.forceMkdir((File)sessionDirectoryPath.toFile());
            }
            if (input != null) {
                targetFile = new File(sessionDirectoryPath + File.separator + "uploaded_sample." + type.toString().toLowerCase());
                FileUtils.writeStringToFile((File)targetFile, (String)input, (Charset)Charsets.UTF_8, (boolean)false);
            } else {
                Object fileName = inputFile.getName();
                Matcher filenameMatcher = FILENAME_PATTERN.matcher(inputFile.getName());
                if (filenameMatcher.matches()) {
                    if (filenameMatcher.group(2) != null) {
                        fileName = filenameMatcher.group(2) + "." + filenameMatcher.group(3);
                    } else if (filenameMatcher.group(4) != null) {
                        fileName = filenameMatcher.group(4);
                    }
                }
                targetFile = new File(sessionDirectoryPath + File.separator + (String)fileName);
                FileUtils.copyFile((File)inputFile, (File)targetFile);
            }
            SessionSampleFile result = new SessionSampleFile();
            result.setFileCount(1);
            result.setPath(targetFile.getAbsolutePath());
            result.setType(type);
            return result;
        }
        catch (Exception e) {
            log.error("Failed to save session input file", (Throwable)e);
            return null;
        }
    }

    private void deleteData(String sessionId) {
        try {
            Path sessionDirectoryPath = this.getSessionFile(sessionId, null).toPath();
            if (Files.exists(sessionDirectoryPath, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)sessionDirectoryPath.toFile());
            }
        }
        catch (Exception e) {
            log.error("Failed to delete session data", (Throwable)e);
        }
    }
}

