/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.dao;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.ChangeSetDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ChangeSetDaoImpl
extends BaseDaoImpl<ChangeSet>
implements ChangeSetDao {
    public ChangeSetDaoImpl() {
        super(ChangeSet.class, "changeSet");
    }

    public ChangeSet save(ChangeSet entity) {
        ChangeSet sessionChangeSet = this.findOneByIds(entity.getSessionId(), entity.getEntityId(), entity.getElementId());
        if (sessionChangeSet == null) {
            entity.setTimestamp(DateTime.now());
            return (ChangeSet)super.save((Identifiable)entity);
        }
        sessionChangeSet.getChanges().addAll(entity.getChanges());
        sessionChangeSet.setTimestamp(DateTime.now());
        return (ChangeSet)super.save((Identifiable)sessionChangeSet);
    }

    public ChangeSet findOneByIds(String sessionId, String entityId, String elementId) {
        return (ChangeSet)this.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId).and("entityId").is((Object)entityId).and("elementId").is((Object)elementId)));
    }

    public List<ChangeSet> findByEntityId(String entityId) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId));
        q.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timestamp"}));
        return this.find(q);
    }

    public List<ChangeSet> findByElementId(String elementId) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"elementId").is((Object)elementId));
        q.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timestamp"}));
        return this.find(q);
    }

    public List<ChangeSet> findByEntityIds(List<String> entityIds) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"entityId").in(entityIds));
        q.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timestamp"}));
        return this.find(q);
    }

    public List<ChangeSet> findByElementIds(List<String> elementIds) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"elementId").in(elementIds));
        q.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timestamp"}));
        return this.find(q);
    }

    public ChangeSet findLatestByEntityId(String entityId) {
        Query q = Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId));
        q.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timestamp"}));
        q.limit(1);
        return (ChangeSet)this.findOne(q);
    }
}

