/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.exceptions;

import eu.dariah.de.dariahsp.config.SecurityConfig;
import eu.dariah.de.dariahsp.error.RequiredAttributesException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class ErrorController
extends BasicErrorController {
    @Autowired
    private SecurityConfig securityConfig;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes, new ErrorProperties());
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        Map attr = this.getErrorAttributes(request, this.getErrorAttributeOptions(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        this.assembleMap(attr, status);
        Object ex = request.getAttribute("javax.servlet.error.exception");
        if (ex != null && RequiredAttributesException.class.isAssignableFrom(ex.getClass())) {
            StringBuilder errorStrBldr = new StringBuilder();
            errorStrBldr.append("Your IdP did not provide all required attributes. ");
            if (this.securityConfig.getSaml().getSp().getAttributesIncompleteRedirectUrl() != null) {
                errorStrBldr.append("Please visit ").append("<a href='").append(this.securityConfig.getSaml().getSp().getAttributesIncompleteRedirectUrl()).append("'>").append(this.securityConfig.getSaml().getSp().getAttributesIncompleteRedirectUrl()).append("</a> to validate your profile setup.");
            }
            attr.put("hint", errorStrBldr.toString());
            attr.put("error", HttpStatus.FORBIDDEN.value());
            attr.put("reason", HttpStatus.FORBIDDEN.getReasonPhrase());
        }
        return new ModelAndView("error", attr);
    }

    protected boolean isIncludeMessage(HttpServletRequest request, MediaType produces) {
        return true;
    }

    private void assembleMap(Map<String, Object> map, HttpStatus status) {
        map.put("error", status.value());
        map.put("reason", status.getReasonPhrase());
        map.put("localEnabled", this.securityConfig.getLocal().isEnabled());
        map.put("samlEnabled", this.securityConfig.getSaml().isEnabled());
    }
}

