/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.exceptions;

import de.unibamberg.minf.core.web.pojo.MessagePojo;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@ControllerAdvice
public class ControllerExceptionHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    public static final String DEFAULT_ERROR_VIEW = "error";

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={Exception.class})
    public Object defaultErrorHandler(HttpServletRequest req, Exception e) throws Exception {
        if (AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class) != null) {
            throw e;
        }
        logger.error(String.format("Caught server error at %s", req.getServletPath()), (Throwable)e);
        if (req.getHeader("accept") != null && req.getHeader("accept").toLowerCase().contains("json") || req.getServletPath().contains("/async/") || req.getServletPath().contains("/forms/")) {
            ModelActionPojo result = new ModelActionPojo(false);
            result.setMessage(new MessagePojo(DEFAULT_ERROR_VIEW, "Code: 500", null));
            result.addObjectError(e.getClass().getSimpleName() + ": " + e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)result);
        }
        ModelAndView mav = new ModelAndView(DEFAULT_ERROR_VIEW);
        mav.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        mav.addObject("errorHeading", (Object)"An internal server error has occurred");
        mav.addObject("errorMsg", (Object)e.getMessage());
        mav.addObject("url", (Object)req.getRequestURL());
        mav.addObject("exception", (Object)e);
        return mav;
    }
}

