/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.model.base.Terminal;
import de.unibamberg.minf.dme.model.datamodel.TerminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlNamespace;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlTerminal;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model/editor/{entityId}/terminal"})
public class TerminalEditorController
extends BaseScheregController {
    @Autowired
    private ElementService elementService;

    public TerminalEditorController() {
        super("schemaEditor");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/missing/{nonterminalId}/async/get"})
    @ResponseBody
    public Terminal getMissingTerminal(@PathVariable String entityId, @PathVariable String nonterminalId) throws Exception {
        XmlTerminal t = new XmlTerminal();
        t.setId(nonterminalId);
        t.setName("?");
        t.setNamespace("?");
        return t;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{terminalId}/async/get"})
    @ResponseBody
    public Terminal getTerminal(@PathVariable String entityId, @PathVariable String terminalId, @RequestParam(name="n") String modelClass, HttpServletRequest request) throws Exception {
        AuthPojo auth = this.authInfoHelper.getAuth();
        Class<?> modelClazz = Class.forName(modelClass);
        DatamodelNature n = ((Datamodel)this.schemaService.findByIdAndAuth(entityId, auth).getElement()).getNature(modelClazz);
        for (Terminal t : n.getTerminals()) {
            if (!t.getId().equals(terminalId)) continue;
            return t;
        }
        return null;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/{terminalId}/async/remove"})
    @ResponseBody
    public Terminal removeElement(@PathVariable String entityId, @PathVariable String terminalId, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        return this.elementService.removeTerminal(entityId, terminalId, this.authInfoHelper.getAuth());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{terminalId}/form/edit", "/missing/{nonterminalId}/form/edit"})
    public String getElement(@PathVariable String entityId, @PathVariable(required=false) String terminalId, @PathVariable(required=false) String nonterminalId, Model model, Locale locale, @RequestParam(name="n") String modelClass, HttpServletRequest request) throws ClassNotFoundException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            model.addAttribute("readonly", (Object)true);
        } else {
            model.addAttribute("readonly", (Object)false);
        }
        Class<?> modelClazz = Class.forName(modelClass);
        DatamodelNature n = ((Datamodel)this.schemaService.findByIdAndAuth(entityId, auth).getElement()).getNature(modelClazz);
        if (terminalId != null) {
            for (Terminal t : n.getTerminals()) {
                if (!t.getId().equals(terminalId)) continue;
                model.addAttribute("terminal", (Object)t);
            }
        } else if (nonterminalId != null) {
            if (modelClazz.equals(XmlDatamodelNature.class)) {
                model.addAttribute("terminal", (Object)new XmlTerminal());
            } else {
                model.addAttribute("terminal", (Object)new TerminalImpl());
            }
        }
        ArrayList<String> availableNamespaces = new ArrayList<String>();
        if (n instanceof XmlDatamodelNature && ((XmlDatamodelNature)n).getNamespaces() != null) {
            for (XmlNamespace ns : ((XmlDatamodelNature)n).getNamespaces()) {
                availableNamespaces.add(ns.getUrl());
            }
        }
        model.addAttribute("availableNamespaces", availableNamespaces);
        model.addAttribute("natureType", (Object)modelClass);
        if (terminalId != null) {
            model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/terminal/" + terminalId + "/async/save"));
        } else {
            model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/terminal/" + nonterminalId + "/async/append"));
        }
        if (modelClazz.equals(XmlDatamodelNature.class)) {
            return "elementEditor/form/edit_xml_terminal";
        }
        return "elementEditor/form/edit_terminal";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/{terminalId}/async/save", "/{nonterminalId}/async/append"})
    @ResponseBody
    public ModelActionPojo saveTerminal(@PathVariable String entityId, @PathVariable(required=false) String terminalId, @PathVariable(required=false) String nonterminalId, @RequestParam(defaultValue="false") boolean attribute, @RequestParam String name, @RequestParam(required=false) String namespace, @RequestParam(name="natureType") String natureType, @RequestParam(name="predicate", defaultValue="") String predicate, Locale locale, HttpServletRequest request, HttpServletResponse response) throws ClassNotFoundException, MetamodelConsistencyException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        Class<?> modelClazz = Class.forName(natureType);
        Datamodel m = (Datamodel)this.schemaService.findByIdAndAuth(entityId, auth).getElement();
        DatamodelNature n = m.getNature(modelClazz);
        if (!((String)predicate).isBlank() && ((String)predicate).charAt(0) != '[') {
            predicate = "[" + (String)predicate + "]";
        }
        if (terminalId != null) {
            for (Terminal t : n.getTerminals()) {
                if (!t.getId().equals(terminalId)) continue;
                t.setName(name);
                if (modelClazz.equals(XmlDatamodelNature.class)) {
                    ((XmlTerminal)t).setAttribute(attribute);
                    if (namespace.isBlank()) {
                        ((XmlTerminal)t).setNamespace(null);
                    } else {
                        ((XmlTerminal)t).setNamespace(namespace.trim());
                    }
                    if (((String)predicate).isBlank()) {
                        ((XmlTerminal)t).setPredicate(null);
                    } else {
                        ((XmlTerminal)t).setPredicate(((String)predicate).trim());
                    }
                }
                break;
            }
        } else if (nonterminalId != null) {
            XmlTerminal tAppend;
            if (modelClazz.equals(XmlDatamodelNature.class)) {
                tAppend = new XmlTerminal();
                tAppend.setAttribute(attribute);
                if (namespace.isBlank()) {
                    tAppend.setNamespace(null);
                } else {
                    tAppend.setNamespace(namespace.trim());
                }
                if (((String)predicate).isBlank()) {
                    tAppend.setPredicate(null);
                } else {
                    tAppend.setPredicate(((String)predicate).trim());
                }
            } else {
                tAppend = new TerminalImpl();
            }
            tAppend.setName(name);
            tAppend.setId(BaseDaoImpl.createNewObjectId());
            n.addTerminal((Terminal)tAppend);
            n.mapNonterminal(nonterminalId, tAppend.getId());
        }
        this.schemaService.saveSchema(m, auth);
        return new ModelActionPojo(true);
    }
}

