/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlNamespace;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model/editor/{entityId}/natures"})
public class NaturesEditorController
extends BaseScheregController {
    public NaturesEditorController() {
        super("schemaEditor");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/add"})
    public String getAddNatureForm(@PathVariable String entityId, Model model, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/natures/async/add"));
        model.addAttribute("natures", (Object)this.schemaService.getMissingNatures(entityId));
        return "naturesEditor/form/add";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/edit"})
    public String getEditNatureForm(@PathVariable String entityId, Model model, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        Datamodel m = this.schemaService.findSchemaById(entityId);
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/natures/async/updateXml"));
        model.addAttribute("xmlNature", (Object)m.getNature(XmlDatamodelNature.class));
        return "naturesEditor/form/editXml";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/updateXml"})
    @ResponseBody
    public ModelActionPojo updateXmlNature(@PathVariable String entityId, @ModelAttribute XmlDatamodelNature xmlNature, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ArrayList<String> prefices = new ArrayList<String>();
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<XmlNamespace> namespaces = new ArrayList<XmlNamespace>();
        for (XmlNamespace xmlNs : xmlNature.getNamespaces()) {
            if (xmlNs.getPrefix() != null && !xmlNs.getPrefix().trim().isEmpty() && prefices.contains(xmlNs.getPrefix().trim())) {
                ModelActionPojo result = new ModelActionPojo(false);
                result.addFieldError("edit-nature-namespaces", this.messageSource.getMessage("~de.unibamberg.minf.dme.form.nature.hint.duplicate_namespace_prefices", null, locale));
                return result;
            }
            if (urls.contains(xmlNs.getUrl().trim())) continue;
            prefices.add(xmlNs.getPrefix().trim());
            urls.add(xmlNs.getUrl().trim());
            namespaces.add(xmlNs);
        }
        xmlNature.setNamespaces(namespaces);
        this.schemaService.updateNature(entityId, xmlNature, auth);
        return new ModelActionPojo(true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/add"})
    @ResponseBody
    public ModelActionPojo addNewNature(@PathVariable String entityId, @RequestParam(name="n") String natureClass, @RequestParam(defaultValue="false") boolean autocreate, @RequestParam(name="element-naming") String naming, HttpServletRequest request, HttpServletResponse response) throws ClassNotFoundException, MetamodelConsistencyException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        this.schemaService.addNature(entityId, natureClass, auth);
        if (autocreate) {
            this.schemaService.createTerminals(entityId, natureClass, naming, auth);
        }
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)natureClass);
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/remove"})
    @ResponseBody
    public ModelActionPojo removeNature(@PathVariable String entityId, @RequestParam(name="n") String natureClass, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        this.schemaService.removeNature(entityId, natureClass, auth);
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)natureClass);
        return result;
    }
}

