/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.core.web.pojo.MessagePojo;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseMainEditorController;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.exporter.DatamodelExporter;
import de.unibamberg.minf.dme.importer.DatamodelImportWorker;
import de.unibamberg.minf.dme.importer.datamodel.DatamodelImporter;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.base.Terminal;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.serialization.DatamodelReferenceContainer;
import de.unibamberg.minf.dme.pojo.converter.AuthWrappedPojoConverter;
import de.unibamberg.minf.dme.pojo.converter.ModelElementPojoConverter;
import de.unibamberg.minf.dme.service.ElementServiceImpl;
import de.unibamberg.minf.dme.service.base.BaseEntityService;
import de.unibamberg.minf.dme.service.interfaces.IdentifiableService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model/editor/{entityId}/"})
public class ModelEditorController
extends BaseMainEditorController
implements InitializingBean {
    @Autowired
    private DatamodelImportWorker importWorker;
    @Autowired
    private AuthWrappedPojoConverter authPojoConverter;
    @Autowired
    private IdentifiableService identifiableService;
    @Autowired
    private DatamodelExporter datamodelExporter;

    protected String getPrefix() {
        return "/model/editor/";
    }

    protected DatamodelImportWorker getImportWorker() {
        return this.importWorker;
    }

    protected BaseEntityService getMainEntityService() {
        return this.schemaService;
    }

    public ModelEditorController() {
        super("schemaEditor");
    }

    @GetMapping(value={"/query/{query}"})
    @ResponseBody
    public List<Identifiable> queryElements(@PathVariable String entityId, @PathVariable String query, @RequestParam(required=false) List<String> types, @RequestParam(required=false) List<String> excludeIds) {
        ArrayList<Class> requestedClasses = new ArrayList<Class>();
        if (types == null) {
            requestedClasses.add(Nonterminal.class);
            requestedClasses.add(GrammarImpl.class);
        } else {
            if (types.contains("Nonterminal")) {
                requestedClasses.add(Nonterminal.class);
            }
            if (types.contains("Label")) {
                requestedClasses.add(Label.class);
            }
            if (types.contains("GrammarImpl")) {
                requestedClasses.add(GrammarImpl.class);
            }
            if (types.contains("FunctionImpl")) {
                requestedClasses.add(FunctionImpl.class);
            }
        }
        return this.identifiableService.findByNameAndSchemaId(query, entityId, requestedClasses.toArray(new Class[0]), excludeIds);
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    public String getEditor(@PathVariable String entityId, Model model, @ModelAttribute String sample, Locale locale, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer schema = this.schemaService.findByIdAndAuth(entityId, auth);
        if (schema == null) {
            return "redirect:/registry/";
        }
        model.addAttribute("schema", (Object)this.authPojoConverter.convert(schema, auth.getUserId()));
        List mappings = this.mappingService.getMappings(entityId);
        model.addAttribute("mapped", (Object)(mappings != null && !mappings.isEmpty() ? 1 : 0));
        return "schemaEditor";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/editor"})
    public String getEditorIncl(@PathVariable String entityId, Model model, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer schema = this.schemaService.findByIdAndAuth(entityId, auth);
        model.addAttribute("datamodel", (Object)this.authPojoConverter.convert(schema, auth.getUserId()));
        return "schemaEditor/incl/editor";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/properties"})
    public String getEntityProperties(@PathVariable String entityId, Model model, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer schema = this.schemaService.findByIdAndAuth(entityId, auth);
        model.addAttribute("datamodel", (Object)this.authPojoConverter.convert(schema, auth.getUserId()));
        return "schemaEditor/incl/properties";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/forms/edit"})
    public String getEditForm(@PathVariable String entityId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        RightsContainer schema = this.schemaService.findByIdAndAuth(entityId, this.authInfoHelper.getAuth());
        model.addAttribute("actionPath", (Object)"/model/async/save");
        model.addAttribute("datamodelImpl", (Object)schema.getElement());
        model.addAttribute("readOnly", (Object)schema.isReadOnly());
        return "model/form/edit";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/delete"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo deleteSchema(@PathVariable String entityId, HttpServletRequest request, HttpServletResponse response) {
        ModelActionPojo result;
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        if (entityId != null && !entityId.isEmpty()) {
            this.schemaService.deleteSchemaById(entityId, this.authInfoHelper.getAuth());
            result = new ModelActionPojo(true);
        } else {
            result = new ModelActionPojo(false);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/forms/import"})
    public String getImportForm(@PathVariable String entityId, @RequestParam(required=false) String elementId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/async/import"));
        model.addAttribute("schema", (Object)this.schemaService.findSchemaById(entityId));
        if (elementId != null) {
            model.addAttribute("elementId", (Object)elementId);
        }
        return "schemaEditor/form/import";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/createRoot"})
    public String getNewNonterminalForm(@PathVariable String entityId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("element", (Object)new NonterminalImpl());
        model.addAttribute("availableTerminals", (Object)this.schemaService.getAvailableTerminals(entityId));
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/async/saveNewRoot"));
        return "elementEditor/form/edit_nonterminal";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveNewRoot"})
    @ResponseBody
    public ModelActionPojo saveNonterminal(@PathVariable String entityId, @Valid NonterminalImpl element, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            element.setEntityId(entityId);
            this.elementService.saveOrReplaceRoot(entityId, (Nonterminal)element, this.authInfoHelper.getAuth());
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/import"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo importSchemaElements(@PathVariable String entityId, @RequestParam(value="file.id") String fileId, @RequestParam(required=false, value="elementId") String elementId, @RequestParam(value="schema_root_qn") String schemaRoot, @RequestParam(required=false, value="schema_root_type") String schemaRootType, @RequestParam(required=false, value="schema_root_id") String schemaRootId, @RequestParam(defaultValue="false", value="keep-imported-ids") boolean keepImportedIds, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        if (schemaRootId != null && schemaRootId.isEmpty()) {
            schemaRootId = null;
        }
        ModelActionPojo result = new ModelActionPojo();
        try {
            if (temporaryFilesMap.containsKey(fileId)) {
                if (schemaRoot.isEmpty()) {
                    result.setSuccess(false);
                    result.addFieldError("schema_root", this.messageSource.getMessage("~de.unibamberg.minf.dme.notification.import.root_missing", null, locale));
                    return result;
                }
                if (elementId != null) {
                    this.importWorker.importSubtree((String)temporaryFilesMap.remove(fileId), entityId, elementId, schemaRootId != null ? schemaRootId : schemaRoot, schemaRootType, keepImportedIds, this.authInfoHelper.getAuth());
                } else {
                    Datamodel m = (Datamodel)this.schemaService.findByIdAndAuth(entityId, auth).getElement();
                    m.setNatures(null);
                    this.elementService.clearElementTree(entityId, auth);
                    this.schemaService.saveSchema(m, auth);
                    this.importWorker.importSchema((String)temporaryFilesMap.remove(fileId), entityId, schemaRootId != null ? schemaRootId : schemaRoot, keepImportedIds, this.authInfoHelper.getAuth());
                }
                result.setSuccess(true);
                return result;
            }
        }
        catch (Exception e) {
            MessagePojo msg = new MessagePojo("danger", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.generalerror.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.generalerror.body", new Object[]{e.getLocalizedMessage()}, locale));
            result.setMessage(msg);
        }
        result.setSuccess(false);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/export"})
    @ResponseBody
    public ModelActionPojo exportSchema(@PathVariable String entityId, Model model, HttpServletRequest request, Locale locale) {
        DatamodelReferenceContainer container = this.datamodelExporter.exportDatamodel(entityId, this.authInfoHelper.getAuth());
        if (container == null) {
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)container);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/exportSubtree"})
    @ResponseBody
    public ModelActionPojo exportSubtree(@PathVariable String entityId, @RequestParam String elementId, Model model, HttpServletRequest request, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)this.datamodelExporter.exportDatamodelSubtree(entityId, elementId, auth));
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getHierarchy"})
    @ResponseBody
    public ModelActionPojo getHierarchy(@PathVariable String entityId, @RequestParam(defaultValue="false") boolean staticElementsOnly, @RequestParam(defaultValue="false") boolean collectNatureClasses, @RequestParam(defaultValue="logical_model", name="model") String modelClass, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) throws IOException, GenericScheregException {
        ModelActionPojo rPojo = new ModelActionPojo(true);
        AuthPojo auth = this.authInfoHelper.getAuth();
        Element result = this.elementService.findRootBySchemaId(entityId, true);
        if (result == null) {
            response.getWriter().print("null");
            response.setContentType("application/json");
            return null;
        }
        HashMap<String, ArrayList<String>> nonterminalNatureClassesMap = new HashMap<String, ArrayList<String>>();
        Datamodel m = (Datamodel)this.schemaService.findByIdAndAuth(entityId, auth).getElement();
        if (modelClass.equals("logical_model")) {
            if (m.getNatures() != null) {
                for (DatamodelNature n : m.getNatures()) {
                    if (n.getNonterminalTerminalIdMap() == null) continue;
                    for (String nId : n.getNonterminalTerminalIdMap().keySet()) {
                        ArrayList<String> natureClasses = (ArrayList<String>)nonterminalNatureClassesMap.get(nId);
                        if (natureClasses == null) {
                            natureClasses = new ArrayList<String>();
                        }
                        natureClasses.add(n.getClass().getName());
                        nonterminalNatureClassesMap.put(nId, natureClasses);
                    }
                }
            }
            rPojo.setPojo((Object)ModelElementPojoConverter.convertModelElement((Element)result, nonterminalNatureClassesMap, (boolean)staticElementsOnly));
        } else {
            try {
                DatamodelNature n;
                Class<?> modelClazz = Class.forName(modelClass);
                n = ((Datamodel)this.schemaService.findByIdAndAuth(entityId, auth).getElement()).getNature(modelClazz);
                rPojo.setPojo((Object)ModelElementPojoConverter.convertModelElementTerminal((Element)result, (DatamodelNature)n));
            }
            catch (Exception e) {
                this.logger.error(String.format("Failed to retrieve model of class %s for datamodel %s", modelClass, entityId), (Throwable)e);
            }
        }
        ObjectNode statusNode = this.objectMapper.createObjectNode();
        boolean headers = false;
        Element processingRoot = ElementServiceImpl.findProcessingRoot((Element)result);
        if (processingRoot == null || processingRoot.isIncludeHeader()) {
            headers = true;
        }
        statusNode.put("includeHeaders", headers);
        rPojo.setStatusInfo((Object)statusNode);
        return rPojo;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getTerminals"})
    @ResponseBody
    public List<? extends Terminal> getTerminals(@PathVariable String entityId) {
        Datamodel s = this.schemaService.findSchemaById(entityId);
        if (s.getNature(XmlDatamodelNature.class) != null) {
            return ((XmlDatamodelNature)s.getNature(XmlDatamodelNature.class)).getTerminals();
        }
        return null;
    }

    protected ModelActionPojo validateImportedFile(String entityId, String fileId, String elementId, Locale locale) {
        JsonNode rootNodes;
        ModelActionPojo result = new ModelActionPojo();
        DatamodelImporter importer = (DatamodelImporter)this.importWorker.getSupportingImporter((String)temporaryFilesMap.get(fileId));
        if (importer == null) {
            MessagePojo msg = new MessagePojo("danger", this.messageSource.getMessage("~de.unibamberg.minf.dme.notification.no_importer_matched.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.dme.notification.no_importer_matched.body", null, locale));
            result.setMessage(msg);
            return result;
        }
        if (elementId == null) {
            rootNodes = this.objectMapper.valueToTree((Object)importer.getPossibleRootElements());
        } else {
            List allowedSubtreeRoots = this.identifiableService.getAllowedSubelementTypes(elementId);
            rootNodes = this.objectMapper.valueToTree((Object)importer.getElementsByTypes(allowedSubtreeRoots));
        }
        if (!rootNodes.isEmpty()) {
            result.setSuccess(true);
            MessagePojo msg = new MessagePojo("success", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationsucceeded.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationsucceeded.body", null, locale));
            result.setMessage(msg);
            ObjectNode pojoNode = this.objectMapper.createObjectNode();
            pojoNode.set("elements", rootNodes);
            pojoNode.set("keepIdsAllowed", (JsonNode)BooleanNode.valueOf((boolean)importer.isKeepImportedIdsSupported()));
            pojoNode.set("importerMainType", (JsonNode)TextNode.valueOf((String)importer.getMainImporterType()));
            pojoNode.set("importerSubtype", (JsonNode)TextNode.valueOf((String)importer.getImporterSubtype()));
            result.setPojo((Object)pojoNode);
        }
        return result;
    }
}

