/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.core.util.Stopwatch;
import de.unibamberg.minf.core.web.pojo.MessagePojo;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseMainEditorController;
import de.unibamberg.minf.dme.importer.MappingImportWorker;
import de.unibamberg.minf.dme.importer.mapping.MappingImporter;
import de.unibamberg.minf.dme.model.LogEntry;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.SessionExecutionContext;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.mapping.MappingImpl;
import de.unibamberg.minf.dme.model.mapping.base.MappedConcept;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.model.mapping.base.RelatedConcept;
import de.unibamberg.minf.dme.model.serialization.MappingContainer;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.pojo.AuthWrappedPojo;
import de.unibamberg.minf.dme.pojo.RelatedConceptPojo;
import de.unibamberg.minf.dme.pojo.converter.AuthWrappedPojoConverter;
import de.unibamberg.minf.dme.pojo.converter.RelatedConceptPojoConverter;
import de.unibamberg.minf.dme.service.base.BaseEntityService;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.PersistedSessionService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.mapping.model.MappingExecGroup;
import de.unibamberg.minf.mapping.service.MappingExecutionService;
import de.unibamberg.minf.processing.consumption.CollectingResourceConsumptionServiceImpl;
import de.unibamberg.minf.processing.consumption.ResourceConsumptionService;
import de.unibamberg.minf.processing.exception.ProcessingConfigException;
import de.unibamberg.minf.processing.model.base.Resource;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mapping/editor/{entityId}/"})
public class MappingEditorController
extends BaseMainEditorController {
    @Autowired
    private MappingImportWorker importWorker;
    @Autowired
    private GrammarService grammarService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private RelatedConceptService relatedConceptService;
    @Autowired
    private AuthWrappedPojoConverter authPojoConverter;
    @Autowired
    private PersistedSessionService sessionService;

    protected String getPrefix() {
        return "/mapping/editor/";
    }

    protected MappingImportWorker getImportWorker() {
        return this.importWorker;
    }

    protected BaseEntityService getMainEntityService() {
        return this.mappingService;
    }

    public MappingEditorController() {
        super("mappingEditor");
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String getEditor(@PathVariable String entityId, Model model, HttpServletRequest request, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer mapping = this.mappingService.findByIdAndAuth(entityId, auth);
        AuthWrappedPojo mappingPojo = this.authPojoConverter.convert(mapping, auth.getUserId());
        if (mapping == null) {
            return "redirect:/registry/";
        }
        model.addAttribute("mapping", (Object)mappingPojo);
        model.addAttribute("source", (Object)this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(((Mapping)mappingPojo.getPojo()).getSourceId(), auth), auth.getUserId()));
        model.addAttribute("target", (Object)this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(((Mapping)mappingPojo.getPojo()).getTargetId(), auth), auth.getUserId()));
        boolean oversized = false;
        try {
            PersistedSession s = this.sessionService.accessOrCreate(entityId, request.getSession().getId(), auth.getUserId());
            model.addAttribute("session", (Object)s);
            oversized = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to load/initialize persisted session", (Throwable)e);
        }
        model.addAttribute("sampleInputOversize", (Object)oversized);
        return "mappingEditor";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/editor"})
    public String getEditorIncl(@PathVariable String entityId, Model model, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer mapping = this.mappingService.findByIdAndAuth(entityId, auth);
        AuthWrappedPojo mappingPojo = this.authPojoConverter.convert(mapping, auth.getUserId());
        model.addAttribute("mapping", (Object)mappingPojo);
        model.addAttribute("source", (Object)this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(((Mapping)mappingPojo.getPojo()).getSourceId(), auth), auth.getUserId()));
        model.addAttribute("target", (Object)this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(((Mapping)mappingPojo.getPojo()).getTargetId(), auth), auth.getUserId()));
        return "mappingEditor/incl/editor";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/properties"})
    public String getEntityProperties(@PathVariable String entityId, Model model, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer mapping = this.mappingService.findByIdAndAuth(entityId, auth);
        AuthWrappedPojo mappingPojo = this.authPojoConverter.convert(mapping, auth.getUserId());
        model.addAttribute("mapping", (Object)mappingPojo);
        model.addAttribute("source", (Object)this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(((Mapping)mappingPojo.getPojo()).getSourceId(), auth), auth.getUserId()));
        model.addAttribute("target", (Object)this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(((Mapping)mappingPojo.getPojo()).getTargetId(), auth), auth.getUserId()));
        return "mappingEditor/incl/properties";
    }

    @RequestMapping(value={"/async/getConcept"}, method={RequestMethod.GET})
    @ResponseBody
    public RelatedConceptPojo getMappedConcepts(@PathVariable String entityId, @RequestParam String id, Model model) {
        return RelatedConceptPojoConverter.convert((RelatedConcept)this.relatedConceptService.findById(id), (Map)RelatedConceptPojoConverter.convertFunctionsToIdFunctionMap((List)this.functionService.findByEntityId(entityId)));
    }

    @RequestMapping(value={"/async/getConcepts"}, method={RequestMethod.GET})
    @ResponseBody
    public List<RelatedConceptPojo> getMappedConcepts(@PathVariable String entityId, Model model) {
        return RelatedConceptPojoConverter.convert((List)this.relatedConceptService.findAllByMappingId(entityId), (List)this.functionService.findByEntityId(entityId));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/forms/import"})
    public String getImportForm(@PathVariable String entityId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("actionPath", (Object)("/mapping/editor/" + entityId + "/async/import"));
        model.addAttribute("mapping", (Object)this.mappingService.findMappingById(entityId));
        return "mapping/form/import";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/import"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo importSchemaElements(@PathVariable String entityId, @RequestParam(value="file.id") String fileId, @RequestParam(defaultValue="false", value="keep-imported-ids") boolean keepImportedIds, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = new ModelActionPojo();
        try {
            if (temporaryFilesMap.containsKey(fileId)) {
                this.importWorker.importMapping((String)temporaryFilesMap.remove(fileId), entityId, keepImportedIds, this.authInfoHelper.getAuth());
                result.setSuccess(true);
                return result;
            }
        }
        catch (Exception e) {
            MessagePojo msg = new MessagePojo("danger", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.generalerror.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.generalerror.body", new Object[]{e.getLocalizedMessage()}, locale));
            result.setMessage(msg);
            this.logger.error("Failed to import mapping", (Throwable)e);
        }
        result.setSuccess(false);
        return result;
    }

    protected ModelActionPojo validateImportedFile(String entityId, String fileId, String elementId, Locale locale) {
        ModelActionPojo result = new ModelActionPojo();
        MappingImporter importer = (MappingImporter)this.importWorker.getSupportingImporter((String)temporaryFilesMap.get(fileId));
        if (importer != null) {
            result.setSuccess(true);
            MessagePojo msg = new MessagePojo("success", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationsucceeded.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationsucceeded.body", null, locale));
            result.setMessage(msg);
            ObjectNode pojoNode = this.objectMapper.createObjectNode();
            pojoNode.set("keepIdsAllowed", (JsonNode)BooleanNode.valueOf((boolean)importer.isKeepImportedIdsSupported()));
            pojoNode.set("importerMainType", (JsonNode)TextNode.valueOf((String)importer.getMainImporterType()));
            pojoNode.set("importerSubtype", (JsonNode)TextNode.valueOf((String)importer.getImporterSubtype()));
            result.setPojo((Object)pojoNode);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/executeSampleMapping"})
    @ResponseBody
    public ModelActionPojo executeSampleMapping(@PathVariable String entityId, HttpServletRequest request, HttpServletResponse response, Locale locale) throws ProcessingConfigException {
        Stopwatch sw = new Stopwatch().start();
        Stopwatch swTotal = new Stopwatch().start();
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)0);
        PersistedSession session = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (session == null) {
            response.setStatus(205);
            return null;
        }
        if (this.debugConfig.isProcessing()) {
            this.logger.debug("Session for transformation loaded [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            sw.reset();
        }
        Mapping m = this.mappingService.findMappingById(entityId);
        List inputResources = this.sessionService.loadSampleOutput(session.getId());
        List mappedResources = null;
        if (inputResources != null && !inputResources.isEmpty()) {
            Element r = this.elementService.findRootBySchemaId(m.getTargetId(), true);
            List concepts = this.relatedConceptService.findAllByMappingId(m.getId(), true);
            MappingExecutionService mappingExecService = (MappingExecutionService)this.appContext.getBean(MappingExecutionService.class);
            CollectingResourceConsumptionServiceImpl consumptionService = new CollectingResourceConsumptionServiceImpl();
            SessionExecutionContext ctx = null;
            try {
                ctx = new SessionExecutionContext(this.mainConfig.getPaths().getSessionData(), session.getId(), this.sessionService.loadSessionData(session.getId()));
            }
            catch (Exception e) {
                this.logger.error("Failed to create session execution context", (Throwable)e);
            }
            Datamodel sourceModel = this.schemaService.findSchemaById(m.getSourceId());
            Element sourceRootElement = this.elementService.findRootBySchemaId(m.getSourceId(), true);
            MappingExecGroup mapExecGroup = new MappingExecGroup(m, (ExecutionContext)ctx, r, entityId, sourceModel, sourceRootElement);
            if (this.debugConfig.isProcessing()) {
                this.logger.debug("Mapping loaded [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
                sw.reset();
            }
            for (Grammar g : this.grammarService.findByEntityId(m.getId(), true)) {
                mapExecGroup.addGrammar(g);
            }
            for (RelatedConcept c : concepts) {
                if (MappedConcept.class.isAssignableFrom(c.getClass())) {
                    MappedConcept mc = (MappedConcept)MappedConcept.class.cast(c);
                    mapExecGroup.addRelatedConcept((RelatedConcept)mc, this.functionService.findById(mc.getFunctionId()));
                    continue;
                }
                mapExecGroup.addRelatedConcept(c, null);
            }
            mappingExecService.init(mapExecGroup, inputResources);
            mappingExecService.addConsumptionService((ResourceConsumptionService)consumptionService);
            if (this.debugConfig.isProcessing()) {
                this.logger.debug("Mapping initialized [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
                sw.reset();
            }
            mappingExecService.run();
            if (this.debugConfig.isProcessing()) {
                this.logger.debug("Transformation to target datamodel [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            }
            mappedResources = consumptionService.getResources();
        }
        this.sessionService.saveSampleMapped(session.getId(), mappedResources);
        int count = 0;
        if (mappedResources != null && !mappedResources.isEmpty()) {
            for (Resource r : mappedResources) {
                if (r == null) continue;
                ++count;
            }
            result.setPojo((Object)count);
            if (count == 1) {
                session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.SUCCESS, (String)"~de.unibamberg.minf.dme.editor.sample.log.translated_1_result", (Object[])new Object[]{sw.getElapsedTime(), swTotal.getElapsedTime()}));
            } else {
                session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.SUCCESS, (String)"~de.unibamberg.minf.dme.editor.sample.log.translated_n_results", (Object[])new Object[]{sw.getElapsedTime(), swTotal.getElapsedTime(), count}));
            }
        } else if (inputResources == null || inputResources.isEmpty()) {
            session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.WARNING, (String)"~de.unibamberg.minf.dme.editor.sample.log.translated_no_input", null));
        } else {
            session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.WARNING, (String)"~de.unibamberg.minf.dme.editor.sample.log.translated_no_results", null));
        }
        session.setSampleMappedCount(count);
        this.sessionService.saveSession(session);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/export"})
    @ResponseBody
    public ModelActionPojo exportMapping(@PathVariable String entityId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        List grammars;
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        MappingImpl m = (MappingImpl)this.mappingService.findMappingById(entityId);
        m.setConcepts(this.relatedConceptService.findAllByMappingId(entityId, true));
        m.flush();
        MappingContainer mc = new MappingContainer();
        mc.setMapping(m);
        ChangeSet ch = this.schemaService.getLatestChangeSetForEntity(m.getId());
        if (ch != null) {
            m.setVersionId(ch.getId());
        }
        if ((grammars = this.grammarService.getNonPassthroughGrammars(entityId)) != null && !grammars.isEmpty()) {
            mc.setGrammars(new HashMap());
            for (Grammar g : grammars) {
                mc.getGrammars().put(g.getId(), g);
            }
        }
        HashMap<String, String> serializedFunctions = new HashMap<String, String>();
        List functions = this.functionService.findByEntityId(entityId);
        for (Function f : functions) {
            serializedFunctions.put(f.getId(), f.getFunction());
        }
        mc.setFunctions(serializedFunctions);
        HashMap elementIdPathMap = new HashMap();
        List elementIds = m.getConcepts().stream().flatMap(c -> Stream.concat(c.getElementGrammarIdsMap().keySet().stream(), c.getTargetElementIds().stream())).collect(Collectors.toList());
        this.fillElementIdPathMap(elementIdPathMap, elementIds, new ArrayList(), this.elementService.findRootBySchemaId(m.getSourceId(), true), "");
        this.fillElementIdPathMap(elementIdPathMap, elementIds, new ArrayList(), this.elementService.findRootBySchemaId(m.getTargetId(), true), "");
        mc.setElementPaths(elementIdPathMap);
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)mc);
        return result;
    }

    private void fillElementIdPathMap(Map<String, String> elementIdPathMap, List<String> elementIds, List<String> scannedIds, Element e, String path) {
        String subpath;
        if (scannedIds.contains(e.getId())) {
            return;
        }
        scannedIds.add(e.getId());
        String string = subpath = path.isEmpty() ? e.getName() : path + "." + e.getName();
        if (elementIds.contains(e.getId()) && !elementIdPathMap.containsKey(e.getId())) {
            elementIdPathMap.put(e.getId(), subpath);
        }
        e.getAllChildElements().stream().forEach(c -> this.fillElementIdPathMap(elementIdPathMap, elementIds, scannedIds, c, subpath));
    }
}

