/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import com.fasterxml.jackson.databind.JsonNode;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.confg.DebugConfig;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.mapping.ExportedConceptImpl;
import de.unibamberg.minf.dme.model.mapping.MappedConceptImpl;
import de.unibamberg.minf.dme.model.mapping.base.ExportedConcept;
import de.unibamberg.minf.dme.model.mapping.base.MappedConcept;
import de.unibamberg.minf.dme.model.mapping.base.RelatedConcept;
import de.unibamberg.minf.dme.pojo.ModelElementPojo;
import de.unibamberg.minf.dme.pojo.RelatedConceptPojo;
import de.unibamberg.minf.dme.pojo.TreeElementPojo;
import de.unibamberg.minf.dme.pojo.converter.ModelElementPojoConverter;
import de.unibamberg.minf.dme.pojo.converter.RelatedConceptPojoConverter;
import de.unibamberg.minf.dme.pojo.converter.ResourcePojoConverter;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.PersistedSessionService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import de.unibamberg.minf.processing.exception.ProcessingConfigException;
import de.unibamberg.minf.processing.model.base.Resource;
import de.unibamberg.minf.processing.output.json.JsonStringOutputService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mapping/editor/{mappingId}/mappedconcept/{mappedConceptId}"})
public class MappedConceptEditorController
extends BaseScheregController {
    private static final Logger log = LoggerFactory.getLogger(MappedConceptEditorController.class);
    @Autowired
    private RelatedConceptService relatedConceptService;
    @Autowired
    private ElementService elementService;
    @Autowired
    private GrammarService grammarService;
    @Autowired
    private PersistedSessionService sessionService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private DebugConfig debugConfig;

    public MappedConceptEditorController() {
        super("mappingEditor");
    }

    @RequestMapping(value={"/async/get"}, method={RequestMethod.GET})
    @ResponseBody
    public RelatedConceptPojo getMappedConcept(@PathVariable String mappingId, @PathVariable String mappedConceptId, Model model, HttpServletRequest request) {
        return RelatedConceptPojoConverter.convert((RelatedConcept)this.relatedConceptService.findById(mappingId, mappedConceptId, true), (Map)RelatedConceptPojoConverter.convertFunctionsToIdFunctionMap((List)this.functionService.findByEntityId(mappingId)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/switchConceptType"})
    @ResponseBody
    public ModelActionPojo switchConceptType(@PathVariable String mappingId, @PathVariable String mappedConceptId, @RequestParam String type, HttpServletRequest request, HttpServletResponse response) throws GenericScheregException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(mappingId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        RelatedConcept switchResult = this.relatedConceptService.switchConceptType(mappingId, mappedConceptId, RelatedConceptPojo.MappingTypes.valueOf((String)type), this.authInfoHelper.getAuth());
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)RelatedConceptPojoConverter.convert((RelatedConcept)switchResult, (Map)RelatedConceptPojoConverter.convertFunctionsToIdFunctionMap((List)this.functionService.findByEntityId(mappingId))));
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/remove"})
    @ResponseBody
    public ModelActionPojo removeConcept(@PathVariable String mappingId, @PathVariable String mappedConceptId, HttpServletRequest request, HttpServletResponse response) throws GenericScheregException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(mappingId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        this.relatedConceptService.removeRelatedConcept(mappingId, mappedConceptId, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/save"})
    @ResponseBody
    public ModelActionPojo saveConcept(@PathVariable String mappingId, @PathVariable String mappedConceptId, @RequestParam(value="sourceElementId[]") List<String> sourceElementId, @RequestParam(value="targetElementId[]") List<String> targetElementIds, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(mappingId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        MappedConceptImpl c = null;
        if (mappedConceptId != null && !mappedConceptId.equals("") && !mappedConceptId.equals("undefined")) {
            c = this.relatedConceptService.findById(mappedConceptId);
        }
        if (c == null) {
            c = new MappedConceptImpl();
            c.setElementGrammarIdsMap(new HashMap());
        }
        c.setEntityId(mappingId);
        for (String sourceId : sourceElementId) {
            if (c.getElementGrammarIdsMap().keySet().contains(sourceId)) continue;
            c.getElementGrammarIdsMap().put(sourceId, null);
        }
        for (String targetElementId : targetElementIds) {
            if (c.getTargetElementIds() == null) {
                c.setTargetElementIds(new ArrayList());
            }
            if (c.getTargetElementIds().contains(targetElementId)) continue;
            c.getTargetElementIds().add(targetElementId);
        }
        this.relatedConceptService.saveRelatedConcept((RelatedConcept)c, mappingId, auth);
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)c);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/function"})
    @ResponseBody
    public String getConceptFunction(@PathVariable String mappingId, @PathVariable String mappedConceptId, Model model, Locale locale, HttpServletResponse response) throws IOException {
        RelatedConcept rc = this.relatedConceptService.findById(mappingId, mappedConceptId, false);
        if (MappedConcept.class.isAssignableFrom(rc.getClass())) {
            return ((MappedConcept)MappedConcept.class.cast(rc)).getFunctionId();
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/source"})
    @ResponseBody
    public List<ModelElementPojo> getRenderedSource(@PathVariable String mappingId, @PathVariable String mappedConceptId, Model model, Locale locale, HttpServletResponse response) throws IOException, GenericScheregException {
        RelatedConcept mc = this.relatedConceptService.findById(mappingId, mappedConceptId, true);
        if (mc == null) {
            response.getWriter().print("null");
            return null;
        }
        ArrayList loadIds = new ArrayList();
        loadIds.addAll(mc.getElementGrammarIdsMap().keySet());
        List sourceElements = this.elementService.findByIds(loadIds);
        block0: for (String sourceId : mc.getElementGrammarIdsMap().keySet()) {
            for (Element sourceElement : sourceElements) {
                if (!sourceId.equals(sourceElement.getId())) continue;
                sourceElement.setGrammars(new ArrayList());
                sourceElement.getGrammars().add((GrammarImpl)this.grammarService.findById((String)mc.getElementGrammarIdsMap().get(sourceId)));
                continue block0;
            }
        }
        return ModelElementPojoConverter.convertModelElements((List)sourceElements, (boolean)false);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/source/{sourceId}/remove"})
    @ResponseBody
    public ModelActionPojo removeSource(@PathVariable String mappingId, @PathVariable String mappedConceptId, @PathVariable String sourceId, HttpServletRequest request) throws GenericScheregException {
        this.relatedConceptService.removeSourceElementById(this.authInfoHelper.getAuth(), mappingId, mappedConceptId, sourceId);
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/target"})
    @ResponseBody
    public List<ModelElementPojo> getRenderedTargets(@PathVariable String mappingId, @PathVariable String mappedConceptId, Model model, Locale locale, HttpServletResponse response) throws IOException, GenericScheregException {
        RelatedConcept mc = this.relatedConceptService.findById(mappingId, mappedConceptId, true);
        if (mc == null) {
            response.getWriter().print("null");
            return null;
        }
        ArrayList targetElementIds = new ArrayList();
        targetElementIds.addAll(mc.getTargetElementIds());
        return ModelElementPojoConverter.convertModelElements((List)this.elementService.findByIds(targetElementIds), (boolean)false);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/target/{targetId}/remove"})
    @ResponseBody
    public ModelActionPojo removeTarget(@PathVariable String mappingId, @PathVariable String mappedConceptId, @PathVariable String targetId, HttpServletRequest request, HttpServletResponse response) throws GenericScheregException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(mappingId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        RelatedConcept mc = this.relatedConceptService.findById(mappingId, mappedConceptId, true);
        if (mc.getTargetElementIds().contains(targetId)) {
            mc.getTargetElementIds().remove(targetId);
        }
        if (mc.getTargetElementIds().isEmpty()) {
            this.relatedConceptService.removeRelatedConcept(mappingId, mc.getId(), auth);
        } else {
            this.relatedConceptService.saveRelatedConcept(mc, mappingId, auth);
        }
        return new ModelActionPojo(true);
    }

    @GetMapping(value={"/form/editExport"})
    public String getEditExportForm(@PathVariable String mappingId, @PathVariable String mappedConceptId, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        PersistedSession s = this.sessionService.get(mappingId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        RelatedConcept rc = this.setupEditModel(mappingId, mappedConceptId, s, response, model, locale);
        String schemaId = this.mappingService.findMappingById(mappingId).getSourceId();
        Datamodel dm = this.schemaService.findSchemaById(schemaId);
        this.addExportSampleToModel(s, rc, model);
        model.addAttribute("formats", (Object)ExportedConceptImpl.ExportFormats.values());
        model.addAttribute("natures", dm.getNatures() != null ? dm.getNatures().stream().map(n -> n.getClass().getSimpleName()).collect(Collectors.toList()) : new ArrayList());
        model.addAttribute("actionPath", (Object)("/mapping/editor/" + mappingId + "/mappedconcept/" + mappedConceptId + "/async/saveExport"));
        return "conceptEditor/form/edit_export_concept";
    }

    @PreAuthorize(value="isAuthenticated()")
    @PostMapping(value={"/async/saveExport"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo saveExport(@PathVariable String mappingId, @PathVariable String mappedConceptId, @Valid ExportedConceptImpl concept, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(mappingId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (!result.isSuccess()) {
            return result;
        }
        ExportedConcept ec = (ExportedConcept)this.relatedConceptService.findById(mappedConceptId);
        if (!ec.getEntityId().equals(mappingId)) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ec.setFormat(concept.getFormat());
        ec.setIncludeTree(concept.isIncludeTree());
        ec.setEscape(concept.isEscape());
        ec.setIncludeSelf(concept.isIncludeSelf());
        ec.setUseTerminalsIfAvailable(concept.isUseTerminalsIfAvailable());
        this.relatedConceptService.saveRelatedConcept((RelatedConcept)ec, mappingId, auth);
        return new ModelActionPojo(true);
    }

    @GetMapping(value={"/form/editFunction"})
    public String getEditFunctionForm(@PathVariable String mappingId, @PathVariable String mappedConceptId, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        PersistedSession s = this.sessionService.get(mappingId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        this.setupEditModel(mappingId, mappedConceptId, s, response, model, locale);
        return "conceptEditor/form/edit_function_concept";
    }

    @PostMapping(value={"/async/exportSample"})
    @ResponseBody
    public ModelActionPojo exportSampleInput(@PathVariable String mappingId, @PathVariable String mappedConceptId, @RequestBody JsonNode jsonNode, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        PersistedSession s = this.sessionService.get(mappingId, request.getSession().getId(), this.authInfoHelper.getUserId());
        ExportedConcept ec = (ExportedConcept)this.relatedConceptService.findById(mappedConceptId);
        if (!ec.getEntityId().equals(mappingId)) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        boolean includeTree = jsonNode.path("includeTree").asBoolean();
        boolean includeSelf = jsonNode.path("includeSelf").asBoolean();
        boolean escape = jsonNode.path("escape").asBoolean();
        boolean useTerminalsIfAvailable = jsonNode.path("useTerminalsIfAvailable").asBoolean();
        List res = this.getSampleExportResources(s, ec, includeTree, includeSelf);
        if (res == null) {
            return new ModelActionPojo(false);
        }
        JsonStringOutputService jos = this.setupOutputService(mappingId, escape, useTerminalsIfAvailable);
        if (jos == null) {
            return new ModelActionPojo(false);
        }
        try {
            Resource[] resourceArray;
            if (res.size() == 1) {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = (Resource)res.get(0);
            } else {
                resourceArray = res.toArray(new Resource[0]);
            }
            String conv = jos.writeToString(resourceArray);
            return this.renderExportResult(ec, conv);
        }
        catch (ProcessingConfigException e) {
            log.error("Exception when trying to convert resources to JSON", (Throwable)e);
            return new ModelActionPojo(false);
        }
    }

    private RelatedConcept setupEditModel(String mappingId, String mappedConceptId, PersistedSession s, HttpServletResponse response, Model model, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        model.addAttribute("readonly", (Object)(!this.schemaService.getUserCanWriteEntity(mappingId, auth.getUserId()) ? 1 : 0));
        RelatedConcept mc = this.relatedConceptService.findById(mappingId, mappedConceptId, true);
        LinkedHashMap<Element, String> sampleInputs = new LinkedHashMap<Element, String>();
        ArrayList inputElementIds = new ArrayList();
        inputElementIds.addAll(mc.getElementGrammarIdsMap().keySet());
        for (Element e : this.elementService.findByIds(inputElementIds)) {
            sampleInputs.put(e, this.sessionService.getSampleInputValue(s, e.getId()));
        }
        model.addAttribute("sampleInputMap", sampleInputs);
        model.addAttribute("concept", (Object)mc);
        return mc;
    }

    private void addExportSampleToModel(PersistedSession s, RelatedConcept rc, Model model) {
        List res = null;
        for (String inputElementId : rc.getElementGrammarIdsMap().keySet()) {
            res = this.sessionService.getSelectedResources(s, inputElementId);
        }
        if (res != null && !res.isEmpty()) {
            JsonNode pojo = ResourcePojoConverter.convertResource((Resource)((Resource)res.get(0)));
            model.addAttribute("sampleAvailable", (Object)true);
            if (pojo.toString().getBytes().length > this.debugConfig.getSamplesMaxTravelSize()) {
                model.addAttribute("sampleOversize", (Object)true);
            } else {
                model.addAttribute("sampleOversize", (Object)false);
                model.addAttribute("sample", (Object)pojo.toString());
            }
        } else {
            model.addAttribute("sampleAvailable", (Object)false);
        }
    }

    private List<? extends Resource> getSampleExportResources(PersistedSession s, ExportedConcept ec, boolean includeTree, boolean includeSelf) {
        List res = null;
        for (String inputElementId : ec.getElementGrammarIdsMap().keySet()) {
            res = this.sessionService.getSelectedResources(s, inputElementId);
            if (!includeSelf) {
                res.stream().forEach(r -> r.setExploded(true));
            }
            if (includeTree) continue;
            res.stream().forEach(r -> r.setChildResources(null));
        }
        return res;
    }

    private JsonStringOutputService setupOutputService(String mappingId, boolean escape, boolean useTerminals) {
        JsonStringOutputService jos = (JsonStringOutputService)this.appContext.getBean(JsonStringOutputService.class);
        String schemaId = this.mappingService.findMappingById(mappingId).getSourceId();
        jos.setSchema(this.schemaService.findSchemaById(schemaId));
        jos.setRoot(this.elementService.findRootBySchemaId(schemaId, true));
        jos.setEscape(escape);
        jos.setUseTerminals(useTerminals);
        try {
            jos.init();
        }
        catch (ProcessingConfigException e) {
            log.error("Failed to initialize OutputService", (Throwable)e);
            return null;
        }
        return jos;
    }

    private ModelActionPojo renderExportResult(ExportedConcept ec, String convertedResourcesAsString) {
        List targetElements = this.elementService.findByIds(ec.getTargetElementIds());
        ModelActionPojo result = new ModelActionPojo(true);
        ArrayList<TreeElementPojo> resultPojos = new ArrayList<TreeElementPojo>();
        for (String targetId : ec.getTargetElementIds()) {
            String label = targetElements.stream().filter(e -> e.getId().equals(targetId)).findFirst().orElse((Element)new NonterminalImpl(targetId, "?")).getName();
            resultPojos.add(new TreeElementPojo(targetId, label, (Object)convertedResourcesAsString, null));
        }
        result.setPojo(resultPojos);
        return result;
    }
}

