/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseFunctionController;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.grammar.AuxiliaryFile;
import de.unibamberg.minf.dme.model.grammar.GrammarContainer;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.gtf.MainEngine;
import de.unibamberg.minf.gtf.compilation.GrammarCompilationResult;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model/editor/{entityId}/grammar/{grammarId}", "/mapping/editor/{entityId}/grammar/{grammarId}"})
public class GrammarEditorController
extends BaseFunctionController {
    @Autowired
    private GrammarService grammarService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private MainEngine mainEngine;

    public GrammarEditorController() {
        super("schemaEditor");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/disable"})
    @ResponseBody
    public ModelActionPojo disableElement(@PathVariable String entityId, @PathVariable String grammarId, @RequestParam boolean disabled, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        GrammarImpl g = (GrammarImpl)this.grammarService.findById(grammarId);
        g.setDisabled(disabled);
        this.grammarService.saveGrammar(g, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/remove"})
    @ResponseBody
    public Grammar removeElement(@PathVariable String entityId, @PathVariable String grammarId, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        return this.grammarService.deleteGrammarById(entityId, grammarId, this.authInfoHelper.getAuth());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/new_function"})
    public String getNewGrammarForm(@PathVariable String entityId, @PathVariable String grammarId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("function", (Object)new FunctionImpl(entityId, null));
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/grammar/" + grammarId + "/async/saveNewFunction"));
        return "functionEditor/form/new";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveNewFunction"})
    @ResponseBody
    public ModelActionPojo saveNewGrammar(@PathVariable String entityId, @PathVariable String grammarId, @Valid FunctionImpl function, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            this.functionService.createAndAppendFunction(entityId, grammarId, function.getName(), this.authInfoHelper.getAuth());
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"/includes/inclAuxFileTab"})
    public String getInclAuxFileTab(Model model, Locale locale, @RequestParam Integer index) {
        AuxiliaryFile f = new AuxiliaryFile();
        f.setFileName(this.messageSource.getMessage("~de.unibamberg.minf.dme.editor.grammar.aux_file.new_file", null, locale));
        model.addAttribute("currIndex", (Object)index);
        model.addAttribute("currFile", (Object)f);
        return "grammarEditor/incl/auxfile_tab";
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"/includes/inclAuxFilePane"})
    public String getInclAuxFilePane(Model model, @RequestParam Integer index) {
        GrammarContainer gc = new GrammarContainer();
        AuxiliaryFile f = new AuxiliaryFile();
        model.addAttribute("currIndex", (Object)index);
        model.addAttribute("currFile", (Object)f);
        model.addAttribute("grammarContainer", (Object)gc);
        model.addAttribute("grammarContainer.auxiliaryFiles[" + index + "]", (Object)f);
        model.addAttribute("auxiliaryFileTypes", (Object)AuxiliaryFile.FileTypes.values());
        return "grammarEditor/incl/auxfile_pane";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/get"})
    @ResponseBody
    public Grammar getElement(@PathVariable String entityId, @PathVariable String grammarId) {
        return this.grammarService.findById(grammarId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/form/editWdata"})
    public String getEditFormWithData(@PathVariable String entityId, @PathVariable String grammarId, @RequestParam String sample, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        Identifiable entity = this.getEntity(entityId);
        PersistedSession s = this.sessionService.get(entityId, auth.getSessionId(), auth.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        GrammarImpl g = grammarId.equals("undefined") ? new GrammarImpl(entityId, "") : (GrammarImpl)this.grammarService.findById(grammarId);
        if (g.getGrammarContainer() == null) {
            g.setGrammarContainer(new GrammarContainer());
        }
        if (sample == null) {
            model.addAttribute("elementSample", (Object)this.getSampleInputValue(entity, grammarId, request.getSession().getId(), auth.getUserId(), response));
        } else {
            model.addAttribute("elementSample", (Object)sample);
        }
        model.addAttribute("grammar", (Object)g);
        model.addAttribute("auxiliaryFileTypes", (Object)AuxiliaryFile.FileTypes.values());
        model.addAttribute("readonly", (Object)this.getIsReadOnly(entity, auth.getUserId()));
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/grammar/" + grammarId + "/async/save"));
        return "grammarEditor/form/edit";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/form/edit"})
    public String getEditForm(@PathVariable String entityId, @PathVariable String grammarId, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        return this.getEditFormWithData(entityId, grammarId, null, request, response, model, locale);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/save"})
    @ResponseBody
    public ModelActionPojo saveGrammar(@PathVariable String entityId, @Valid GrammarImpl grammar, BindingResult bindingResult, @RequestParam(value="lexer-parser-options", defaultValue="combined") String lexerParserOption, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (!result.isSuccess()) {
            return result;
        }
        if (grammar.getId().isEmpty()) {
            grammar.setId(null);
        }
        GrammarImpl gSave = null;
        if (grammar.getId() != null && (gSave = (GrammarImpl)this.grammarService.findById(grammar.getId())) != null) {
            gSave.setBaseMethod(grammar.getBaseMethod());
            gSave.setError(grammar.isError());
            gSave.setName(grammar.getName());
            gSave.setPassthrough(grammar.isPassthrough());
            gSave.setEntityId(grammar.getEntityId());
            gSave.setTemporary(grammar.isTemporary());
            gSave.setGrammarContainer(grammar.getGrammarContainer());
        }
        if (gSave == null) {
            gSave = grammar;
        }
        Grammar gTmp = this.getTemporaryGrammar(gSave.getId(), auth.getUserId());
        this.grammarService.clearGrammar(gTmp);
        this.grammarService.clearGrammar((Grammar)gSave);
        this.grammarService.saveGrammar(gSave, auth);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/processGrammarDialog"})
    public String getProcessGrammarDialog(@PathVariable String grammarId, Model model, Locale locale) {
        GrammarImpl g = (GrammarImpl)this.grammarService.findById(grammarId);
        if (g.getGrammarContainer() == null) {
            g.setGrammarContainer(new GrammarContainer());
        }
        model.addAttribute("grammar", (Object)g);
        return "grammarEditor/form/process";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/help/editGrammar"})
    public String showHelpEditGrammar(Model model, Locale locale) {
        return "schemaEditor/help/grammar/editGrammar";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/upload"})
    @ResponseBody
    public ModelActionPojo uploadGrammar(@PathVariable String grammarId, @RequestParam boolean combined, @RequestBody GrammarContainer gc, HttpServletRequest request, Locale locale) {
        ModelActionPojo result = new ModelActionPojo(false);
        if (gc.getParserGrammar() == null || gc.getParserGrammar().trim().isEmpty()) {
            result.addFieldError("grammarContainer_parserGrammar", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.grammar.validation.parser_grammar_empty", null, locale));
        }
        if (!combined && (gc.getLexerGrammar() == null || gc.getLexerGrammar().trim().isEmpty())) {
            result.addFieldError("grammarContainer_lexerGrammar", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.grammar.validation.lexer_grammar_empty", null, locale));
        }
        if (result.getErrorCount() == 0) {
            try {
                Grammar g = this.getTemporaryGrammar(grammarId, this.authInfoHelper.getUserId());
                this.grammarService.clearGrammar(g);
                GrammarCompilationResult parseResult = this.grammarService.saveTemporaryGrammar(g, gc);
                result.setPojo((Object)parseResult.getResultingFiles());
                result.setSuccess(true);
            }
            catch (IOException e) {
                result.addObjectError("Failed to upload grammar: " + e.getClass().getName());
            }
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/parse"})
    @ResponseBody
    public ModelActionPojo parseGrammar(@PathVariable String grammarId, HttpServletRequest request) {
        ModelActionPojo result = new ModelActionPojo(false);
        Grammar g = null;
        try {
            g = this.getTemporaryGrammar(grammarId, this.authInfoHelper.getUserId());
            GrammarCompilationResult parseResult = this.grammarService.parseTemporaryGrammar(g);
            result.setPojo((Object)parseResult.getResultingFiles());
            result.setSuccess(true);
            for (String m : parseResult.getErrors()) {
                result.setSuccess(false);
                result.addFieldError("error", m);
            }
            for (String m : parseResult.getWarnings()) {
                result.addFieldError("warning", m);
            }
            for (String m : parseResult.getInfos()) {
                result.addFieldError("info", m);
            }
        }
        catch (Exception e) {
            result.addObjectError("Unspecified error while parsing grammar: " + e.getClass().getName());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/compile"})
    @ResponseBody
    public ModelActionPojo validateGrammar(@PathVariable String grammarId, HttpServletRequest request) {
        ModelActionPojo result = new ModelActionPojo(false);
        Grammar g = null;
        try {
            g = this.getTemporaryGrammar(grammarId, this.authInfoHelper.getUserId());
            GrammarCompilationResult parseResult = this.grammarService.compileTemporaryGrammar(g);
            result.setPojo((Object)parseResult.getResultingFiles());
            result.setSuccess(true);
            for (String m : parseResult.getErrors()) {
                result.setSuccess(false);
                result.addFieldError("error", m);
            }
            for (String m : parseResult.getWarnings()) {
                result.addFieldError("warning", m);
            }
            for (String m : parseResult.getInfos()) {
                result.addFieldError("info", m);
            }
        }
        catch (Exception e) {
            result.addObjectError("Unspecified error while compiling grammar: " + e.getClass().getName());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/sandbox"})
    @ResponseBody
    public ModelActionPojo sandboxGrammar(@PathVariable String grammarId, @RequestParam String baseMethod, HttpServletRequest request, Locale locale) {
        ModelActionPojo result = new ModelActionPojo(false);
        try {
            if (baseMethod == null || baseMethod.trim().isEmpty()) {
                result.setSuccess(true);
            } else {
                Grammar g = this.getTemporaryGrammar(grammarId, this.authInfoHelper.getUserId());
                List parserRules = this.grammarService.getParserRules(g);
                if (parserRules.contains(baseMethod.trim())) {
                    result.setSuccess(true);
                } else {
                    result.addFieldError("base_method", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.grammar.validation.base_rule_not_found", null, locale));
                }
            }
        }
        catch (Exception e) {
            result.addObjectError("Unspecified error while compiling grammar: " + e.getClass().getName());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/parseSample"})
    @ResponseBody
    public ModelActionPojo parseSampleInput(@PathVariable String grammarId, @RequestParam String initRule, @RequestParam String sample, @RequestParam(defaultValue="true") Boolean temporary, HttpServletRequest request, Locale locale) {
        ModelActionPojo result = new ModelActionPojo(false);
        try {
            Grammar g = Boolean.TRUE.equals(temporary) ? this.getTemporaryGrammar(grammarId, this.authInfoHelper.getUserId()) : this.grammarService.findById(grammarId);
            List parserRules = this.grammarService.getParserRules(g);
            if (initRule == null || initRule.trim().isEmpty()) {
                g.setBaseMethod((String)parserRules.get(0));
            } else {
                g.setBaseMethod(initRule);
                if (!parserRules.contains(initRule.trim())) {
                    result.addObjectError(this.messageSource.getMessage("~de.unibamberg.minf.dme.model.grammar.validation.base_rule_not_found", null, locale));
                    return result;
                }
            }
            if (this.mainEngine.getDescriptionEngine().checkAndLoadGrammar(g) != null) {
                result.setSuccess(true);
                result.setPojo((Object)this.mainEngine.getDescriptionEngine().processDescriptionGrammarToSVG(sample, g, new HashMap()));
            } else {
                result.addObjectWarning(this.messageSource.getMessage("~de.unibamberg.minf.dme.model.grammar.validation.no_grammar_found", null, locale));
            }
        }
        catch (Exception e) {
            this.logger.error("Transformation error", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/move"})
    @ResponseBody
    public ModelActionPojo parseSampleInput(@PathVariable String entityId, @PathVariable String grammarId, @RequestParam int delta, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        this.grammarService.moveReference(entityId, grammarId, GrammarImpl.class, delta, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    private Grammar getTemporaryGrammar(String id, String userId) {
        GrammarImpl g = new GrammarImpl();
        g.setTemporary(true);
        g.setId(id);
        g.setUserId(userId == null ? null : DigestUtils.md5Hex((String)userId));
        g.setName(g.getIdentifier());
        return g;
    }
}

