/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.confg.MainConfig;
import de.unibamberg.minf.dme.controller.base.BaseFunctionController;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.SessionExecutionContext;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.model.mapping.base.RelatedConcept;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.pojo.TreeElementPojo;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.ReferenceService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import de.unibamberg.minf.gtf.MainEngine;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.DataTransformationException;
import de.unibamberg.minf.gtf.exceptions.GrammarProcessingException;
import de.unibamberg.minf.gtf.model.ProcessingResult;
import de.unibamberg.minf.gtf.result.FunctionExecutionResult;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.TerminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.transformation.CompiledTransformationFunction;
import de.unibamberg.minf.gtf.transformation.CompiledTransformationFunctionImpl;
import de.unibamberg.minf.gtf.transformation.processing.ExecutionGroup;
import de.unibamberg.minf.gtf.transformation.processing.params.OutputParam;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model/editor/{entityId}/function/{functionId}", "/mapping/editor/{entityId}/function/{functionId}"})
public class FunctionEditorController
extends BaseFunctionController {
    @Autowired
    private ReferenceService referenceService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private GrammarService grammarService;
    @Autowired
    private ElementService elementService;
    @Autowired
    private RelatedConceptService relatedConceptService;
    @Autowired
    private MainEngine mainEngine;
    @Autowired
    private MainConfig mainConfig;

    public FunctionEditorController() {
        super("schemaEditor");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/remove"})
    @ResponseBody
    public Function removeElement(@PathVariable String entityId, @PathVariable String functionId, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        return this.functionService.deleteFunctionById(entityId, functionId, this.authInfoHelper.getAuth());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/disable"})
    @ResponseBody
    public ModelActionPojo disableElement(@PathVariable String entityId, @PathVariable String functionId, @RequestParam boolean disabled, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        FunctionImpl f = (FunctionImpl)this.functionService.findById(functionId);
        f.setDisabled(disabled);
        this.functionService.saveFunction(f, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/get"})
    @ResponseBody
    public Function getElement(@PathVariable String entityId, @PathVariable String functionId) {
        return this.functionService.findById(functionId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/form/editWdata"})
    public String getEditFormWithData(@PathVariable String entityId, @PathVariable String functionId, @RequestBody JsonNode jsonNode, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        Identifiable entity = this.getEntity(entityId);
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        HashMap<String, String> providedSamples = new HashMap<String, String>();
        if (jsonNode != null) {
            ArrayNode samples = (ArrayNode)jsonNode.path("samples");
            for (JsonNode n : samples) {
                String text = n.path("text").textValue();
                if (text == null) continue;
                providedSamples.put(n.path("elementId").textValue(), text);
            }
        }
        LinkedHashMap<Object, String> sampleInputs = new LinkedHashMap<Object, String>();
        ArrayList<String> inputElementIds = new ArrayList<String>();
        ArrayList<String> inputGrammarIds = new ArrayList<String>();
        if (Datamodel.class.isAssignableFrom(entity.getClass())) {
            String grammarId = this.referenceService.findReferenceByChildId(entityId, functionId).getReferenceId();
            model.addAttribute("grammar", (Object)this.grammarService.findById(grammarId));
            String elementId = this.referenceService.findReferenceByChildId(entityId, grammarId).getReferenceId();
            Element e = this.elementService.findById(elementId);
            inputGrammarIds.add(grammarId);
            if (providedSamples.containsKey(e.getId())) {
                sampleInputs.put(e, (String)providedSamples.get(e.getId()));
            } else {
                sampleInputs.put(e, this.sessionService.getSampleInputValue(s, elementId));
            }
        } else {
            Reference parentConceptReference = this.referenceService.findReferenceByChildId(entity.getId(), functionId);
            RelatedConcept c = this.relatedConceptService.findById(parentConceptReference.getReferenceId());
            for (String elementId : c.getElementGrammarIdsMap().keySet()) {
                inputElementIds.add(elementId);
                inputGrammarIds.add((String)c.getElementGrammarIdsMap().get(elementId));
            }
            for (Element e : this.elementService.findByIds(inputElementIds)) {
                if (providedSamples.containsKey(e.getId())) {
                    sampleInputs.put(e, (String)providedSamples.get(e.getId()));
                    continue;
                }
                sampleInputs.put(e, this.sessionService.getSampleInputValue(s, e.getId()));
            }
        }
        List grammars = this.grammarService.findByIds(inputGrammarIds);
        ArrayList<CallSite> availableRules = new ArrayList<CallSite>();
        ArrayList<CallSite> availablePassthroughGrammars = new ArrayList<CallSite>();
        for (Grammar g : grammars) {
            if (g.isPassthrough()) {
                availablePassthroughGrammars.add((CallSite)((Object)("@" + g.getName())));
                continue;
            }
            try {
                for (String rule : this.mainEngine.getDescriptionEngine().getParserRuleNames(g)) {
                    if (availableRules.contains("@" + rule)) continue;
                    availableRules.add((CallSite)((Object)("@" + rule)));
                }
            }
            catch (GrammarProcessingException e) {
                this.logger.error(String.format("Failed to retrieve parser rules for grammar %s", g.getIdentifier()), (Throwable)e);
            }
        }
        Collections.sort(availableRules);
        model.addAttribute("availableRules", availableRules);
        model.addAttribute("availablePassthroughGrammars", availablePassthroughGrammars);
        model.addAttribute("sampleInputMap", sampleInputs);
        model.addAttribute("function", (Object)this.functionService.findById(functionId));
        model.addAttribute("readonly", (Object)this.getIsReadOnly(entity, auth.getUserId()));
        model.addAttribute("actionPath", (Object)("/model/editor/" + entityId + "/function/" + functionId + "/async/save"));
        return "functionEditor/form/edit";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/form/edit"})
    public String getEditForm(@PathVariable String entityId, @PathVariable String functionId, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        return this.getEditFormWithData(entityId, functionId, null, request, response, model, locale);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/process"})
    public String validateFunction(Model model, Locale locale) {
        return "functionEditor/form/process";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/validate"})
    @ResponseBody
    public ModelActionPojo validateFunction(@PathVariable String entityId, @PathVariable String functionId, @RequestParam String func) {
        ModelActionPojo result = new ModelActionPojo();
        try {
            FunctionImpl f = new FunctionImpl(entityId, functionId);
            f.setFunction(func);
            CompiledTransformationFunction fCompiled = this.mainEngine.getTransformationEngine().compileOutputFunction((Function)f, true);
            if (!fCompiled.isEmpty()) {
                result.setPojo((Object)((CompiledTransformationFunctionImpl)fCompiled).getSvg());
                result.setObjectErrors((Collection)((CompiledTransformationFunctionImpl)fCompiled).getErrors());
            }
            result.setSuccess(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/save"})
    @ResponseBody
    public ModelActionPojo saveFunction(@PathVariable String entityId, @PathVariable String functionId, @Valid FunctionImpl function, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (!result.isSuccess()) {
            return result;
        }
        if (function.getId().isEmpty()) {
            function.setId(null);
        }
        FunctionImpl fSave = null;
        if (function.getId() != null && (fSave = this.functionService.findById(function.getId())) != null) {
            fSave.setError(function.isError());
            fSave.setFunction(function.getFunction());
            fSave.setName(function.getName());
            fSave.setEntityId(function.getEntityId());
        }
        if (fSave == null) {
            fSave = function;
        }
        if (!fSave.getFunction().trim().isEmpty()) {
            ModelActionPojo validationResult = this.validateFunction(entityId, functionId, fSave.getFunction());
            if (validationResult.isSuccess() && !validationResult.hasErrors()) {
                fSave.setError(false);
            } else {
                fSave.setError(true);
            }
        }
        this.functionService.saveFunction(fSave, this.authInfoHelper.getAuth());
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/parseSample"})
    @ResponseBody
    public ModelActionPojo parseSampleInput(@PathVariable String entityId, @PathVariable String functionId, @RequestBody JsonNode jsonNode, HttpServletRequest request, Locale locale) {
        FunctionImpl f;
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        HashMap<String, String> providedSamples = new HashMap<String, String>();
        String func = jsonNode.path("func").textValue();
        ArrayNode samples = (ArrayNode)jsonNode.path("samples");
        for (JsonNode n : samples) {
            String text = n.path("text").textValue();
            if (text == null || text.isEmpty()) continue;
            providedSamples.put(n.path("elementId").textValue(), text);
        }
        Identifiable entity = this.getEntity(entityId);
        ModelActionPojo result = new ModelActionPojo();
        ArrayList<TerminalSyntaxTreeNode> values = new ArrayList<TerminalSyntaxTreeNode>();
        ArrayList<Grammar> grammars = new ArrayList<Grammar>();
        if (Datamodel.class.isAssignableFrom(entity.getClass())) {
            String grammarId = this.referenceService.findReferenceBySchemaAndChildId(entityId, functionId).getReferenceId();
            Grammar g = this.grammarService.findById(grammarId);
            String elementId = this.referenceService.findReferenceByChildId(entityId, grammarId).getReferenceId();
            values.add(new TerminalSyntaxTreeNode(providedSamples.containsKey(elementId) ? (String)providedSamples.get(elementId) : null, null));
            grammars.add(g);
            f = (FunctionImpl)this.elementService.getElementSubtree(entityId, functionId);
        } else {
            Mapping m = (Mapping)entity;
            Datamodel target = this.schemaService.findSchemaById(m.getTargetId());
            Reference parentConceptReference = this.referenceService.findReferenceByChildId(entity.getId(), functionId);
            RelatedConcept rc = this.relatedConceptService.findById(parentConceptReference.getReferenceId());
            List targetElements = this.elementService.getElementTrees(target.getId(), rc.getTargetElementIds());
            for (String elementId : rc.getElementGrammarIdsMap().keySet()) {
                grammars.add(this.grammarService.findById((String)rc.getElementGrammarIdsMap().get(elementId)));
                values.add(new TerminalSyntaxTreeNode(providedSamples.containsKey(elementId) ? (String)providedSamples.get(elementId) : null, null));
            }
            f = (FunctionImpl)this.functionService.findById(functionId);
            ArrayList outputElements = new ArrayList();
            outputElements.addAll(this.elementService.convertToLabels(targetElements));
            f.setOutputElements(outputElements);
        }
        if (func != null) {
            f.setFunction(func);
        }
        try {
            FunctionExecutionResult pResult = null;
            ArrayList syntaxTrees = new ArrayList();
            ExecutionGroup execGroup = this.mainEngine.getTransformationEngine().buildExecutionGroup(grammars, (Function)f, (ExecutionContext)new SessionExecutionContext(this.mainConfig.getPaths().getSessionData(), s.getId(), this.sessionService.loadSessionData(s.getId())));
            ProcessingResult descResult = null;
            for (int i = 0; i < grammars.size(); ++i) {
                Grammar g = (Grammar)grammars.get(i);
                SyntaxTreeNode v = (SyntaxTreeNode)values.get(i);
                try {
                    this.mainEngine.getDescriptionEngine().checkAndLoadGrammar(g);
                    descResult = this.mainEngine.getDescriptionEngine().processGrammar(v, g, execGroup.getCombinedExpectedParams());
                    syntaxTrees.addAll(descResult.getResult());
                    continue;
                }
                catch (GrammarProcessingException e) {
                    this.logger.error(String.format("Failed to check and load grammar %s", g.getIdentifier()));
                }
            }
            try {
                List lstResult = this.mainEngine.getTransformationEngine().processTransformations(syntaxTrees, execGroup);
                if (descResult != null && lstResult != null && lstResult.size() > 0) {
                    pResult = (FunctionExecutionResult)lstResult.get(0);
                }
            }
            catch (DataTransformationException e) {
                this.logger.error(String.format("Failed to execute transformation functions", new Object[0]), (Throwable)e);
            }
            result.setSuccess(true);
            boolean allMatched = true;
            if (pResult != null) {
                if (pResult.getOutputParams() != null && pResult.getOutputParams().size() > 0) {
                    ArrayList<TreeElementPojo> resultPojos = new ArrayList<TreeElementPojo>();
                    MutableBoolean pMatch = new MutableBoolean(true);
                    for (OutputParam p : pResult.getOutputParams()) {
                        resultPojos.add(this.convertOutputParamToPojo(p, f.getOutputElements(), pMatch));
                        allMatched = allMatched && pMatch.booleanValue();
                    }
                    result.setPojo(resultPojos);
                    if (!allMatched) {
                        result.addObjectWarning(this.messageSource.getMessage("~de.unibamberg.minf.dme.model.function.validation.labels_not_found", null, locale));
                    }
                }
                if (pResult.getErrors() != null) {
                    for (Exception ex : pResult.getErrors()) {
                        result.addObjectError(ex.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error performing sample transformation", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/move"})
    @ResponseBody
    public ModelActionPojo parseSampleInput(@PathVariable String entityId, @PathVariable String functionId, @RequestParam int delta, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        this.functionService.moveReference(entityId, functionId, FunctionImpl.class, delta, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    private TreeElementPojo convertOutputParamToPojo(OutputParam param, List<? extends Element> outputElements, MutableBoolean allMatched) {
        if (param == null) {
            return null;
        }
        TreeElementPojo pojo = new TreeElementPojo();
        pojo.setLabel(param.getLabel());
        pojo.setValue(param.getValue() == null ? null : StringEscapeUtils.escapeHtml4((String)param.getValue().toString()));
        List sublabels = null;
        if (outputElements == null) {
            allMatched.setFalse();
        } else {
            boolean match = false;
            for (Element element : outputElements) {
                if (!element.getName().equals(param.getLabel())) continue;
                if (Label.class.isAssignableFrom(element.getClass())) {
                    sublabels = ((Label)element).getSubLabels();
                }
                match = true;
                break;
            }
            if (!match) {
                allMatched.setFalse();
            }
        }
        if (param.getChildParameters() != null) {
            pojo.setChildren(new ArrayList());
            for (OutputParam childParam : param.getChildParameters()) {
                pojo.getChildren().add(this.convertOutputParamToPojo(childParam, sublabels, allMatched));
            }
        }
        return pojo;
    }
}

