/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.editors;

import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Label;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.datamodel.LabelImpl;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.pojo.ModelElementPojo;
import de.unibamberg.minf.dme.pojo.converter.ModelElementPojoConverter;
import de.unibamberg.minf.dme.service.ElementServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.GrammarService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model/editor/{schemaId}/element/{elementId}", "/mapping/editor/{schemaId}/element/{elementId}"})
public class ElementEditorController
extends BaseScheregController {
    @Autowired
    private ElementService elementService;
    @Autowired
    private GrammarService grammarService;
    @Autowired
    private RelatedConceptService relatedConceptService;

    public ElementEditorController() {
        super("schemaEditor");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/assignChild"})
    @ResponseBody
    public ModelActionPojo assignChild(@PathVariable String schemaId, @PathVariable String elementId, @RequestParam(value="element-id") String childId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        Reference parentReference = this.elementService.assignChildTreeToParent(schemaId, elementId, childId);
        if (parentReference != null) {
            return new ModelActionPojo(true);
        }
        return new ModelActionPojo(false);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/assignChild"})
    public String getAssignChildForm(@PathVariable String schemaId, @PathVariable String elementId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/assignChild"));
        return "elementEditor/form/assign_child";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/linkElement"})
    @ResponseBody
    public ModelActionPojo linkElement(@PathVariable String schemaId, @PathVariable String elementId, @RequestParam(value="element-id") String linkId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        Reference linkReference = this.elementService.replaceWithLink(schemaId, elementId, linkId);
        if (linkReference != null) {
            return new ModelActionPojo(true);
        }
        return new ModelActionPojo(false);
    }

    @PreAuthorize(value="isAuthenticated()")
    @GetMapping(value={"/form/linkElement"})
    public String getLinkElementForm(@PathVariable String schemaId, @PathVariable String elementId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/linkElement"));
        return "elementEditor/form/link_element";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/form/element"})
    public String getEditElementForm(@PathVariable String schemaId, @PathVariable String elementId, Model model, Locale locale, HttpServletRequest request) {
        Element elem = this.elementService.findById(elementId);
        model.addAttribute("element", (Object)elem);
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            model.addAttribute("readonly", (Object)true);
        } else {
            model.addAttribute("readonly", (Object)false);
        }
        if (elem instanceof Nonterminal) {
            model.addAttribute("availableTerminals", (Object)this.schemaService.getAvailableTerminals(schemaId));
            model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/async/saveNonterminal"));
            return "elementEditor/form/edit_nonterminal";
        }
        model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/async/saveLabel"));
        return "elementEditor/form/edit_label";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/new_nonterminal"})
    public String getNewNonterminalForm(@PathVariable String schemaId, @PathVariable String elementId, HttpServletRequest request, HttpServletResponse response, Model model, Locale locale) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("element", (Object)new NonterminalImpl(schemaId, null));
        model.addAttribute("availableTerminals", (Object)this.schemaService.getAvailableTerminals(schemaId));
        model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/async/saveNewNonterminal"));
        return "elementEditor/form/edit_nonterminal";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/new_label"})
    public String getNewLabelForm(@PathVariable String schemaId, @PathVariable String elementId, Model model, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("element", (Object)new LabelImpl(schemaId, null));
        model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/async/saveNewLabel"));
        return "elementEditor/form/edit_label";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/form/new_grammar"})
    public String getNewGrammarForm(@PathVariable String schemaId, @PathVariable String elementId, Model model, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        model.addAttribute("grammar", (Object)new GrammarImpl(schemaId, null));
        model.addAttribute("actionPath", (Object)("/model/editor/" + schemaId + "/element/" + elementId + "/async/saveNewGrammar"));
        return "grammarEditor/form/new";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveLabel"})
    @ResponseBody
    public ModelActionPojo saveLabel(@PathVariable String schemaId, @Valid LabelImpl element, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            this.mergeAndSaveElement(this.elementService.findById(element.getId()), (Element)element, schemaId, auth);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveNonterminal"})
    @ResponseBody
    public ModelActionPojo saveNonterminal(@PathVariable String schemaId, @Valid NonterminalImpl element, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(schemaId, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            Nonterminal n = (Nonterminal)this.elementService.findById(element.getId());
            n.setAssignComplexContent(element.isAssignComplexContent());
            this.mergeAndSaveElement((Element)n, (Element)element, schemaId, auth);
        }
        return result;
    }

    private void mergeAndSaveElement(Element saveElement, Element mergeElement, String entityId, AuthPojo auth) {
        saveElement.setTransient(mergeElement.isTransient());
        saveElement.setIdentifierElement(mergeElement.isIdentifierElement());
        saveElement.setName(ElementServiceImpl.getNormalizedName((String)mergeElement.getName()));
        saveElement.setEntityId(entityId);
        saveElement.setIncludeHeader(mergeElement.isIncludeHeader());
        saveElement.setHierarchicalRoot(mergeElement.isHierarchicalRoot());
        saveElement.setSessionVariable(mergeElement.getSessionVariable() == null || mergeElement.getSessionVariable().isBlank() ? null : mergeElement.getSessionVariable());
        if (saveElement.isProcessingRoot() != mergeElement.isProcessingRoot()) {
            Element e;
            this.elementService.unsetSchemaProcessingRoot(entityId);
            saveElement.setProcessingRoot(mergeElement.isProcessingRoot());
            if (!saveElement.isProcessingRoot() && Nonterminal.class.isAssignableFrom((e = this.elementService.findRootBySchemaId(entityId)).getClass())) {
                Nonterminal root = (Nonterminal)e;
                root.setProcessingRoot(true);
                this.elementService.saveElement((Element)root, auth);
            }
        }
        this.elementService.saveElement(saveElement, auth);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveNewLabel"})
    @ResponseBody
    public ModelActionPojo saveNewLabel(@PathVariable String schemaId, @PathVariable String elementId, @Valid LabelImpl element, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) throws GenericScheregException {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            this.elementService.createAndAppendElement(schemaId, elementId, element.getName(), this.authInfoHelper.getAuth(), Label.class);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveNewNonterminal"})
    @ResponseBody
    public ModelActionPojo saveNewNonterminal(@PathVariable String schemaId, @PathVariable String elementId, @Valid NonterminalImpl element, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) throws GenericScheregException {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            element.setEntityId(schemaId);
            this.elementService.createAndAppendElement(schemaId, elementId, element.getName(), this.authInfoHelper.getAuth(), Nonterminal.class);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveNewGrammar"})
    @ResponseBody
    public ModelActionPojo saveNewGrammar(@PathVariable String schemaId, @PathVariable String elementId, @Valid GrammarImpl grammar, BindingResult bindingResult, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (result.isSuccess()) {
            this.grammarService.createAndAppendGrammar(schemaId, elementId, grammar.getName(), this.authInfoHelper.getAuth());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/get"})
    @ResponseBody
    public ModelElementPojo getElement(@PathVariable String schemaId, @PathVariable String elementId, HttpServletRequest request, HttpServletResponse response) throws IOException, GenericScheregException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        Element result = this.elementService.findById(elementId);
        if (result == null) {
            response.getWriter().print("null");
            response.setContentType("application/json");
        }
        HashMap<String, ArrayList<String>> nonterminalNatureClassesMap = new HashMap<String, ArrayList<String>>();
        Datamodel m = (Datamodel)this.schemaService.findByIdAndAuth(schemaId, auth).getElement();
        if (m.getNatures() != null) {
            for (DatamodelNature n : m.getNatures()) {
                if (n.getNonterminalTerminalIdMap() == null) continue;
                for (String nId : n.getNonterminalTerminalIdMap().keySet()) {
                    ArrayList<String> natureClasses = (ArrayList<String>)nonterminalNatureClassesMap.get(nId);
                    if (natureClasses == null) {
                        natureClasses = new ArrayList<String>();
                    }
                    natureClasses.add(n.getClass().getName());
                    nonterminalNatureClassesMap.put(nId, natureClasses);
                }
            }
        }
        return ModelElementPojoConverter.convertModelElement((Element)result, nonterminalNatureClassesMap, (boolean)false, (boolean)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/remove"})
    @ResponseBody
    public ModelActionPojo removeElement(@PathVariable String schemaId, @PathVariable String elementId, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        this.relatedConceptService.removeElementReferences(schemaId, elementId);
        this.elementService.removeElement(schemaId, elementId, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/disable"})
    @ResponseBody
    public ModelActionPojo disableElement(@PathVariable String schemaId, @PathVariable String elementId, @RequestParam boolean disabled, HttpServletRequest request, HttpServletResponse response) {
        if (!this.schemaService.getUserCanWriteEntity(schemaId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        Element e = this.elementService.findById(elementId);
        e.setDisabled(disabled);
        this.elementService.saveElement(e, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/clone"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public ModelActionPojo cloneElement(@PathVariable String schemaId, @PathVariable String elementId, @RequestParam(value="path[]") String[] path, HttpServletRequest request, HttpServletResponse response) throws GenericScheregException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        this.elementService.cloneElement(elementId, path, auth);
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/move"})
    @ResponseBody
    public ModelActionPojo parseSampleInput(@PathVariable String schemaId, @PathVariable String elementId, @RequestParam int delta, HttpServletRequest request, HttpServletResponse response) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(schemaId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        Class elementType = NonterminalImpl.class.isAssignableFrom(this.elementService.findById(elementId).getClass()) ? NonterminalImpl.class : LabelImpl.class;
        this.elementService.moveReference(schemaId, elementId, elementType, delta, this.authInfoHelper.getAuth());
        return new ModelActionPojo(true);
    }
}

