/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.base;

import de.unibamberg.minf.core.web.controller.BaseTranslationController;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.pojo.ChangeSetPojo;
import de.unibamberg.minf.dme.pojo.converter.ChangeSetPojoConverter;
import de.unibamberg.minf.dme.service.interfaces.MappingService;
import de.unibamberg.minf.dme.service.interfaces.SchemaService;
import eu.dariah.de.dariahsp.web.AuthInfoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class BaseScheregController
extends BaseTranslationController {
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Autowired
    protected SchemaService schemaService;
    @Autowired
    protected MappingService mappingService;
    @Autowired
    private ChangeSetPojoConverter changeSetPojoConverter;

    protected BaseScheregController(String mainNavId) {
        super(mainNavId);
    }

    @GetMapping(value={"/async/getChangesForElement/{id}"})
    @ResponseBody
    public Collection<ChangeSetPojo> getChangesForElement(@PathVariable String id, Model model, Locale locale) {
        return this.changeSetPojoConverter.convert(this.schemaService.getChangeSetForElement(id), locale);
    }

    @GetMapping(value={"/async/getChangesForEntity/{id}"})
    @ResponseBody
    public Collection<ChangeSetPojo> getChangesForEntity(@PathVariable String id, Model model, Locale locale) {
        ArrayList entityChanges = new ArrayList();
        entityChanges.addAll(this.schemaService.getChangeSetForEntity(id));
        entityChanges.addAll(this.schemaService.getChangeSetForElement(id));
        return this.changeSetPojoConverter.convert(entityChanges, locale);
    }

    @GetMapping(value={"/async/getChanges"})
    @ResponseBody
    public Collection<ChangeSetPojo> getChanges(Model model, Locale locale) {
        return this.changeSetPojoConverter.convert(this.schemaService.getChangeSetForAllSchemas(), locale);
    }

    protected Identifiable getEntity(String entityId) {
        Mapping entity = this.mappingService.findMappingById(entityId);
        if (entity == null) {
            entity = this.schemaService.findSchemaById(entityId);
        }
        return entity;
    }

    protected String getLimitedString(String string, int limit) {
        if (string == null || string.trim().length() < limit) {
            return string;
        }
        return string.substring(0, limit - 3) + "...";
    }
}

