/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.base;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.core.util.Stopwatch;
import de.unibamberg.minf.core.web.pojo.MessagePojo;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.confg.DebugConfig;
import de.unibamberg.minf.dme.confg.MainConfig;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.exception.SchemaImportException;
import de.unibamberg.minf.dme.importer.BaseImportWorker;
import de.unibamberg.minf.dme.importer.Importer;
import de.unibamberg.minf.dme.model.LogEntry;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.SessionExecutionContext;
import de.unibamberg.minf.dme.model.SessionSampleFile;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.pojo.converter.ResourcePojoConverter;
import de.unibamberg.minf.dme.service.PersistedSessionServiceImpl;
import de.unibamberg.minf.dme.service.base.BaseEntityService;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.MappingService;
import de.unibamberg.minf.dme.service.interfaces.PersistedSessionService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.processing.consumption.CollectingResourceConsumptionServiceImpl;
import de.unibamberg.minf.processing.consumption.ResourceConsumptionService;
import de.unibamberg.minf.processing.exception.ProcessingConfigException;
import de.unibamberg.minf.processing.model.base.Resource;
import de.unibamberg.minf.processing.output.FileOutputService;
import de.unibamberg.minf.processing.output.json.JsonFileOutputService;
import de.unibamberg.minf.processing.output.xml.XmlFileOutputService;
import de.unibamberg.minf.processing.service.base.BaseResourceProcessingServiceImpl;
import de.unibamberg.minf.processing.service.json.JsonProcessingService;
import de.unibamberg.minf.processing.service.json.YamlProcessingService;
import de.unibamberg.minf.processing.service.tabular.CsvProcessingService;
import de.unibamberg.minf.processing.service.tabular.TsvProcessingService;
import de.unibamberg.minf.processing.service.text.TextProcessingService;
import de.unibamberg.minf.processing.service.xml.XmlProcessingService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseMainEditorController
extends BaseScheregController {
    protected static Map<String, String> temporaryFilesMap = new HashMap();
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected MappingService mappingService;
    @Autowired
    protected RelatedConceptService relatedConceptService;
    @Autowired
    protected PersistedSessionService sessionService;
    @Autowired
    protected ElementService elementService;
    @Autowired
    protected MainConfig mainConfig;
    @Autowired
    protected DebugConfig debugConfig;

    public BaseMainEditorController(String mainNavId) {
        super(mainNavId);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/state"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo getEntityState(@PathVariable String entityId, HttpServletRequest request) {
        if (entityId == null || entityId.isEmpty()) {
            return new ModelActionPojo(false);
        }
        boolean processing = this.getImportWorker().isBeingProcessed(entityId);
        ModelActionPojo result = new ModelActionPojo(true);
        ObjectNode jsonState = this.objectMapper.createObjectNode();
        jsonState.put("processing", processing);
        jsonState.put("ready", !processing);
        jsonState.put("error", false);
        result.setPojo((Object)jsonState);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/activity"})
    public String getActivityIncl(@PathVariable String entityId, Model model, HttpServletRequest request) {
        return "schemaEditor/incl/activity";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/sample"})
    public String getSampleIncl(@PathVariable String entityId, Model model, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        boolean oversized = false;
        try {
            PersistedSession s = this.sessionService.accessOrCreate(entityId, request.getSession().getId(), auth.getUserId());
            model.addAttribute("session", (Object)s);
            model.addAttribute("sampleOutput", (Object)this.sessionService.loadSampleOutput(s.getId()));
            oversized = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to load/initialize persisted session", (Throwable)e);
        }
        model.addAttribute("sampleInputOversize", (Object)oversized);
        return "editor/incl/sample";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/output"})
    public String getOutputIncl(@PathVariable String entityId, Model model, HttpServletRequest request) {
        return this.getResultIncl(entityId, "output", model, request);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/incl/mapped"})
    public String getMappedIncl(@PathVariable String entityId, Model model, HttpServletRequest request) {
        return this.getResultIncl(entityId, "mapped", model, request);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/forms/fileupload"})
    public String getImportForm(Model model, Locale locale) {
        return "common/fileupload";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/upload", "/async/upload/{elementId}"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public JsonNode uploadFile(@PathVariable String entityId, @PathVariable(required=false) String elementId, MultipartHttpServletRequest request, Model model, Locale locale, HttpServletResponse response) throws IOException {
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.getMainEntityService().getUserCanWriteEntity(entityId, auth.getUserId())) {
            response.setStatus(403);
            return null;
        }
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("success", true);
        result.set("files", this.uploadFile(request, "validate/%s" + (String)(elementId != null ? "/" + elementId : "")));
        return result;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/uploadSample"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public JsonNode uploadSample(@PathVariable String entityId, MultipartHttpServletRequest request, Model model, Locale locale, HttpServletResponse response) throws IOException {
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("success", true);
        result.set("files", this.uploadFile(request, null));
        return result;
    }

    private String getResultIncl(String entityId, String resultType, Model model, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        try {
            PersistedSession s = this.sessionService.accessOrCreate(entityId, request.getSession().getId(), auth.getUserId());
            model.addAttribute("session", (Object)s);
        }
        catch (Exception e) {
            this.logger.error("Failed to load/initialize persisted session", (Throwable)e);
        }
        model.addAttribute("resultType", (Object)resultType);
        return "editor/incl/output";
    }

    private JsonNode uploadFile(MultipartHttpServletRequest request, String validationUrl) throws IOException {
        List fileList;
        MultiValueMap multipartMap = request.getMultiFileMap();
        MultipartFile file = null;
        if (multipartMap != null && multipartMap.size() > 0 && multipartMap.containsKey((Object)"file") && (fileList = (List)multipartMap.get((Object)"file")).size() == 1 && fileList.get(0) != null && (file = (MultipartFile)fileList.get(0)).getSize() == 0L) {
            file = null;
        }
        String tmpId = UUID.randomUUID().toString();
        String tmpFilePath = String.format("%s/%s_%s", this.mainConfig.getPaths().getTmpUpload(), tmpId, file.getOriginalFilename());
        Files.write(Paths.get(tmpFilePath, new String[0]), file.getBytes(), new OpenOption[0]);
        temporaryFilesMap.put(tmpId, tmpFilePath);
        ArrayNode filesNode = this.objectMapper.createArrayNode();
        ObjectNode fileNode = this.objectMapper.createObjectNode();
        fileNode.put("id", tmpId);
        fileNode.put("fileName", file.getOriginalFilename());
        fileNode.put("fileSize", BaseMainEditorController.humanReadableByteCount((long)file.getBytes().length, (boolean)false));
        fileNode.put("deleteLink", "async/file/delete/" + tmpId);
        if (validationUrl != null) {
            fileNode.put("validateLink", String.format("async/file/%s/", String.format(validationUrl, tmpId)));
        }
        filesNode.add((JsonNode)fileNode);
        return filesNode;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/file/delete/{fileId}"})
    @ResponseBody
    public ModelActionPojo deleteImportedFile(@PathVariable String entityId, @PathVariable String fileId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.getMainEntityService().getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        if (temporaryFilesMap.containsKey(fileId)) {
            temporaryFilesMap.remove(fileId);
        }
        return new ModelActionPojo(true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/file/validate/{fileId}", "/async/file/validate/{fileId}/{elementId}"})
    @ResponseBody
    public ModelActionPojo validateImportedFile(@PathVariable String entityId, @PathVariable String fileId, @PathVariable(required=false) String elementId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) throws SchemaImportException {
        if (!this.schemaService.getUserCanWriteEntity(entityId, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        if (temporaryFilesMap.containsKey(fileId)) {
            return this.validateImportedFile(entityId, fileId, elementId, locale);
        }
        ModelActionPojo result = new ModelActionPojo(false);
        MessagePojo msg = new MessagePojo("danger", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationfailed.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationfailed.body", null, locale));
        result.setMessage(msg);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/forms/uploadSample"})
    public String getUploadSampleForm(@PathVariable String entityId, @RequestParam(defaultValue="XML") String inputType, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        model.addAttribute("actionPath", (Object)(this.getPrefix() + entityId + "/async/executeUploadedSample"));
        model.addAttribute("inputType", (Object)inputType);
        return "editor/form/upload_sample";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/executeUploadedSample"})
    @ResponseBody
    public ModelActionPojo executeUploadedSample(@PathVariable String entityId, @RequestParam(value="file.id") String fileId, @RequestParam(defaultValue="XML") String inputType, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) throws SchemaImportException, IOException {
        ModelActionPojo result = new ModelActionPojo();
        if (temporaryFilesMap.containsKey(fileId)) {
            PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
            if (s == null) {
                response.setStatus(205);
                return null;
            }
            SessionSampleFile file = this.sessionService.saveAsSessionInputFile(new File((String)temporaryFilesMap.get(fileId)), SessionSampleFile.FileTypes.valueOf((String)inputType), s.getId());
            if (file != null) {
                s.setSampleFile(file);
                this.sessionService.saveSession(s);
                result.setSuccess(true);
                MessagePojo msg = new MessagePojo("success", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationsucceeded.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationsucceeded.body", null, locale));
                result.setMessage(msg);
            }
            return result;
        }
        result.setSuccess(false);
        MessagePojo msg = new MessagePojo("danger", this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationfailed.head", null, locale), this.messageSource.getMessage("~de.unibamberg.minf.common.view.forms.file.validationfailed.body", null, locale));
        result.setMessage(msg);
        return result;
    }

    @GetMapping(value={"/forms/sampleData"})
    public String getSampleDataForm(@PathVariable String entityId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        model.addAttribute("actionPath", (Object)(this.getPrefix() + entityId + "/async/saveSampleData"));
        JsonNode data = this.sessionService.loadSessionData(s.getId());
        if (data != null && !data.isMissingNode()) {
            model.addAttribute("sessionData", (Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)data));
        }
        return "editor/form/sample_data";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveSampleData"})
    @ResponseBody
    public ModelActionPojo saveSampleData(@PathVariable String entityId, @RequestParam String sessionData, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        ModelActionPojo result = new ModelActionPojo();
        try {
            this.sessionService.saveSessionData(sessionData, s.getId());
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.addObjectError(this.messageSource.getMessage("~de.unibamberg.minf.dme.notification.session_data_not_json", new Object[]{e.getLocalizedMessage()}, locale));
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/load_sample"})
    @ResponseBody
    public String loadSample(@PathVariable String entityId, @RequestParam(name="t", defaultValue="input") String type, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) throws SchemaImportException, IOException {
        ModelActionPojo result = new ModelActionPojo();
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        if (type.equals("output")) {
            result.setPojo(this.objectMapper.convertValue((Object)this.sessionService.loadSampleOutput(s.getId()), JsonNode.class));
        } else if (!type.equals("transformed")) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)PersistedSessionServiceImpl.getSampleInputStream((PersistedSession)s), (Writer)writer, (Charset)Charsets.UTF_8);
            result.setPojo((Object)new TextNode(writer.toString()));
        }
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)result);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/forms/download_output"})
    public String getAssignChildForm(@PathVariable String entityId, Model model, HttpServletRequest request) throws GenericScheregException {
        Identifiable entity = this.getEntity(entityId);
        if (Datamodel.class.isAssignableFrom(entity.getClass())) {
            model.addAttribute("sourceModel", (Object)this.getLimitedString(((Datamodel)entity).getName(), 50));
        } else {
            Mapping m = (Mapping)entity;
            model.addAttribute("sourceModel", (Object)this.getLimitedString(this.schemaService.findSchemaById(m.getSourceId()).getName(), 50));
            model.addAttribute("targetModel", (Object)this.getLimitedString(this.schemaService.findSchemaById(m.getTargetId()).getName(), 50));
        }
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            throw new GenericScheregException("Session not available. Try to re-login.");
        }
        List sampleOutput = this.sessionService.loadSampleOutput(s.getId());
        if (sampleOutput != null && sampleOutput.size() > 0) {
            model.addAttribute("datasetCount", (Object)sampleOutput.size());
            model.addAttribute("datasetCurrent", (Object)s.getSelectedOutputIndex());
        } else {
            model.addAttribute("datasetCount", (Object)0);
        }
        return "editor/form/download_output";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/download_link"})
    @ResponseBody
    public String getDownloadLink(@PathVariable String entityId, @RequestParam(defaultValue="single") String data, @RequestParam(defaultValue="source") String model, @RequestParam(defaultValue="xml") String format, Locale locale, HttpServletRequest request, HttpServletResponse response) throws SchemaImportException, IOException, ProcessingConfigException {
        ModelActionPojo result = new ModelActionPojo();
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        FileOutputService fos = format.equals("json") ? (FileOutputService)this.appContext.getBean(JsonFileOutputService.class) : (FileOutputService)this.appContext.getBean(XmlFileOutputService.class);
        String schemaId = this.getModelId(entityId, model.equals("target"));
        fos.setSchema(this.schemaService.findSchemaById(schemaId));
        fos.setRoot(this.elementService.findRootBySchemaId(schemaId, true));
        String fileName = s.getId() + File.separator + s.getId();
        File outDir = new File(fos.getOutputPath(fileName, 0)).getParentFile();
        if (outDir.exists()) {
            FileUtils.deleteDirectory((File)outDir);
        }
        ObjectNode pojo = this.objectMapper.createObjectNode();
        SessionSampleFile sampleFile = new SessionSampleFile();
        try {
            fos.writeOutput(this.getResource(s, data.equals("single"), model.equals("target")), fileName);
            pojo.set("count", (JsonNode)new IntNode(outDir.listFiles().length));
            sampleFile.setFileCount(outDir.listFiles().length);
            if (outDir.listFiles().length > 1) {
                this.logger.debug("Zip compressing {} output files", (Object)outDir.listFiles().length);
                fos.compressOutput(fileName);
                sampleFile.setType(SessionSampleFile.FileTypes.ZIP);
                sampleFile.setPath(fos.getOutputBaseDirectory() + File.separator + s.getId() + File.separator + s.getId() + ".zip");
                pojo.set("link", (JsonNode)new TextNode(s.getId() + "/zip"));
            } else {
                sampleFile.setType(fos instanceof XmlFileOutputService ? SessionSampleFile.FileTypes.XML : SessionSampleFile.FileTypes.JSON);
                sampleFile.setPath(fos.getOutputBaseDirectory() + File.separator + s.getId() + File.separator + s.getId() + "." + fos.getFileExtension());
            }
            s.setSampleFile(sampleFile);
            this.sessionService.saveSession(s);
        }
        catch (Exception e) {
            pojo.set("count", (JsonNode)new IntNode(0));
            this.logger.warn("Failed to convert output", (Throwable)e);
        }
        result.setPojo((Object)pojo);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)pojo);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/download_output/"})
    public ResponseEntity<byte[]> getFile(@PathVariable String entityId, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException, IOException {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        File downloadFile = new File(s.getSampleFile().getPath());
        byte[] contents = IOUtils.toByteArray((InputStream)new FileInputStream(downloadFile));
        if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.XML)) {
            headers.setContentType(MediaType.APPLICATION_XML);
        } else if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.ZIP)) {
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        } else {
            headers.setContentType(MediaType.APPLICATION_JSON);
        }
        headers.setContentDispositionFormData(downloadFile.getName(), downloadFile.getName());
        headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
        return new ResponseEntity((Object)contents, (MultiValueMap)headers, HttpStatus.OK);
    }

    private Resource[] getResource(PersistedSession s, boolean single, boolean target) {
        if (target) {
            if (single) {
                return new Resource[]{(Resource)this.sessionService.loadSampleMapped(s.getId()).get(s.getSelectedOutputIndex())};
            }
            return this.sessionService.loadSampleMapped(s.getId()).toArray(new Resource[0]);
        }
        if (single) {
            return new Resource[]{(Resource)this.sessionService.loadSampleOutput(s.getId()).get(s.getSelectedOutputIndex())};
        }
        return this.sessionService.loadSampleOutput(s.getId()).toArray(new Resource[0]);
    }

    private String getModelId(String entityId, boolean target) {
        Identifiable entity = this.getEntity(entityId);
        if (Datamodel.class.isAssignableFrom(entity.getClass())) {
            return entity.getId();
        }
        Mapping m = (Mapping)entity;
        if (target) {
            return m.getTargetId();
        }
        return m.getSourceId();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/download_sample_input"})
    @ResponseBody
    public String downloadSampleInput(@PathVariable String entityId, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) throws SchemaImportException, IOException {
        ModelActionPojo result = new ModelActionPojo();
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        InputStream is = PersistedSessionServiceImpl.getSampleInputStream((PersistedSession)s);
        if (is == null) {
            response.setStatus(204);
            return null;
        }
        ObjectNode pojo = this.objectMapper.createObjectNode();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (Charset)Charsets.UTF_8);
        pojo.set("content", (JsonNode)new TextNode(writer.toString()));
        if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.XML)) {
            pojo.set("mime", (JsonNode)new TextNode("application/xml; charset=utf-8"));
        } else if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.JSON)) {
            pojo.set("mime", (JsonNode)new TextNode("application/json; charset=utf-8"));
        } else if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.CSV)) {
            pojo.set("mime", (JsonNode)new TextNode("text/comma-separated-values; charset=utf-8"));
        } else if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.TSV)) {
            pojo.set("mime", (JsonNode)new TextNode("text/tab-separated-values; charset=utf-8"));
        } else if (s.getSampleFile().getType().equals((Object)SessionSampleFile.FileTypes.ZIP)) {
            pojo.set("mime", (JsonNode)new TextNode("application/zip; charset=utf-8"));
        } else {
            pojo.set("mime", (JsonNode)new TextNode("text/plain; charset=utf-8"));
        }
        pojo.set("name", (JsonNode)new TextNode(new File(s.getSampleFile().getPath()).getName()));
        result.setPojo((Object)pojo);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)pojo);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/applySample"})
    @ResponseBody
    public ModelActionPojo applySample(@PathVariable String entityId, @RequestParam String sample, @RequestParam(defaultValue="XML") String fileType, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return new ModelActionPojo(false);
        }
        SessionSampleFile sampleFile = this.sessionService.saveAsSessionInputFile(sample, SessionSampleFile.FileTypes.valueOf((String)fileType), s.getId());
        s.setSampleFile(sampleFile);
        s.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.INFO, (String)"~de.unibamberg.minf.dme.editor.sample.log.session_sample_set", null));
        this.sessionService.saveSession(s);
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getSampleResource"})
    @ResponseBody
    public ModelActionPojo getSampleResource(@PathVariable String entityId, @RequestParam(defaultValue="0") int index, @RequestParam(defaultValue="false") boolean force, HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        ModelActionPojo result = new ModelActionPojo();
        ObjectNode statusPojo = this.objectMapper.createObjectNode();
        result.setStatusInfo((Object)statusPojo);
        List sampleOutput = this.sessionService.loadSampleOutput(s.getId());
        if (sampleOutput != null && sampleOutput.size() > 0 && sampleOutput.size() > index) {
            List concepts;
            HashMap valueMap = new HashMap();
            ArrayList resourceMap = new ArrayList();
            this.fillValueMap(valueMap, (Resource)sampleOutput.get(index));
            this.fillValueHierarchyMap(resourceMap, (Resource)sampleOutput.get(index));
            if (this.mappingService.findMappingById(entityId) == null || (concepts = this.relatedConceptService.findAllByMappingId(entityId)) != null) {
                // empty if block
            }
            this.sessionService.saveSelectedValueMap(s.getId(), valueMap);
            this.sessionService.saveSelectedResourceMap(s.getId(), resourceMap);
            s.setSelectedOutputIndex(index);
            this.sessionService.saveSession(s);
            result.setSuccess(true);
            statusPojo.set("available", (JsonNode)BooleanNode.TRUE);
            JsonNode pojo = ResourcePojoConverter.convertResource((Resource)((Resource)sampleOutput.get(index)));
            if (!force && pojo.toString().getBytes().length > this.debugConfig.getSamplesMaxTravelSize()) {
                statusPojo.set("oversize", (JsonNode)BooleanNode.TRUE);
            } else {
                statusPojo.set("oversize", (JsonNode)BooleanNode.FALSE);
                result.setPojo((Object)pojo);
            }
            return result;
        }
        statusPojo.set("available", (JsonNode)BooleanNode.FALSE);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getTransformedResource"})
    @ResponseBody
    public ModelActionPojo getTransformedResource(@PathVariable String entityId, @RequestParam(defaultValue="0") int index, @RequestParam(defaultValue="false") boolean force, HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        ModelActionPojo result = new ModelActionPojo();
        ObjectNode statusPojo = this.objectMapper.createObjectNode();
        result.setStatusInfo((Object)statusPojo);
        List sampleMapped = this.sessionService.loadSampleMapped(s.getId());
        if (sampleMapped != null && sampleMapped.size() > 0 && sampleMapped.size() > index) {
            s.setSelectedOutputIndex(index);
            this.sessionService.saveSession(s);
            result.setSuccess(true);
            statusPojo.set("available", (JsonNode)BooleanNode.TRUE);
            JsonNode pojo = ResourcePojoConverter.convertResource((Resource)((Resource)sampleMapped.get(index)));
            if (!force && pojo.toString().getBytes().length > this.debugConfig.getSamplesMaxTravelSize()) {
                statusPojo.set("oversize", (JsonNode)BooleanNode.TRUE);
            } else {
                statusPojo.set("oversize", (JsonNode)BooleanNode.FALSE);
                result.setPojo((Object)pojo);
            }
            return result;
        }
        statusPojo.set("available", (JsonNode)BooleanNode.FALSE);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/executeSample"})
    @ResponseBody
    public ModelActionPojo executeSample(@PathVariable String entityId, @RequestParam(required=false) String inputType, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        BaseResourceProcessingServiceImpl processingSvc;
        SessionSampleFile file;
        Datamodel s;
        PersistedSession session;
        Stopwatch sw = new Stopwatch().start();
        Stopwatch swTotal = new Stopwatch().start();
        ModelActionPojo result = new ModelActionPojo(true);
        result.setPojo((Object)0);
        if (this.debugConfig.isProcessing()) {
            this.logger.debug("Start executing sample against datamodel [{}]", (Object)entityId);
        }
        if ((session = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId())) == null) {
            response.setStatus(205);
            return null;
        }
        if (!session.hasData()) {
            session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.WARNING, (String)"~de.unibamberg.minf.dme.editor.sample.log.no_data_available", null));
            this.sessionService.saveSession(session);
            response.setStatus(204);
            return null;
        }
        if (this.debugConfig.isProcessing()) {
            this.logger.debug("Session for transformation loaded [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            sw.reset();
        }
        if ((s = this.schemaService.findSchemaById(entityId)) == null) {
            Mapping m = this.mappingService.findMappingById(entityId);
            s = this.schemaService.findSchemaById(m.getSourceId());
        }
        if (this.debugConfig.isProcessing()) {
            this.logger.debug("Datamodel loaded [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            sw.reset();
        }
        Nonterminal r = (Nonterminal)this.elementService.findRootBySchemaId(s.getId(), true);
        if (inputType != null) {
            session = this.sessionService.setSampleFileType(session, SessionSampleFile.FileTypes.valueOf((String)inputType));
        }
        if ((file = session.getSampleFile()).getType().equals((Object)SessionSampleFile.FileTypes.XML)) {
            processingSvc = (BaseResourceProcessingServiceImpl)this.appContext.getBean(XmlProcessingService.class);
        } else if (file.getType().equals((Object)SessionSampleFile.FileTypes.JSON)) {
            processingSvc = (BaseResourceProcessingServiceImpl)this.appContext.getBean(JsonProcessingService.class);
        } else if (file.getType().equals((Object)SessionSampleFile.FileTypes.YAML)) {
            processingSvc = (BaseResourceProcessingServiceImpl)this.appContext.getBean(YamlProcessingService.class);
        } else if (file.getType().equals((Object)SessionSampleFile.FileTypes.CSV)) {
            processingSvc = (BaseResourceProcessingServiceImpl)this.appContext.getBean(CsvProcessingService.class);
            ((CsvProcessingService)processingSvc).setUseHeadings(true);
        } else if (file.getType().equals((Object)SessionSampleFile.FileTypes.TSV)) {
            processingSvc = (BaseResourceProcessingServiceImpl)this.appContext.getBean(TsvProcessingService.class);
            ((TsvProcessingService)processingSvc).setUseHeadings(true);
        } else {
            processingSvc = (BaseResourceProcessingServiceImpl)this.appContext.getBean(TextProcessingService.class);
        }
        processingSvc.setInputStream(PersistedSessionServiceImpl.getSampleInputStream((PersistedSession)session));
        CollectingResourceConsumptionServiceImpl consumptionService = new CollectingResourceConsumptionServiceImpl();
        processingSvc.setSchema(s);
        processingSvc.addConsumptionService((ResourceConsumptionService)consumptionService);
        try {
            processingSvc.setExecutionContext((ExecutionContext)new SessionExecutionContext(this.mainConfig.getPaths().getSessionData(), session.getId(), this.sessionService.loadSessionData(session.getId())));
            processingSvc.setRoot(r);
            processingSvc.init();
            if (this.debugConfig.isProcessing()) {
                this.logger.debug("Preparation of sample for datamodel [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            }
            sw.reset();
            processingSvc.run();
            if (this.debugConfig.isProcessing()) {
                this.logger.debug("Parse of sample against datamodel [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            }
            sw.stop();
            List outputResources = consumptionService.getResources();
            this.sessionService.saveSampleOutput(session.getId(), outputResources);
            this.sessionService.saveSelectedValueMap(session.getId(), null);
            this.sessionService.saveSampleMapped(session.getId(), null);
            if (outputResources != null && !outputResources.isEmpty()) {
                result.setPojo((Object)outputResources.size());
                if (outputResources.size() == 1) {
                    session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.SUCCESS, (String)"~de.unibamberg.minf.dme.editor.sample.log.processed_1_result", (Object[])new Object[]{sw.getElapsedTime(), swTotal.getElapsedTime()}));
                } else {
                    session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.SUCCESS, (String)"~de.unibamberg.minf.dme.editor.sample.log.processed_n_results", (Object[])new Object[]{sw.getElapsedTime(), swTotal.getElapsedTime(), consumptionService.getResources().size()}));
                }
            } else {
                session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.WARNING, (String)"~de.unibamberg.minf.dme.editor.sample.log.processed_no_results", null));
            }
            this.sessionService.saveSession(session);
            if (this.debugConfig.isProcessing()) {
                this.logger.debug("Post-parse session handling for datamodel [{}] took {}ms", (Object)entityId, (Object)sw.getElapsedTime());
            }
        }
        catch (Exception e) {
            this.logger.error("Error parsing XML string", (Throwable)e);
        }
        return result;
    }

    private void fillValueMap(Map<String, String> valueMap, Resource r) {
        if (r.getElementId() == null) {
            return;
        }
        if (!valueMap.containsKey(r.getElementId())) {
            valueMap.put(r.getElementId(), r.getValue() == null ? "" : r.getValue().toString());
        }
        if (r.getChildResources() != null) {
            for (Resource rChild : r.getChildResources()) {
                this.fillValueMap(valueMap, rChild);
            }
        }
    }

    private void fillValueHierarchyMap(List<Resource> valueMap, Resource r) {
        if (r.getElementId() == null) {
            return;
        }
        valueMap.add(r);
        if (r.getChildResources() != null) {
            for (Resource rChild : r.getChildResources()) {
                this.fillValueHierarchyMap(valueMap, rChild);
            }
        }
    }

    protected abstract BaseEntityService getMainEntityService();

    protected abstract String getPrefix();

    protected abstract BaseImportWorker<? extends Importer> getImportWorker();

    protected abstract ModelActionPojo validateImportedFile(String var1, String var2, String var3, Locale var4);

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

