/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.api;

import de.unibamberg.minf.dme.controller.api.BaseApiController;
import de.unibamberg.minf.dme.exporter.DatamodelExporter;
import de.unibamberg.minf.dme.model.serialization.DatamodelReferenceContainer;
import eu.dariah.de.dariahsp.web.AuthInfoHelper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"})
public class ModelApiController
extends BaseApiController {
    protected static final Logger logger = LoggerFactory.getLogger(ModelApiController.class);
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Autowired
    private DatamodelExporter exporter;

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public List<DatamodelReferenceContainer> getDatamodels(HttpServletRequest request) {
        try {
            return this.exporter.exportDatamodels(this.authInfoHelper.getAuth(), true);
        }
        catch (Exception e) {
            logger.error("Failed to export datamodels", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{entityId}"})
    @ResponseBody
    public DatamodelReferenceContainer exportDatamodel(@PathVariable String entityId, HttpServletRequest request) {
        return this.exporter.exportDatamodel(entityId, this.authInfoHelper.getAuth());
    }
}

