/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller.api;

import de.unibamberg.minf.dme.controller.api.BaseApiController;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.mapping.MappingImpl;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.model.serialization.MappingContainer;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.service.interfaces.FunctionService;
import de.unibamberg.minf.dme.service.interfaces.MappingService;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import eu.dariah.de.dariahsp.web.AuthInfoHelper;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/mappings"})
public class MappingApiController
extends BaseApiController {
    protected static final Logger logger = LoggerFactory.getLogger(MappingApiController.class);
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Autowired
    private MappingService mappingService;
    @Autowired
    private RelatedConceptService relatedConceptService;
    @Autowired
    private FunctionService functionService;

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public List<MappingContainer> getMappings(HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        List mappings = this.mappingService.findAllByAuth(auth, false);
        ArrayList<MappingContainer> result = new ArrayList<MappingContainer>();
        if (mappings != null) {
            for (RightsContainer m : mappings) {
                MappingContainer mc = new MappingContainer();
                mc.setMapping((MappingImpl)m.getElement());
                result.add(mc);
            }
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/by-source/{sourceId}"})
    @ResponseBody
    public List<MappingContainer> getMappingsBySource(@PathVariable String sourceId, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        return this.processMappings(this.mappingService.findAllByAuthAndSourceId(auth, sourceId));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/by-target/{targetId}"})
    @ResponseBody
    public List<MappingContainer> getMappingsByTarget(@PathVariable String targetId, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        return this.processMappings(this.mappingService.findAllByAuthAndTargetId(auth, targetId));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/by-source-and-target/{sourceId}/{targetId}"})
    @ResponseBody
    public MappingContainer getMappingBySourceAndTarget(@PathVariable String sourceId, @PathVariable String targetId, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        return this.processMappingWithDetails(this.mappingService.findByAuthAndSourceAndTargetId(auth, sourceId, targetId));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{entityId}"})
    @ResponseBody
    public MappingContainer getMapping(@PathVariable String entityId, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        return this.processMappingWithDetails(this.mappingService.findByIdAndAuth(entityId, auth));
    }

    private List<MappingContainer> processMappings(List<RightsContainer<Mapping>> mappings) {
        ArrayList<MappingContainer> result = new ArrayList<MappingContainer>();
        if (mappings != null) {
            for (RightsContainer<Mapping> m : mappings) {
                MappingContainer mc = new MappingContainer();
                ChangeSet ch = this.mappingService.getLatestChangeSetForEntity(m.getId());
                if (ch != null) {
                    ((Mapping)m.getElement()).setVersionId(ch.getId());
                }
                ((Mapping)m.getElement()).flush();
                mc.setMapping((MappingImpl)m.getElement());
                result.add(mc);
            }
        }
        return result;
    }

    private MappingContainer processMappingWithDetails(RightsContainer<Mapping> mapping) {
        if (mapping != null) {
            MappingContainer result = new MappingContainer();
            result.setMapping((MappingImpl)mapping.getElement());
            ((Mapping)mapping.getElement()).setConcepts(this.relatedConceptService.findAllByMappingId(mapping.getId(), true));
            ((Mapping)mapping.getElement()).flush();
            ChangeSet ch = this.mappingService.getLatestChangeSetForEntity(mapping.getId());
            if (ch != null) {
                ((Mapping)mapping.getElement()).setVersionId(ch.getId());
            }
            ((Mapping)mapping.getElement()).flush();
            List grammars = this.grammarService.getNonPassthroughGrammars(mapping.getId());
            if (grammars != null && !grammars.isEmpty()) {
                result.setGrammars(new HashMap());
                for (Grammar g : grammars) {
                    result.getGrammars().put(g.getId(), g);
                }
            }
            HashMap<String, String> serializedFunctions = new HashMap<String, String>();
            List functions = this.functionService.findByEntityId(mapping.getId());
            for (Function f : functions) {
                serializedFunctions.put(f.getId(), f.getFunction());
            }
            result.setFunctions(serializedFunctions);
            return result;
        }
        return null;
    }
}

