/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller;

import de.unibamberg.minf.core.web.controller.BaseTranslationController;
import de.unibamberg.minf.core.web.controller.DataTableList;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.model.PersistedVocabulary;
import de.unibamberg.minf.dme.model.PersistedVocabularyItem;
import de.unibamberg.minf.dme.service.interfaces.PersistedVocabularyService;
import de.unibamberg.minf.gtf.model.vocabulary.VocabularyItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/vocabulary"})
public class VocabularyController
extends BaseTranslationController {
    @Autowired
    private PersistedVocabularyService vocabularyService;

    public VocabularyController() {
        super("vocabulary");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String getList(Model model) {
        return "vocabulary/home";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getData"})
    @ResponseBody
    public DataTableList getData(Model model, Locale locale, HttpServletRequest request) {
        List vocabularies = this.vocabularyService.findAll();
        return new DataTableList(vocabularies);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/forms/add"})
    public String getAddForm(Model model, Locale locale) {
        model.addAttribute("vocabulary", (Object)new PersistedVocabulary());
        model.addAttribute("actionPath", (Object)"/vocabulary/async/save");
        return "vocabulary/form/edit";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/forms/edit/{id}"})
    public String getEditForm(@PathVariable String id, Model model, Locale locale) {
        PersistedVocabulary vocabulary = this.vocabularyService.findById(id);
        model.addAttribute("actionPath", (Object)"/vocabulary/async/save");
        model.addAttribute("vocabulary", (Object)vocabulary);
        return "vocabulary/form/edit";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/save"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo saveVocabulary(@Valid PersistedVocabulary vocabulary, BindingResult bindingResult, Locale locale) {
        if (vocabulary.getId() != null && vocabulary.getId().isEmpty()) {
            vocabulary.setId(null);
        }
        PersistedVocabulary saveVocabulary = null;
        if (vocabulary.getId() != null) {
            saveVocabulary = this.vocabularyService.findById(vocabulary.getId());
        }
        if (saveVocabulary == null) {
            saveVocabulary = vocabulary;
        } else {
            saveVocabulary.setLabel(vocabulary.getLabel());
            saveVocabulary.setDescription(vocabulary.getDescription());
        }
        this.vocabularyService.save(saveVocabulary);
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"{vocabularyId}/async/getData"})
    @ResponseBody
    public DataTableList getData(@PathVariable String vocabularyId, Model model, Locale locale, HttpServletRequest request) {
        PersistedVocabulary vocabulary = this.vocabularyService.findById(vocabularyId);
        ArrayList<PersistedVocabularyItem> resultItems = new ArrayList<PersistedVocabularyItem>();
        if (vocabulary.getItems() != null) {
            for (VocabularyItem vi : vocabulary.getItems()) {
                resultItems.add((PersistedVocabularyItem)vi);
            }
        }
        return new DataTableList(resultItems);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"{vocabularyId}/forms/add"})
    public String getItemAddForm(@PathVariable String vocabularyId, Model model, Locale locale) {
        model.addAttribute("vocabularyItem", (Object)new PersistedVocabularyItem());
        model.addAttribute("actionPath", (Object)("/vocabulary/" + vocabularyId + "/async/save"));
        return "vocabulary/form/edit_item";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"{vocabularyId}/forms/edit/{id}"})
    public String getItemEditForm(@PathVariable String vocabularyId, @PathVariable String id, Model model, Locale locale) {
        PersistedVocabulary vocabulary = this.vocabularyService.findById(vocabularyId);
        model.addAttribute("actionPath", (Object)("/vocabulary/" + vocabularyId + "/async/save"));
        for (VocabularyItem item : vocabulary.getItems()) {
            if (!((PersistedVocabularyItem)item).getId().equals(id)) continue;
            model.addAttribute("vocabularyItem", (Object)item);
            break;
        }
        return "vocabulary/form/edit_item";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"{vocabularyId}/async/save"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo saveVocabularyItem(@PathVariable String vocabularyId, @Valid PersistedVocabularyItem vocabularyItem, BindingResult bindingResult, Locale locale) {
        PersistedVocabulary saveVocabulary = this.vocabularyService.findById(vocabularyId);
        if (saveVocabulary.getItems() == null) {
            saveVocabulary.setItems(new ArrayList());
        }
        if (vocabularyItem.getId() != null && vocabularyItem.getId().isEmpty()) {
            vocabularyItem.setId(null);
        }
        if (vocabularyItem.getId() == null) {
            vocabularyItem.setId(new ObjectId().toString());
            saveVocabulary.getItems().add(vocabularyItem);
        } else {
            for (VocabularyItem i : saveVocabulary.getItems()) {
                if (!((PersistedVocabularyItem)i).getId().equals(vocabularyItem.getId())) continue;
                ((PersistedVocabularyItem)i).setSerializedData(vocabularyItem.getSerializedData());
                i.setLabel(vocabularyItem.getLabel());
            }
        }
        this.vocabularyService.save(saveVocabulary);
        return new ModelActionPojo(true);
    }
}

