/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller;

import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.LogEntry;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.pojo.LogEntryPojo;
import de.unibamberg.minf.dme.pojo.converter.LogEntryPojoConverter;
import de.unibamberg.minf.dme.service.interfaces.PersistedSessionService;
import eu.dariah.de.dariahsp.web.AuthInfoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sessions"})
public class SessionsController {
    @Autowired
    protected AuthInfoHelper authInfoHelper;
    @Autowired
    private PersistedSessionService sessionService;
    @Autowired
    protected MessageSource messageSource;
    @Autowired
    private LogEntryPojoConverter logEntryConverter;

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    public ModelActionPojo getHome(HttpServletResponse response) {
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/deleteSession"})
    @ResponseBody
    public ModelActionPojo deleteSession(@RequestParam String entityId, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        PersistedSession sCurrent = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (sCurrent == null) {
            response.setStatus(205);
            return null;
        }
        this.sessionService.deleteSession(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/newSession"})
    @ResponseBody
    public ModelActionPojo newSession(@RequestParam String entityId, HttpServletRequest request, HttpServletResponse response, Locale locale) throws GenericScheregException {
        String userId = this.authInfoHelper.getUserId();
        PersistedSession sCurrent = this.sessionService.get(entityId, request.getSession().getId(), userId);
        if (sCurrent == null) {
            response.setStatus(205);
            return null;
        }
        sCurrent.setHttpSessionId(null);
        this.sessionService.saveSession(sCurrent);
        this.sessionService.createAndSaveSession(entityId, request.getSession().getId(), userId);
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/form/loadSession"})
    public String getFormLoadSession(@RequestParam String entityId, Model model, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        PersistedSession sCurrent = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (sCurrent == null) {
            response.setStatus(205);
            return null;
        }
        List userSessions = this.sessionService.findAllByUser(entityId, this.authInfoHelper.getUserId());
        ArrayList<PersistedSession> savedSessions = new ArrayList<PersistedSession>();
        ArrayList<PersistedSession> transientSessions = new ArrayList<PersistedSession>();
        for (PersistedSession s : userSessions) {
            if (s.isNotExpiring()) {
                savedSessions.add(s);
                continue;
            }
            transientSessions.add(s);
        }
        Collections.sort(savedSessions);
        Collections.reverse(savedSessions);
        Collections.sort(transientSessions);
        Collections.reverse(transientSessions);
        model.addAttribute("locale", (Object)locale);
        model.addAttribute("savedSessions", savedSessions);
        model.addAttribute("transientSessions", transientSessions);
        model.addAttribute("currentSessionId", (Object)sCurrent.getId());
        model.addAttribute("actionPath", (Object)"/sessions/async/loadSession");
        return "session/forms/load";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/form/saveSession"})
    public String getFormSaveSession(@RequestParam String entityId, Model model, HttpServletRequest request, Locale locale, HttpServletResponse response) {
        PersistedSession s = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (s == null) {
            response.setStatus(205);
            return null;
        }
        model.addAttribute("session", (Object)s);
        model.addAttribute("actionPath", (Object)"/sessions/async/saveSession");
        return "session/forms/save";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/async/saveSession"})
    @ResponseBody
    public ModelActionPojo saveSession(@Valid PersistedSession session, HttpServletRequest request, Locale locale, HttpServletResponse response) {
        PersistedSession saveSession = this.sessionService.get(session.getEntityId(), request.getSession().getId(), this.authInfoHelper.getUserId());
        if (saveSession != null) {
            saveSession.setLabel(session.getLabel());
            saveSession.setNotExpiring(true);
            saveSession.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.INFO, (String)"~de.unibamberg.minf.dme.editor.sample.log.session_persisted", (Object[])new String[]{session.getLabel()}));
            this.sessionService.saveSession(saveSession);
            return new ModelActionPojo(true);
        }
        response.setStatus(205);
        return new ModelActionPojo(false);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/loadSession"})
    @ResponseBody
    public ModelActionPojo loadSession(@RequestParam String sessionId, HttpServletRequest request, Locale locale, HttpServletResponse response) {
        PersistedSession s = this.sessionService.reassignPersistedSession(request.getSession().getId(), this.authInfoHelper.getUserId(), sessionId);
        if (s == null) {
            response.setStatus(205);
            return new ModelActionPojo(false);
        }
        return new ModelActionPojo(true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getLog"})
    @ResponseBody
    public Collection<LogEntryPojo> getLog(@RequestParam String entityId, @RequestParam(defaultValue="10") Integer maxEntries, @RequestParam(required=false) Long tsMin, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        PersistedSession session = this.sessionService.get(entityId, request.getSession().getId(), this.authInfoHelper.getUserId());
        if (session == null) {
            response.setStatus(205);
            return null;
        }
        List log = session.getSessionLog();
        if (tsMin != null && log.size() > 0 && ((LogEntry)log.get(0)).getTimestamp().getMillis() <= tsMin) {
            return new ArrayList<LogEntryPojo>();
        }
        if (log != null && log.size() > 0) {
            if (log.size() > maxEntries) {
                return this.logEntryConverter.convert(log.subList(0, maxEntries), locale);
            }
            return this.logEntryConverter.convert(log, locale);
        }
        return new ArrayList<LogEntryPojo>();
    }
}

