/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller;

import de.unibamberg.minf.core.web.controller.DataTableList;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.BaseIdentifiable;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.datamodel.DatamodelImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.pojo.AuthWrappedPojo;
import de.unibamberg.minf.dme.pojo.converter.AuthWrappedPojoConverter;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/model"})
public class ModelController
extends BaseScheregController {
    @Autowired
    private AuthWrappedPojoConverter authPojoConverter;

    public ModelController() {
        super("schema");
    }

    @RequestMapping(value={"/editor"}, method={RequestMethod.GET})
    public String getEditorRedirect(HttpServletResponse response) throws IOException {
        response.sendRedirect("../");
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getData"})
    @ResponseBody
    public DataTableList getData(Model model, Locale locale, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        List schemas = this.schemaService.findAllByAuth(this.authInfoHelper.getAuth());
        List pojos = this.authPojoConverter.convert(schemas, auth.getUserId());
        return new DataTableList(pojos);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getData/{id}"})
    @ResponseBody
    public AuthWrappedPojo<Datamodel> getSchema(@PathVariable String id, Model model, Locale locale, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        return this.authPojoConverter.convert(this.schemaService.findByIdAndAuth(id, auth), auth.getUserId());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getElements/{id}"})
    @ResponseBody
    public Datamodel getElements(@PathVariable String id, Model model, Locale locale) {
        return this.schemaService.findSchemaById(id);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/forms/add"})
    public String getAddForm(Model model, Locale locale) {
        model.addAttribute("datamodelImpl", (Object)new DatamodelImpl());
        model.addAttribute("actionPath", (Object)"/model/async/save");
        return "model/form/edit";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/async/save"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo saveSchema(@Valid DatamodelImpl datamodelImpl, BindingResult bindingResult, @RequestParam(required=false) String updateId, @RequestParam(defaultValue="false") boolean readOnly, Locale locale, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean draft;
        RightsContainer existSchema;
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(datamodelImpl.getId(), auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (!result.isSuccess()) {
            return result;
        }
        if (datamodelImpl.getId().isEmpty()) {
            datamodelImpl.setId(null);
        }
        Datamodel saveSchema = (existSchema = this.schemaService.findByIdAndAuth(datamodelImpl.getId(), auth)) == null ? null : (Datamodel)existSchema.getElement();
        boolean bl = draft = existSchema == null ? true : existSchema.isDraft();
        if (saveSchema == null) {
            saveSchema = datamodelImpl;
        } else {
            saveSchema.setName(datamodelImpl.getName());
            saveSchema.setDescription(datamodelImpl.getDescription());
        }
        if (updateId != null && !updateId.isEmpty() && !updateId.equals(saveSchema.getId())) {
            if (!BaseIdentifiable.checkIdValid((String)updateId)) {
                result.addFieldError("datamodelImpl_updateId", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.identifiable.validation.id", null, locale));
                result.setSuccess(false);
            } else if (this.mappingService.findMappingById(updateId) != null || this.schemaService.findSchemaById(updateId) != null) {
                result.addFieldError("datamodelImpl_updateId", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.schema.validation.id_not_unique", null, locale));
                result.setSuccess(false);
            } else {
                this.schemaService.saveSchema(new AuthWrappedPojo((Identifiable)saveSchema, true, false, false, draft, readOnly), auth);
                this.schemaService.changeId(saveSchema.getId(), updateId);
                this.mappingService.changeDatamodelId(saveSchema.getId(), updateId);
                result.setStatusInfo((Object)updateId);
            }
        } else {
            this.schemaService.saveSchema(new AuthWrappedPojo((Identifiable)saveSchema, true, false, false, draft, readOnly), auth);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/delete/{id}"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo deleteSchema(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        ModelActionPojo result;
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.schemaService.getUserCanWriteEntity(id, auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        if (id != null && !id.isEmpty()) {
            this.schemaService.deleteSchemaById(id, auth);
            result = new ModelActionPojo(true);
        } else {
            result = new ModelActionPojo(false);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/publish/{id}"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo publishSchema(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        ModelActionPojo result = new ModelActionPojo(false);
        if (id != null && !id.isEmpty()) {
            AuthPojo auth = this.authInfoHelper.getAuth();
            if (!this.schemaService.getUserCanWriteEntity(id, auth.getUserId())) {
                response.setStatus(403);
                return new ModelActionPojo(false);
            }
            RightsContainer existSchema = this.schemaService.findByIdAndAuth(id, auth);
            if (existSchema != null) {
                existSchema.setDraft(false);
                this.schemaService.saveSchema(this.authPojoConverter.convert(existSchema, auth.getUserId()), auth);
                result.setSuccess(true);
            }
        }
        return result;
    }
}

