/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.controller;

import de.unibamberg.minf.core.web.controller.DataTableList;
import de.unibamberg.minf.core.web.pojo.MessagePojo;
import de.unibamberg.minf.core.web.pojo.ModelActionPojo;
import de.unibamberg.minf.dme.controller.base.BaseScheregController;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.BaseIdentifiable;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.mapping.MappingImpl;
import de.unibamberg.minf.dme.model.mapping.base.Mapping;
import de.unibamberg.minf.dme.pojo.AuthWrappedPojo;
import de.unibamberg.minf.dme.pojo.converter.AuthWrappedPojoConverter;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mapping/"})
public class MappingController
extends BaseScheregController {
    @Autowired
    private AuthWrappedPojoConverter authPojoConverter;

    public MappingController() {
        super("mapping");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getData"})
    @ResponseBody
    public DataTableList getData(Model model, Locale locale, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        List mappings = this.mappingService.findAllByAuth(this.authInfoHelper.getAuth(), true);
        List pojos = this.authPojoConverter.convert(mappings, auth.getUserId());
        return new DataTableList(pojos);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/async/getData/{id}"})
    @ResponseBody
    public AuthWrappedPojo<Mapping> getMapping(@PathVariable String id, Model model, Locale locale, HttpServletRequest request) {
        AuthPojo auth = this.authInfoHelper.getAuth();
        return this.authPojoConverter.convert(this.mappingService.findByIdAndAuth(id, auth), auth.getUserId());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"forms/add"})
    public String getAddForm(Model model, Locale locale, HttpServletRequest request) {
        List schemas = this.schemaService.findAllByAuth(this.authInfoHelper.getAuth());
        MappingImpl m = new MappingImpl();
        if (schemas.size() > 1) {
            m.setSourceId(((RightsContainer)schemas.get(0)).getId());
            m.setTargetId(((RightsContainer)schemas.get(1)).getId());
        }
        model.addAttribute("mapping", (Object)m);
        model.addAttribute("schemas", (Object)schemas);
        model.addAttribute("draft", (Object)true);
        model.addAttribute("actionPath", (Object)"/mapping/async/save");
        return "mapping/form/edit";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"forms/edit/{id}"})
    public String getEditForm(@PathVariable String id, Model model, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        if (!this.mappingService.getUserCanWriteEntity(id, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        AuthPojo auth = this.authInfoHelper.getAuth();
        RightsContainer mapping = this.mappingService.findByIdAndAuth(id, auth);
        ArrayList<RightsContainer> schemas = new ArrayList<RightsContainer>(2);
        schemas.add(this.schemaService.findByIdAndAuth(((Mapping)mapping.getElement()).getSourceId(), auth));
        schemas.add(this.schemaService.findByIdAndAuth(((Mapping)mapping.getElement()).getTargetId(), auth));
        model.addAttribute("schemas", schemas);
        model.addAttribute("actionPath", (Object)"/mapping/async/save");
        model.addAttribute("draft", (Object)mapping.isDraft());
        model.addAttribute("readOnly", (Object)mapping.isReadOnly());
        model.addAttribute("mapping", (Object)mapping.getElement());
        return "mapping/form/edit";
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"async/save"})
    @ResponseBody
    public ModelActionPojo saveMapping(@Valid MappingImpl mapping, BindingResult bindingResult, @RequestParam(required=false) String updateId, @RequestParam(defaultValue="false") boolean readOnly, Locale locale, HttpServletRequest request, HttpServletResponse response) {
        RightsContainer existMapping;
        AuthPojo auth = this.authInfoHelper.getAuth();
        if (!this.mappingService.getUserCanWriteEntity(mapping.getId(), auth.getUserId())) {
            response.setStatus(403);
            return new ModelActionPojo(false);
        }
        if (mapping.getId().isEmpty()) {
            mapping.setId(null);
        }
        Mapping saveMapping = (existMapping = this.mappingService.findByIdAndAuth(mapping.getId(), auth)) == null ? null : (Mapping)existMapping.getElement();
        boolean draft = existMapping == null ? true : existMapping.isDraft();
        if (!this.mappingService.getUserCanWriteEntity(saveMapping == null ? mapping.getId() : saveMapping.getId(), this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        if (saveMapping == null) {
            saveMapping = mapping;
        } else {
            saveMapping.setDescription(mapping.getDescription());
        }
        if (saveMapping.getSourceId().equals(saveMapping.getTargetId())) {
            bindingResult.addError(new ObjectError("mapping", new String[]{"~de.unibamberg.minf.dme.model.mapping.validation.same_source_and_target"}, null, "Source and target schema cannot be the same"));
        }
        ModelActionPojo result = this.getActionResult(bindingResult, locale);
        if (bindingResult.hasErrors()) {
            return result;
        }
        if (updateId != null && !updateId.isEmpty() && !updateId.equals(saveMapping.getId())) {
            if (!BaseIdentifiable.checkIdValid((String)updateId)) {
                result.addFieldError("mappingImpl_updateId", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.identifiable.validation.id", null, locale));
                result.setSuccess(false);
            } else if (this.mappingService.findMappingById(updateId) != null || this.schemaService.findSchemaById(updateId) != null) {
                result.addFieldError("datamodelImpl_updateId", this.messageSource.getMessage("~de.unibamberg.minf.dme.model.schema.validation.id_not_unique", null, locale));
                result.setSuccess(false);
            } else {
                this.mappingService.saveMapping(new AuthWrappedPojo((Identifiable)saveMapping, true, false, false, draft, readOnly), auth);
                this.mappingService.changeId(saveMapping.getId(), updateId);
                result.setStatusInfo((Object)updateId);
            }
        } else {
            this.mappingService.saveMapping(new AuthWrappedPojo((Identifiable)saveMapping, true, false, false, draft, readOnly), auth);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/delete/{id}"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo deleteMapping(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        ModelActionPojo result;
        if (!this.mappingService.getUserCanWriteEntity(id, this.authInfoHelper.getAuth().getUserId())) {
            response.setStatus(403);
            return null;
        }
        if (id != null && !id.isEmpty()) {
            this.mappingService.deleteMappingById(id, this.authInfoHelper.getAuth());
            result = new ModelActionPojo(true);
        } else {
            result = new ModelActionPojo(false);
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/async/publish/{id}"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public ModelActionPojo publishMapping(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        ModelActionPojo result = new ModelActionPojo(false);
        if (id != null && !id.isEmpty()) {
            if (!this.mappingService.getUserCanWriteEntity(id, this.authInfoHelper.getAuth().getUserId())) {
                response.setStatus(403);
                return null;
            }
            AuthPojo auth = this.authInfoHelper.getAuth();
            RightsContainer existMapping = this.mappingService.findByIdAndAuth(id, auth);
            if (existMapping != null) {
                RightsContainer source = this.schemaService.findByIdAndAuth(((Mapping)existMapping.getElement()).getSourceId(), auth);
                RightsContainer target = this.schemaService.findByIdAndAuth(((Mapping)existMapping.getElement()).getTargetId(), auth);
                if (source.isDraft() || target.isDraft()) {
                    result.setMessage(new MessagePojo("error", "~de.unibamberg.minf.dme.model.mapping.validation.no_pub_schema_drafts", ""));
                    return result;
                }
                existMapping.setDraft(false);
                this.mappingService.saveMapping(this.authPojoConverter.convert(existMapping, auth.getUserId()), auth);
                result.setSuccess(true);
            }
        }
        return result;
    }
}

