/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.confg;

import de.unibamberg.minf.core.web.init.LocaleAwareInitializationService;
import de.unibamberg.minf.core.web.init.LocaleAwareInitializationServiceImpl;
import de.unibamberg.minf.core.web.interceptor.UserLocaleChangeInterceptor;
import de.unibamberg.minf.core.web.localization.MessageSource;
import de.unibamberg.minf.core.web.theming.ThemeManagerImpl;
import de.unibamberg.minf.dme.confg.LogConfig;
import de.unibamberg.minf.dme.confg.MainConfig;
import de.unibamberg.minf.dme.confg.nested.LocalizationConfig;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.mongodb.core.mapping.event.ValidatingMongoEventListener;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.view.tiles3.TilesConfigurer;
import org.springframework.web.servlet.view.tiles3.TilesViewResolver;

@Configuration
@ConfigurationProperties
public class WebConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebConfig.class);
    private String theme;
    private LocalizationConfig localization;
    @Autowired
    private MainConfig mainConfig;
    @Autowired
    private LogConfig logConfig;
    @Autowired
    ResourceLoader resourceLoader;

    @PostConstruct
    public void completeConfiguration() {
        if (this.localization.getBaseNames() == null) {
            this.localization.setBaseNames(new String[]{"/themes/" + this.theme + "/i18n/theme", "classpath:i18n/messages"});
        }
    }

    @Bean
    public ThemeManagerImpl themeManagerImpl() {
        ThemeManagerImpl themeManagerImpl = new ThemeManagerImpl();
        themeManagerImpl.setTheme("/themes/" + this.theme + "/");
        themeManagerImpl.setCheckExistsSubpaths(Arrays.asList("/i18n/theme_de.properties", "/css/bootstrap.css", "/img/theme-logo-de.svg", "/js", "/jsp/footer.jsp"));
        return themeManagerImpl;
    }

    @Bean
    public TilesConfigurer tilesConfigurer() {
        TilesConfigurer tilesConfigurer = new TilesConfigurer();
        tilesConfigurer.setDefinitions(new String[]{"/WEB-INF/view/templates.xml", "/WEB-INF/view/views.xml"});
        tilesConfigurer.setCheckRefresh(true);
        tilesConfigurer.setUseMutableTilesContainer(true);
        return tilesConfigurer;
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        TilesViewResolver viewResolver = new TilesViewResolver();
        viewResolver.setPrefix(this.theme + "/");
        viewResolver.setCache(false);
        registry.viewResolver((ViewResolver)viewResolver);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"/resources/"});
        registry.addResourceHandler(new String[]{"/themes/**"}).addResourceLocations(new String[]{"/themes/"});
        registry.addResourceHandler(new String[]{"/theme/**"}).addResourceLocations(new String[]{"/themes/" + this.theme + "/"});
    }

    @Bean
    public LocaleAwareInitializationService initService() {
        LocaleAwareInitializationServiceImpl initService = new LocaleAwareInitializationServiceImpl();
        initService.setBasename(this.localization.getBaseNames()[0]);
        log.debug("Initialized LocaleAwareInitializationServiceImpl");
        return initService;
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        localeResolver.setDefaultLocale(new Locale("de", "DE"));
        return localeResolver;
    }

    @Bean
    public UserLocaleChangeInterceptor localeChangeInterceptor() {
        UserLocaleChangeInterceptor lci = new UserLocaleChangeInterceptor();
        lci.setInitService(this.initService());
        lci.setParamName("lang");
        return lci;
    }

    @Bean
    public MessageSource messageSource() {
        MessageSource messageSource = new MessageSource();
        messageSource.setBasenames(this.localization.getBaseNames());
        messageSource.setLoggingMode(this.localization.isDebug());
        messageSource.setCacheSeconds(this.localization.getCacheSeconds());
        messageSource.setReturnMissingCodes(true);
        return messageSource;
    }

    @Bean
    public ValidatingMongoEventListener validatingMongoEventListener() {
        return new ValidatingMongoEventListener((Validator)this.validator());
    }

    @Bean
    public LocalValidatorFactoryBean validator() {
        LocalValidatorFactoryBean validatorFactory = new LocalValidatorFactoryBean();
        validatorFactory.setValidationMessageSource((org.springframework.context.MessageSource)this.messageSource());
        return validatorFactory;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
    }

    public String getTheme() {
        return this.theme;
    }

    public LocalizationConfig getLocalization() {
        return this.localization;
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void setLocalization(LocalizationConfig localization) {
        this.localization = localization;
    }

    public void setMainConfig(MainConfig mainConfig) {
        this.mainConfig = mainConfig;
    }

    public void setLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

