/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.confg;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import de.unibamberg.minf.core.util.json.JsonNodeHelper;
import de.unibamberg.minf.core.web.service.ImageServiceImpl;
import de.unibamberg.minf.dme.confg.nested.ImagesConfigProperties;
import de.unibamberg.minf.dme.confg.nested.PathsConfigProperties;
import de.unibamberg.minf.dme.confg.nested.ThumbnailsConfigProperties;
import de.unibamberg.minf.dme.sessions.SessionCleanerService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;

@Configuration
@ConfigurationProperties
public class MainConfig {
    private String contextPath = "/";
    private String baseUrl = "http://localhost:8080/";
    @Autowired
    ResourceLoader resourceLoader;
    protected PathsConfigProperties paths;
    protected ImagesConfigProperties images;

    @PostConstruct
    public void completeConfiguration() throws IOException {
        if (this.paths.getConfig() == null) {
            this.paths.setConfig(this.setupPath(this.paths.getMain(), new String[]{"config"}));
        }
        if (this.paths.getGrammars() == null) {
            this.paths.setGrammars(this.setupPath(this.paths.getMain(), new String[]{"grammars"}));
        }
        if (this.paths.getModels() == null) {
            this.paths.setModels(this.setupPath(this.paths.getMain(), new String[]{"models"}));
        }
        if (this.paths.getTemporary() == null) {
            this.paths.setTemporary(this.setupPath(this.paths.getMain(), new String[]{"temp"}));
        }
        if (this.paths.getSessionData() == null) {
            this.paths.setSessionData(this.setupPath(this.paths.getMain(), new String[]{"sessionData"}));
        }
        if (this.paths.getTmpUpload() == null) {
            this.paths.setTmpUpload(this.setupPath(this.paths.getMain(), new String[]{"tmpUpload"}));
        }
        if (this.paths.getSampleFiles() == null) {
            this.paths.setSampleFiles(this.setupPath(this.paths.getMain(), new String[]{"sampleFiles"}));
        }
        if (this.paths.getParseErrors() == null) {
            this.paths.setParseErrors(this.setupPath(this.paths.getMain(), new String[]{"parseErrors"}));
        }
        if (this.paths.getDownload() == null) {
            this.paths.setDownload(this.setupPath(this.paths.getMain(), new String[]{"download"}));
        }
        if (this.paths.getBackup() == null) {
            this.paths.setBackup(this.setupPath(this.paths.getMain(), new String[]{"backup"}));
        }
        if (this.images == null) {
            this.images = new ImagesConfigProperties();
        }
        if (this.images.getThumbnails() == null) {
            this.images.setThumbnails(new ThumbnailsConfigProperties());
        }
    }

    protected String setupPath(String first, String ... more) throws IOException {
        Path p = Paths.get(first, more);
        if (!Files.exists(p, new LinkOption[0])) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        return p.toString();
    }

    @Autowired
    public void setMapKeyDotReplacement(MappingMongoConverter mongoConverter) {
        mongoConverter.setMapKeyDotReplacement("~");
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JodaModule());
        return objectMapper;
    }

    @Bean
    public JsonNodeHelper jsonNodeHelper(ObjectMapper objectMapper) {
        JsonNodeHelper jsonNodeHelper = new JsonNodeHelper();
        jsonNodeHelper.setObjMapper(objectMapper);
        return jsonNodeHelper;
    }

    @Bean
    public SessionCleanerService sessionCleanerService() {
        SessionCleanerService sessionCleanerService = new SessionCleanerService();
        sessionCleanerService.setDefaultExpirationMins(525600);
        sessionCleanerService.setIntervalMins(2880);
        return sessionCleanerService;
    }

    @Bean
    public ImageServiceImpl imageService() {
        ImageServiceImpl imageServiceImpl = new ImageServiceImpl();
        imageServiceImpl.setImagePath(this.paths.getDownload());
        imageServiceImpl.setImagesSizeType(ImageServiceImpl.SizeBoundsType.MAX_SHORTEST_SIDE);
        imageServiceImpl.setImagesWidth(this.images.getWidth());
        imageServiceImpl.setImagesHeight(this.images.getHeight());
        imageServiceImpl.setThumbnailsSizeType(ImageServiceImpl.SizeBoundsType.MAX_SHORTEST_SIDE);
        imageServiceImpl.setThumbnailsWidth(this.images.getThumbnails().getWidth());
        imageServiceImpl.setThumbnailsHeight(this.images.getThumbnails().getHeight());
        return imageServiceImpl;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public PathsConfigProperties getPaths() {
        return this.paths;
    }

    public ImagesConfigProperties getImages() {
        return this.images;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setPaths(PathsConfigProperties paths) {
        this.paths = paths;
    }

    public void setImages(ImagesConfigProperties images) {
        this.images = images;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainConfig)) {
            return false;
        }
        MainConfig other = (MainConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        ResourceLoader this$resourceLoader = this.getResourceLoader();
        ResourceLoader other$resourceLoader = other.getResourceLoader();
        if (this$resourceLoader == null ? other$resourceLoader != null : !this$resourceLoader.equals(other$resourceLoader)) {
            return false;
        }
        PathsConfigProperties this$paths = this.getPaths();
        PathsConfigProperties other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !this$paths.equals(other$paths)) {
            return false;
        }
        ImagesConfigProperties this$images = this.getImages();
        ImagesConfigProperties other$images = other.getImages();
        return !(this$images == null ? other$images != null : !this$images.equals(other$images));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MainConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        ResourceLoader $resourceLoader = this.getResourceLoader();
        result = result * 59 + ($resourceLoader == null ? 43 : $resourceLoader.hashCode());
        PathsConfigProperties $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : $paths.hashCode());
        ImagesConfigProperties $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : $images.hashCode());
        return result;
    }

    public String toString() {
        return "MainConfig(contextPath=" + this.getContextPath() + ", baseUrl=" + this.getBaseUrl() + ", resourceLoader=" + this.getResourceLoader() + ", paths=" + this.getPaths() + ", images=" + this.getImages() + ")";
    }
}

