/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.confg;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.FileSize;
import de.unibamberg.minf.dme.confg.MainConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="log")
public class LogConfig {
    private static final Logger log = LoggerFactory.getLogger(LogConfig.class);
    @Autowired
    private MainConfig mainConfig;
    private String logFile = "dme.log";
    private String oldlogSuffix = "-%d{yyyy-MM-dd-HH-mm}-%i.log.gz";
    private String dir;
    private String pattern = "%d [%thread] %-5level %logger{36}[%line] - %msg%n";
    private int maxHistory = 90;
    private String totalSizeCap = "1GB";
    private String maxFileSize = "10MB";
    private boolean logQueries;

    @PostConstruct
    public void reconfigureLogging() throws IOException {
        log.debug("Reconfiguring logging...");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = lc.getStatusManager();
        if (statusManager != null) {
            statusManager.add((Status)new InfoStatus("Configuring logger", (Object)lc));
        }
        ch.qos.logback.classic.Logger rootLogger = lc.getLogger("ROOT");
        if (this.getDir() != null) {
            rootLogger.addAppender(this.configureRollingFileAppender((Context)lc));
        }
        this.logAppenderConfiguration(rootLogger);
    }

    private void logAppenderConfiguration(ch.qos.logback.classic.Logger rootLogger) {
        log.info("Logging reconfigured");
        Iterator appendersIterator = rootLogger.iteratorForAppenders();
        while (appendersIterator.hasNext()) {
            Appender configuredAppender = (Appender)appendersIterator.next();
            log.info("Configured appender: {}", (Object)configuredAppender.getClass().getName());
        }
    }

    private Appender<ILoggingEvent> configureRollingFileAppender(Context context) throws IOException {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName("FILE");
        appender.setContext(context);
        appender.setFile(this.setupLogFile(this.getDir(), new String[]{this.getLogFile()}));
        TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
        policy.setContext(context);
        policy.setMaxHistory(this.getMaxHistory());
        policy.setFileNamePattern(this.setupLogFile(this.getDir(), new String[]{this.getLogFile() + this.getOldlogSuffix()}));
        policy.setParent((FileAppender)appender);
        policy.start();
        SizeAndTimeBasedFNATP innerpolicy = new SizeAndTimeBasedFNATP();
        innerpolicy.setContext(context);
        innerpolicy.setMaxFileSize(FileSize.valueOf((String)this.getMaxFileSize()));
        innerpolicy.setTimeBasedRollingPolicy(policy);
        innerpolicy.start();
        policy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)innerpolicy);
        policy.start();
        appender.setRollingPolicy((RollingPolicy)policy);
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext(context);
        pl.setPattern(this.getPattern());
        pl.start();
        appender.setEncoder((Encoder)pl);
        log.info("RollingFileAppender logging to file: {}", (Object)appender.getFile());
        appender.start();
        return appender;
    }

    private String setupLogFile(String first, String ... more) throws IOException {
        Path p = Paths.get(first, more);
        if (!Files.exists(p.getParent(), new LinkOption[0])) {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
        return p.toString();
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getOldlogSuffix() {
        return this.oldlogSuffix;
    }

    public String getDir() {
        return this.dir;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public String getTotalSizeCap() {
        return this.totalSizeCap;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean isLogQueries() {
        return this.logQueries;
    }

    public void setMainConfig(MainConfig mainConfig) {
        this.mainConfig = mainConfig;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setOldlogSuffix(String oldlogSuffix) {
        this.oldlogSuffix = oldlogSuffix;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public void setTotalSizeCap(String totalSizeCap) {
        this.totalSizeCap = totalSizeCap;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setLogQueries(boolean logQueries) {
        this.logQueries = logQueries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogConfig)) {
            return false;
        }
        LogConfig other = (LogConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxHistory() != other.getMaxHistory()) {
            return false;
        }
        if (this.isLogQueries() != other.isLogQueries()) {
            return false;
        }
        MainConfig this$mainConfig = this.getMainConfig();
        MainConfig other$mainConfig = other.getMainConfig();
        if (this$mainConfig == null ? other$mainConfig != null : !this$mainConfig.equals(other$mainConfig)) {
            return false;
        }
        String this$logFile = this.getLogFile();
        String other$logFile = other.getLogFile();
        if (this$logFile == null ? other$logFile != null : !this$logFile.equals(other$logFile)) {
            return false;
        }
        String this$oldlogSuffix = this.getOldlogSuffix();
        String other$oldlogSuffix = other.getOldlogSuffix();
        if (this$oldlogSuffix == null ? other$oldlogSuffix != null : !this$oldlogSuffix.equals(other$oldlogSuffix)) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$totalSizeCap = this.getTotalSizeCap();
        String other$totalSizeCap = other.getTotalSizeCap();
        if (this$totalSizeCap == null ? other$totalSizeCap != null : !this$totalSizeCap.equals(other$totalSizeCap)) {
            return false;
        }
        String this$maxFileSize = this.getMaxFileSize();
        String other$maxFileSize = other.getMaxFileSize();
        return !(this$maxFileSize == null ? other$maxFileSize != null : !this$maxFileSize.equals(other$maxFileSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxHistory();
        result = result * 59 + (this.isLogQueries() ? 79 : 97);
        MainConfig $mainConfig = this.getMainConfig();
        result = result * 59 + ($mainConfig == null ? 43 : $mainConfig.hashCode());
        String $logFile = this.getLogFile();
        result = result * 59 + ($logFile == null ? 43 : $logFile.hashCode());
        String $oldlogSuffix = this.getOldlogSuffix();
        result = result * 59 + ($oldlogSuffix == null ? 43 : $oldlogSuffix.hashCode());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $totalSizeCap = this.getTotalSizeCap();
        result = result * 59 + ($totalSizeCap == null ? 43 : $totalSizeCap.hashCode());
        String $maxFileSize = this.getMaxFileSize();
        result = result * 59 + ($maxFileSize == null ? 43 : $maxFileSize.hashCode());
        return result;
    }

    public String toString() {
        return "LogConfig(mainConfig=" + this.getMainConfig() + ", logFile=" + this.getLogFile() + ", oldlogSuffix=" + this.getOldlogSuffix() + ", dir=" + this.getDir() + ", pattern=" + this.getPattern() + ", maxHistory=" + this.getMaxHistory() + ", totalSizeCap=" + this.getTotalSizeCap() + ", maxFileSize=" + this.getMaxFileSize() + ", logQueries=" + this.isLogQueries() + ")";
    }
}

