/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.confg;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="debug")
public class DebugConfig {
    private boolean processing;
    private int samplesMaxTravelSize = 10000;

    public boolean isProcessing() {
        return this.processing;
    }

    public int getSamplesMaxTravelSize() {
        return this.samplesMaxTravelSize;
    }

    public void setProcessing(boolean processing) {
        this.processing = processing;
    }

    public void setSamplesMaxTravelSize(int samplesMaxTravelSize) {
        this.samplesMaxTravelSize = samplesMaxTravelSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugConfig)) {
            return false;
        }
        DebugConfig other = (DebugConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isProcessing() != other.isProcessing()) {
            return false;
        }
        return this.getSamplesMaxTravelSize() == other.getSamplesMaxTravelSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebugConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProcessing() ? 79 : 97);
        result = result * 59 + this.getSamplesMaxTravelSize();
        return result;
    }

    public String toString() {
        return "DebugConfig(processing=" + this.isProcessing() + ", samplesMaxTravelSize=" + this.getSamplesMaxTravelSize() + ")";
    }
}

