/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.confg;

import de.unibamberg.minf.core.web.controller.ImageController;
import de.unibamberg.minf.dme.profiles.UserProfileActionHandler;
import eu.dariah.de.dariahsp.ProfileActionHandler;
import eu.dariah.de.dariahsp.web.controller.CommonLoginController;
import eu.dariah.de.dariahsp.web.controller.SAMLMetadataController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private String contextPath = "";

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Bean
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> servletContainerCustomizer() {
        log.info("Web server context path set to {}", (Object)(this.contextPath.isEmpty() ? "/" : this.contextPath));
        return container -> container.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
            context.setReloadable(false);
            context.setPath(this.contextPath);
        }});
    }

    @Bean
    public TomcatServletWebServerFactory tomcatFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public ProfileActionHandler profileActionPostprocessor() {
        return new UserProfileActionHandler();
    }

    @Bean
    public SAMLMetadataController samlMetadataController() {
        return new SAMLMetadataController();
    }

    @Bean
    public CommonLoginController loginLogoutController() {
        return new CommonLoginController("common/login");
    }

    @Bean
    public ImageController imageController() {
        return new ImageController();
    }
}

